/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;

public class DBGpCommand {
    private static final String id = " -i ";
    public static final String status = "status";
    public static final String featureGet = "feature_get";
    public static final String featureSet = "feature_set";
    public static final String run = "run";
    public static final String stepInto = "step_into";
    public static final String stepOver = "step_over";
    public static final String StepOut = "step_out";
    public static final String stop = "stop";
    public static final String detach = "detach";
    public static final String breakPointSet = "breakpoint_set";
    public static final String breakPointGet = "breakpoint_get";
    public static final String breakPointUpdate = "breakpoint_update";
    public static final String breakPointRemove = "breakpoint_remove";
    public static final String breakPointList = "breakpoint_list";
    public static final String stackDepth = "stack-depth";
    public static final String stackGet = "stack_get";
    public static final String propSet = "property_set";
    public static final String propGet = "property_get";
    public static final String propValue = "property_value";
    public static final String contextGet = "context_get";
    public static final String eval = "eval";
    public static final String stdout = "stdout";
    public static final String stderr = "stderr";
    public static final String suspend = "break";
    Socket socket;
    OutputStreamWriter outStream;
    private static int trId = 0;
    private static Object idMonitor = new Object();
    private int lastIdSent;
    private String lastCmdSent;

    public DBGpCommand(Socket socket) {
        this.socket = socket;
    }

    public int send(String string, String string2, int n, String string3) throws IOException {
        try {
            return this.writeToStream(string, string2, n, string3);
        }
        catch (IOException iOException) {
            DBGpLogger.logException(null, this, iOException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextId() {
        Object object = idMonitor;
        synchronized (object) {
            if (++trId < 0) {
                trId = 1;
            }
        }
        return trId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToStream(String string, String string2, int n, String string3) throws IOException {
        String string4 = String.valueOf(string) + id + n;
        if (string2 != null) {
            string4 = String.valueOf(string4) + " " + string2;
        }
        if (DBGpLogger.debugCmd()) {
            DBGpLogger.debug("cmd: " + string4);
        }
        Socket socket = this.socket;
        synchronized (socket) {
            OutputStream outputStream = this.socket.getOutputStream();
            outputStream.write(string4.getBytes(string3));
            outputStream.write(0);
            outputStream.flush();
        }
        this.lastIdSent = n;
        this.lastCmdSent = string4;
        return n;
    }

    public int getLastIdSent() {
        return this.lastIdSent;
    }
}

