/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.ParsingErrorNotification;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class ParsingErrorNotificationHandler
implements IDebugMessageHandler {
    private static final Pattern EVALD_CODE_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : eval\\(\\)'d code");

    public void handle(IDebugMessage iDebugMessage, PHPDebugTarget pHPDebugTarget) {
        ParsingErrorNotification parsingErrorNotification = (ParsingErrorNotification)iDebugMessage;
        IDebugHandler iDebugHandler = pHPDebugTarget.getRemoteDebugger().getDebugHandler();
        String string = parsingErrorNotification.getErrorText();
        int n = parsingErrorNotification.getLineNumber();
        int n2 = parsingErrorNotification.getErrorLevel();
        String string2 = parsingErrorNotification.getFileName();
        Matcher matcher = EVALD_CODE_PATTERN.matcher(string2);
        if (matcher.matches()) {
            string2 = matcher.group(1);
            n = Integer.parseInt(matcher.group(2));
        }
        DebugError debugError = new DebugError(n2, string2, n, string);
        iDebugHandler.parsingErrorOccured(debugError);
    }
}

