/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.model.BreakpointSet;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugHandlersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.ContextManager;
import org.eclipse.php.internal.debug.core.zend.model.PHPResponseHandler;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.ServerDebugHandler;
import org.eclipse.php.internal.debug.core.zend.model.StartLock;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPDebugTarget
extends PHPDebugElement
implements IDebugTarget,
IBreakpointManagerListener {
    private ContextManager fContextManager;
    protected ILaunch fLaunch;
    protected IProcess fProcess;
    protected String fName;
    protected String fURL;
    protected int fRequestPort;
    protected DebugOutput fOutput = new DebugOutput();
    protected boolean fSuspended = false;
    protected boolean fTerminated = false;
    protected boolean fTermainateCalled = false;
    protected PHPThread fThread;
    protected IThread[] fThreads;
    protected IRemoteDebugger debugger;
    protected String fLastcmd;
    protected boolean fStatus;
    protected int fLastStop;
    protected String fLastFileName;
    protected boolean fIsPHPCGI;
    protected boolean fIsRunAsDebug;
    protected PHPResponseHandler fPHPResponseHandler;
    protected Debugger.StartResponseHandler fStartResponseHandler;
    protected Debugger.BreakpointAddedResponseHandler fBreakpointAddedResponseHandler;
    protected Debugger.BreakpointRemovedResponseHandler fBreakpointRemovedResponseHandler;
    protected Debugger.StepIntoResponseHandler fStepIntoResponseHandler;
    protected Debugger.StepOverResponseHandler fStepOverResponseHandler;
    protected Debugger.StepOutResponseHandler fStepOutResponseHandler;
    protected Debugger.GoResponseHandler fGoResponseHandler;
    protected Debugger.PauseResponseHandler fPauseResponseHandler;
    protected DefaultExpressionsManager expressionsManager;
    protected String fWorkspacePath = "";
    protected IProject fProject;
    protected int fSuspendCount;
    protected Vector<IPHPConsoleEventListener> fConsoleEventListeners = new Vector();
    protected Vector<DebugError> fDebugError = new Vector();
    protected StartLock fStartLock = new StartLock();
    protected BreakpointSet fBreakpointSet;
    protected IBreakpointManager fBreakpointManager;
    protected boolean fIsServerWindows = false;
    protected DebugConnectionThread fConnectionThread;

    public PHPDebugTarget(DebugConnectionThread debugConnectionThread, ILaunch iLaunch, String string, int n, IProcess iProcess, boolean bl, boolean bl2, IProject iProject) throws CoreException {
        super(null);
        this.fConnectionThread = debugConnectionThread;
        this.fURL = string;
        this.fIsPHPCGI = false;
        this.initDebugTarget(iLaunch, n, iProcess, bl, bl2, iProject);
    }

    public PHPDebugTarget(DebugConnectionThread debugConnectionThread, ILaunch iLaunch, String string, IFile iFile, int n, IProcess iProcess, boolean bl, boolean bl2, IProject iProject) throws CoreException {
        this(debugConnectionThread, iLaunch, string, iFile.getName(), PHPDebugTarget.getWorkspaceRootPath(iFile.getWorkspace()), n, iProcess, bl, bl2, iProject);
    }

    public static String getWorkspaceRootPath(IWorkspace iWorkspace) {
        return String.valueOf(iWorkspace.getRoot().getRawLocation().toOSString()) + "/";
    }

    public PHPDebugTarget(DebugConnectionThread debugConnectionThread, ILaunch iLaunch, String string, String string2, String string3, int n, IProcess iProcess, boolean bl, boolean bl2, IProject iProject) throws CoreException {
        super(null);
        this.fConnectionThread = debugConnectionThread;
        this.fName = string2;
        this.fWorkspacePath = string3;
        this.fIsPHPCGI = true;
        this.initDebugTarget(iLaunch, n, iProcess, bl, bl2, iProject);
    }

    public DebugConnectionThread getConnectionThread() {
        return this.fConnectionThread;
    }

    private void initDebugTarget(ILaunch iLaunch, int n, IProcess iProcess, boolean bl, boolean bl2, IProject iProject) throws CoreException {
        String string;
        this.fLaunch = iLaunch;
        this.fProcess = iProcess;
        this.fIsRunAsDebug = bl;
        this.fProject = iProject;
        this.fProcess.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
        ((PHPProcess)this.fProcess).setDebugTarget(this);
        this.fRequestPort = n;
        this.fBreakpointSet = new BreakpointSet(iProject, this.fIsPHPCGI);
        IDebugHandler iDebugHandler = null;
        IDebugParametersInitializer iDebugParametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(iLaunch);
        if (iDebugParametersInitializer != null && (string = iDebugParametersInitializer.getDebugHandler()) != null) {
            try {
                iDebugHandler = DebugHandlersRegistry.getHandler(string);
            }
            catch (Exception exception) {
                PHPDebugPlugin.log(exception);
            }
        }
        if (iDebugHandler == null) {
            iDebugHandler = new ServerDebugHandler();
        }
        iDebugHandler.setDebugTarget(this);
        this.debugger = iDebugHandler.getRemoteDebugger();
        this.fThread = new PHPThread(this);
        this.fThreads = new IThread[]{this.fThread};
        this.fTerminated = false;
        this.fPHPResponseHandler = new PHPResponseHandler(this);
        this.fStartResponseHandler = new PHPResponseHandler.StartResponseHandler(this.fPHPResponseHandler);
        this.fBreakpointAddedResponseHandler = new PHPResponseHandler.BreakpointAddedResponseHandler(this.fPHPResponseHandler);
        this.fBreakpointRemovedResponseHandler = new PHPResponseHandler.BreakpointRemovedResponseHandler(this.fPHPResponseHandler);
        this.fStepIntoResponseHandler = new PHPResponseHandler.StepIntoResponseHandler(this.fPHPResponseHandler);
        this.fStepOverResponseHandler = new PHPResponseHandler.StepOverResponseHandler(this.fPHPResponseHandler);
        this.fStepOutResponseHandler = new PHPResponseHandler.StepOutResponseHandler(this.fPHPResponseHandler);
        this.fGoResponseHandler = new PHPResponseHandler.GoResponseHandler(this.fPHPResponseHandler);
        this.fPauseResponseHandler = new PHPResponseHandler.PauseResponseHandler(this.fPHPResponseHandler);
        this.fSuspendCount = 0;
        this.fContextManager = new ContextManager(this, this.debugger);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.debugger;
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return !this.fTerminated && this.fThreads.length > 0;
    }

    public String getName() throws DebugException {
        if (this.fName == null) {
            this.fName = this.fURL;
        }
        return this.fName;
    }

    public String getURL() {
        return this.fURL;
    }

    int getLastStop() {
        return this.fLastStop;
    }

    String getLastFileName() {
        return this.fLastFileName;
    }

    int getSuspendCount() {
        return this.fSuspendCount;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        if (iBreakpoint.getModelIdentifier().equals("org.eclipse.php.debug.core")) {
            boolean bl = this.fBreakpointSet.supportsBreakpoint(iBreakpoint);
            return bl;
        }
        return false;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        StartLock startLock = this.getStartLock();
        if (!startLock.isStarted()) {
            this.terminated();
            this.fTermainateCalled = true;
            return;
        }
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fTerminated = true;
        this.fSuspended = false;
        this.fLastcmd = "terminate";
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Calling closeDebugSession()");
        this.debugger.closeDebugSession();
        this.terminated();
        this.fTermainateCalled = true;
    }

    public void terminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Calling debugger.closeConnection();");
        if (!this.fTermainateCalled) {
            this.debugger.closeConnection();
        }
        this.completeTerminated();
        PHPSessionLaunchMapper.updateSystemProperty(DebugPlugin.getDefault().getLaunchManager().getLaunches());
    }

    private void completeTerminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        this.fThreads = new IThread[0];
        try {
            this.fProcess.terminate();
        }
        catch (DebugException debugException) {}
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Calling removeBreakpointListener(this);");
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Firing terminate");
        this.fireTerminateEvent();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage == null) {
                    return;
                }
                AbstractDebugView abstractDebugView = (AbstractDebugView)iWorkbenchPage.findView("org.eclipse.debug.ui.DebugView");
                if (abstractDebugView == null) {
                    return;
                }
                abstractDebugView.getViewer().refresh();
            }
        });
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.fLastcmd = "resume";
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fStatus = this.debugger.go(this.fGoResponseHandler);
        if (!this.fStatus) {
            Logger.log(4, "PHPDebugTarget: debugger.go return false");
        }
        int n = 32;
        this.resumed(n);
    }

    private void resumed(int n) {
        this.fSuspended = false;
        this.fThread.fireResumeEvent(n);
    }

    public void suspended(int n) {
        this.fSuspended = true;
        ++this.fSuspendCount;
        System.setProperty("org.eclipse.debugger.variables", "true");
        try {
            ((PHPThread)this.getThreads()[0]).setStepping(false);
        }
        catch (DebugException debugException) {}
        this.fThread.fireSuspendEvent(n);
    }

    public void suspend() throws DebugException {
        this.fLastcmd = "suspend";
        ((PHPThread)this.getThreads()[0]).setStepping(false);
        this.fStatus = this.debugger.pause(this.fPauseResponseHandler);
        if (!this.fStatus) {
            Logger.log(4, "PHPDebugTarget: debugger.pause return false");
        }
        int n = 32;
        this.suspended(n);
    }

    public static IBreakpoint createBreakpoint(IResource iResource, int n) throws CoreException {
        return PHPDebugTarget.createBreakpoint(iResource, n, new HashMap<String, String>(10));
    }

    public static IBreakpoint createBreakpoint(IResource iResource, int n, Map<String, String> map) throws CoreException {
        PHPConditionalBreakpoint pHPConditionalBreakpoint = null;
        try {
            pHPConditionalBreakpoint = new PHPConditionalBreakpoint(iResource, n, map);
        }
        catch (CoreException coreException) {
            Logger.logException("PHPDebugTarget: error creating breakpoint", coreException);
            throw coreException;
        }
        return pHPConditionalBreakpoint;
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                if (iBreakpoint.isEnabled()) {
                    Object object;
                    this.fLastcmd = "breakpointAdded";
                    PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint;
                    IMarker iMarker = pHPLineBreakpoint.getMarker();
                    IResource iResource = null;
                    Breakpoint breakpoint = pHPLineBreakpoint.getRuntimeBreakpoint();
                    int n = breakpoint.getLineNumber();
                    if (iBreakpoint instanceof PHPRunToLineBreakpoint) {
                        object = (PHPRunToLineBreakpoint)iBreakpoint;
                        iResource = object.getSourceFile();
                    } else {
                        iResource = iMarker.getResource();
                        n = iMarker.getAttribute("lineNumber", 0);
                        breakpoint.setLineNumber(n);
                    }
                    if (!this.fIsPHPCGI) {
                        if (iResource instanceof ExternalFileWrapper) {
                            object = iResource.getFullPath().toOSString();
                        } else if (iResource instanceof IWorkspaceRoot) {
                            if ("org.eclipse.php.debug.core.Remote".equals(iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type"))) {
                                object = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                                object = iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", (String)object);
                            } else {
                                String string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                                if ("org.eclipse.php.debug.core.Include".equals(iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type"))) {
                                    string = iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", string);
                                }
                                object = RemoteDebugger.convertToRemoteFilename(string, this);
                            }
                        } else {
                            object = RemoteDebugger.convertToRemoteFilename(iResource.getFullPath().toString(), this);
                        }
                    } else if (iResource instanceof ExternalFileWrapper) {
                        object = iResource.getFullPath().toOSString();
                    } else if (iResource instanceof IWorkspaceRoot) {
                        object = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                        if ("org.eclipse.php.debug.core.Include".equals(iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type"))) {
                            object = iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", (String)object);
                        }
                    } else {
                        IPath iPath = iResource.getRawLocation();
                        object = iPath == null ? iResource.getFullPath().toOSString() : iPath.toOSString();
                    }
                    breakpoint.setFileName((String)object);
                    Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Setting Breakpoint - File " + (String)object + " Line Number " + n);
                    this.debugger.addBreakpoint(pHPLineBreakpoint.getRuntimeBreakpoint(), this.fBreakpointAddedResponseHandler);
                }
            }
            catch (CoreException coreException) {
                Logger.logException("PHPDebugTarget: Exception Adding Breakpoint", coreException);
            }
        }
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (this.supportsBreakpoint(iBreakpoint)) {
            if (iBreakpoint instanceof PHPRunToLineBreakpoint) {
                return;
            }
            this.fLastcmd = "breakpointRemoved";
            PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint;
            Breakpoint breakpoint = pHPLineBreakpoint.getRuntimeBreakpoint();
            Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Removing Breakpoint - File " + breakpoint.getFileName() + " Line Number " + breakpoint.getLineNumber());
            this.fStatus = this.debugger.removeBreakpoint(breakpoint, this.fBreakpointRemovedResponseHandler);
            if (!this.fStatus && this.debugger.isActive()) {
                Logger.log(4, "PHPDebugTarget: debugger.removeBreakpoint return false");
            }
        }
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (!this.fBreakpointManager.isEnabled()) {
            return;
        }
        int n = iMarkerDelta.getAttribute("lineNumber", 0);
        IMarker iMarker = iBreakpoint.getMarker();
        int n2 = iMarker.getAttribute("lineNumber", 0);
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                if (((PHPLineBreakpoint)iBreakpoint).isConditionChanged()) {
                    ((PHPLineBreakpoint)iBreakpoint).setConditionChanged(false);
                    if (iBreakpoint.isEnabled()) {
                        this.breakpointRemoved(iBreakpoint, null);
                    } else {
                        return;
                    }
                }
                if (n2 != n) {
                    if (iBreakpoint.isEnabled()) {
                        this.breakpointRemoved(iBreakpoint, null);
                    } else {
                        return;
                    }
                }
                if (iBreakpoint.isEnabled()) {
                    this.breakpointAdded(iBreakpoint);
                } else {
                    this.breakpointRemoved(iBreakpoint, null);
                }
            }
            catch (CoreException coreException) {
                Logger.logException("PHPDebugTarget: Exception Changing Breakpoint", coreException);
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public void started() {
        this.fSuspended = false;
        this.fireCreationEvent();
    }

    public void installDeferredBreakpoints() throws CoreException {
    }

    protected IStackFrame[] getStackFrames() throws DebugException {
        return this.fContextManager.getStackFrames();
    }

    public DefaultExpressionsManager getExpressionManager() {
        return this.expressionsManager;
    }

    public void setExpressionManager(DefaultExpressionsManager defaultExpressionsManager) {
        this.expressionsManager = defaultExpressionsManager;
    }

    public Expression[] getStackVariables(PHPStackFrame pHPStackFrame) {
        return this.fContextManager.getStackVariables(pHPStackFrame);
    }

    protected void stepReturn() throws DebugException {
        this.fLastcmd = "stepReturn";
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: stepReturn ");
        int n = 4;
        this.resumed(n);
        this.fStatus = this.debugger.stepOut(this.fStepOutResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepOut return false");
        }
    }

    protected void stepOver() throws DebugException {
        this.fLastcmd = "stepOver";
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: stepOver");
        int n = 2;
        this.resumed(n);
        this.fStatus = this.debugger.stepOver(this.fStepOverResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepOver return false");
        }
    }

    protected void stepInto() throws DebugException {
        Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: stepInto ");
        this.fLastcmd = "stepInto";
        int n = 1;
        this.resumed(n);
        this.fStatus = this.debugger.stepInto(this.fStepIntoResponseHandler);
        if (!this.fStatus) {
            Logger.log(204, "PHPDebugTarget: debugger.stepInto return false");
        }
    }

    public IVariable[] getVariables() {
        return this.fContextManager.getVariables();
    }

    public void breakpointHit(String string, int n) {
        IBreakpoint iBreakpoint = this.findBreakpoint(string, n);
        if (iBreakpoint != null) {
            this.fThread.setBreakpoints(new IBreakpoint[]{iBreakpoint});
        } else {
            this.fThread.setBreakpoints(new IBreakpoint[0]);
        }
        this.suspended(16);
    }

    protected IBreakpoint findBreakpoint(String string, int n) {
        IBreakpoint[] iBreakpointArray;
        IBreakpoint[] iBreakpointArray2 = iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.php.debug.core");
        int n2 = iBreakpointArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IBreakpoint iBreakpoint = iBreakpointArray2[n3];
            if (this.supportsBreakpoint(iBreakpoint) && iBreakpoint instanceof PHPLineBreakpoint) {
                PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint;
                Breakpoint breakpoint = pHPLineBreakpoint.getRuntimeBreakpoint();
                String string2 = breakpoint.getFileName();
                int n4 = breakpoint.getLineNumber();
                if (n4 == n && string2.equals(string)) {
                    return iBreakpoint;
                }
            }
            ++n3;
        }
        return null;
    }

    public void breakpointManagerEnablementChanged(boolean bl) {
        IBreakpoint[] iBreakpointArray;
        IBreakpoint[] iBreakpointArray2 = iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray2[n2];
            if (this.supportsBreakpoint(iBreakpoint)) {
                if (bl) {
                    ((PHPLineBreakpoint)iBreakpoint).setConditionChanged(false);
                    this.breakpointAdded(iBreakpoint);
                } else {
                    this.breakpointRemoved(iBreakpoint, null);
                }
            }
            ++n2;
        }
    }

    public void addConsoleEventListener(IPHPConsoleEventListener iPHPConsoleEventListener) {
        if (!this.fConsoleEventListeners.contains(iPHPConsoleEventListener)) {
            this.fConsoleEventListeners.add(iPHPConsoleEventListener);
        }
        if (this.fDebugError != null) {
            Enumeration<DebugError> enumeration = this.fDebugError.elements();
            boolean bl = this.fDebugError.isEmpty();
            if (!bl) {
                while (enumeration.hasMoreElements()) {
                    DebugError debugError = enumeration.nextElement();
                    iPHPConsoleEventListener.handleEvent(debugError);
                }
            }
        }
    }

    public void removeConsoleEventListener(IPHPConsoleEventListener iPHPConsoleEventListener) {
        this.fConsoleEventListeners.remove(iPHPConsoleEventListener);
    }

    public List<IPHPConsoleEventListener> getConsoleEventListeners() {
        return this.fConsoleEventListeners;
    }

    public DebugOutput getOutputBufffer() {
        return this.fOutput;
    }

    public boolean isRunWithDebug() {
        return this.fIsRunAsDebug;
    }

    public void fireError(String string, Exception exception) {
        Status status = new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)exception);
        DebugEvent debugEvent = new DebugEvent((Object)this, 32);
        debugEvent.setData((Object)status);
        this.fireEvent(debugEvent);
    }

    public void fireError(IStatus iStatus) {
        DebugEvent debugEvent = new DebugEvent((Object)this, 32);
        debugEvent.setData((Object)iStatus);
        this.fireEvent(debugEvent);
    }

    public void setLastStop(int n) {
        this.fLastStop = n;
    }

    public void setLastFileName(String string) {
        this.fLastFileName = string;
    }

    public void setBreakpoints(IBreakpoint[] iBreakpointArray) {
        this.fThread.setBreakpoints(new IBreakpoint[0]);
    }

    public boolean isPHPCGI() {
        return this.fIsPHPCGI;
    }

    public StartLock getStartLock() {
        return this.fStartLock;
    }

    public void setLastCommand(String string) {
        this.fLastcmd = string;
    }

    public String getLastCommand() {
        return this.fLastcmd;
    }

    public int getRequestPort() {
        return this.fRequestPort;
    }

    public String getWorkspacePath() {
        return this.fWorkspacePath;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public List<DebugError> getDebugErrors() {
        return this.fDebugError;
    }

    public boolean isServerWindows() {
        return this.fIsServerWindows;
    }

    public void setServerWindows(boolean bl) {
        this.fIsServerWindows = bl;
    }

    public Debugger.StartResponseHandler getStartResponseHandler() {
        return this.fStartResponseHandler;
    }

    @Override
    public String toString() {
        String string = ((Object)((Object)this)).getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return String.valueOf(string) + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    public ContextManager getContextManager() {
        return this.fContextManager;
    }

    public IBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    public PathEntry mapFirstDebugFile(String string) {
        block14: {
            if (this.getContextManager().isResolveBlacklisted(string)) {
                return null;
            }
            try {
                IResource iResource;
                String string2;
                ILaunchConfiguration iLaunchConfiguration = this.getLaunch().getLaunchConfiguration();
                PathMapper pathMapper = PathMapperRegistry.getByLaunchConfiguration(iLaunchConfiguration);
                if (pathMapper == null) break block14;
                PathEntry pathEntry = pathMapper.getLocalFile(string);
                if (pathEntry == null) {
                    string2 = iLaunchConfiguration.getAttribute("file_name", null);
                    if (string2 == null) {
                        string2 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
                    }
                    if (string2 != null) {
                        iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string2);
                        if (iResource instanceof IFile) {
                            pathEntry = new PathEntry(string2, PathEntry.Type.WORKSPACE, (Object)iResource.getParent());
                        } else if (new File(string2).exists()) {
                            pathEntry = new PathEntry(string2, PathEntry.Type.EXTERNAL, (Object)new File(string2).getParentFile());
                        }
                    }
                    if (pathEntry != null) {
                        pathMapper.addEntry(string, pathEntry);
                        PathMapperRegistry.storeToPreferences();
                    } else {
                        pathEntry = DebugSearchEngine.find(string, this);
                    }
                }
                if (this.getProject() == null && pathEntry != null && pathEntry.getType() == PathEntry.Type.WORKSPACE) {
                    string2 = ResourcesPlugin.getWorkspace().getRoot().findMember(pathEntry.getPath());
                    iResource = string2.getProject();
                    this.setProject((IProject)iResource);
                    try {
                        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
                        iLaunchConfigurationWorkingCopy.getAttribute("org.eclipse.php.debug.core.PHP_Project", iResource.getName());
                        iLaunchConfigurationWorkingCopy.doSave();
                    }
                    catch (CoreException coreException) {
                        PHPDebugPlugin.log(coreException);
                    }
                }
                return pathEntry;
            }
            catch (Exception exception) {
                PHPDebugPlugin.log(exception);
            }
        }
        return null;
    }
}

