/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.JSFUIPlugin;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.ColumnTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.CommandButtonTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.CommandLinkTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.DataTableTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.GraphicImageTagConveter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.InputTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.InputTextAreaTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.JSFFormTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.OutputLabelTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.OutputLinkTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.OutputTextTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.PanelGridTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.PanelGroupTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectBooleanCheckboxTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectManyListboxTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectManyMenuTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectOneListboxTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.SelectOneMenuTagConverter;
import org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml.TableBasedSelectTagConverter;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class JSFHTMLConverterFactory
implements IConverterFactory {
    private final MyLabelProvider _labelProvider = new MyLabelProvider();
    private static final Set _dtConversionSupported = new HashSet();

    public ITagConverter createConverter(Element element, int mode) {
        Object converter;
        String tagName = element.getLocalName();
        if (_dtConversionSupported.contains(tagName)) {
            converter = this.createDTTagConverter(element);
        } else if ("column".equalsIgnoreCase(tagName)) {
            converter = new ColumnTagConverter(element);
        } else if ("commandButton".equalsIgnoreCase(tagName)) {
            converter = new CommandButtonTagConverter(element);
        } else if ("commandLink".equalsIgnoreCase(tagName)) {
            converter = new CommandLinkTagConverter(element);
        } else if ("dataTable".equalsIgnoreCase(tagName)) {
            converter = new DataTableTagConverter(element);
        } else if ("form".equalsIgnoreCase(tagName)) {
            converter = new JSFFormTagConverter(element);
        } else if ("graphicImage".equalsIgnoreCase(tagName)) {
            converter = new GraphicImageTagConveter(element);
        } else {
            if ("inputHidden".equalsIgnoreCase(tagName)) {
                return new HiddenTagConverter(element, (ILabelProvider)this._labelProvider);
            }
            if ("inputSecret".equalsIgnoreCase(tagName)) {
                converter = new InputTagConverter(element, "password");
            } else if ("inputText".equalsIgnoreCase(tagName)) {
                converter = new InputTagConverter(element, "text");
            } else if ("inputTextarea".equalsIgnoreCase(tagName)) {
                converter = new InputTextAreaTagConverter(element);
            } else if ("message".equalsIgnoreCase(tagName) || "messages".equalsIgnoreCase(tagName)) {
                converter = new HiddenTagConverter(element, (ILabelProvider)this._labelProvider);
            } else if ("outputText".equalsIgnoreCase(tagName) || "outputFormat".equalsIgnoreCase(tagName)) {
                converter = new OutputTextTagConverter(element);
            } else if ("outputLabel".equalsIgnoreCase(tagName)) {
                converter = new OutputLabelTagConverter(element);
            } else if ("outputLink".equalsIgnoreCase(tagName)) {
                converter = new OutputLinkTagConverter(element);
            } else if ("panelGrid".equalsIgnoreCase(tagName)) {
                converter = new PanelGridTagConverter(element);
            } else if ("panelGroup".equalsIgnoreCase(tagName)) {
                converter = new PanelGroupTagConverter(element);
            } else if ("selectBooleanCheckbox".equalsIgnoreCase(tagName)) {
                converter = new SelectBooleanCheckboxTagConverter(element);
            } else if ("selectManyCheckbox".equalsIgnoreCase(tagName)) {
                converter = new TableBasedSelectTagConverter(element, "checkbox");
            } else if ("selectManyListbox".equalsIgnoreCase(tagName)) {
                converter = new SelectManyListboxTagConverter(element);
            } else if ("selectManyMenu".equalsIgnoreCase(tagName)) {
                converter = new SelectManyMenuTagConverter(element);
            } else if ("selectOneListbox".equalsIgnoreCase(tagName)) {
                converter = new SelectOneListboxTagConverter(element);
            } else if ("selectOneMenu".equalsIgnoreCase(tagName)) {
                converter = new SelectOneMenuTagConverter(element);
            } else if ("selectOneRadio".equalsIgnoreCase(tagName)) {
                converter = new TableBasedSelectTagConverter(element, "radio");
            } else {
                return null;
            }
        }
        converter.setMode(mode);
        return converter;
    }

    private static Image getJSFHTMLImage(String tagName) {
        Image image = JSFUIPlugin.getDefault().getImage("palette/JSFHTML/small/JSF_" + tagName.toUpperCase() + ".gif");
        return image;
    }

    public String getSupportedURI() {
        return "http://java.sun.com/jsf/html";
    }

    private ITagConverter createDTTagConverter(Element element) {
        return new DTTagConverter(element);
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ITagConverter) {
                Element hostElement = ((ITagConverter)element).getHostElement();
                String tagName = hostElement.getLocalName();
                return JSFHTMLConverterFactory.getJSFHTMLImage(tagName);
            }
            return null;
        }
    }
}

