/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.opengl.carbon.AGL;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLCanvas
extends Canvas {
    int context;
    int pixelFormat;
    static final int MAX_ATTRIBUTES = 32;
    static final String RESET_VISIBLE_REGION = "org.eclipse.swt.internal.resetVisibleRegion";

    public GLCanvas(Composite parent, int style, GLData data) {
        super(parent, style);
        if (data == null) {
            SWT.error(4);
        }
        int[] aglAttrib = new int[32];
        int pos = 0;
        aglAttrib[pos++] = 4;
        if (data.doubleBuffer) {
            aglAttrib[pos++] = 5;
        }
        if (data.stereo) {
            aglAttrib[pos++] = 6;
        }
        if (data.redSize > 0) {
            aglAttrib[pos++] = 8;
            aglAttrib[pos++] = data.redSize;
        }
        if (data.greenSize > 0) {
            aglAttrib[pos++] = 9;
            aglAttrib[pos++] = data.greenSize;
        }
        if (data.blueSize > 0) {
            aglAttrib[pos++] = 10;
            aglAttrib[pos++] = data.blueSize;
        }
        if (data.alphaSize > 0) {
            aglAttrib[pos++] = 11;
            aglAttrib[pos++] = data.alphaSize;
        }
        if (data.depthSize > 0) {
            aglAttrib[pos++] = 12;
            aglAttrib[pos++] = data.depthSize;
        }
        if (data.stencilSize > 0) {
            aglAttrib[pos++] = 13;
            aglAttrib[pos++] = data.stencilSize;
        }
        if (data.accumRedSize > 0) {
            aglAttrib[pos++] = 14;
            aglAttrib[pos++] = data.accumRedSize;
        }
        if (data.accumGreenSize > 0) {
            aglAttrib[pos++] = 15;
            aglAttrib[pos++] = data.accumGreenSize;
        }
        if (data.accumBlueSize > 0) {
            aglAttrib[pos++] = 16;
            aglAttrib[pos++] = data.accumBlueSize;
        }
        if (data.accumAlphaSize > 0) {
            aglAttrib[pos++] = 17;
            aglAttrib[pos++] = data.accumAlphaSize;
        }
        if (data.sampleBuffers > 0) {
            aglAttrib[pos++] = 55;
            aglAttrib[pos++] = data.sampleBuffers;
        }
        if (data.samples > 0) {
            aglAttrib[pos++] = 56;
            aglAttrib[pos++] = data.samples;
        }
        aglAttrib[pos++] = 0;
        this.pixelFormat = AGL.aglChoosePixelFormat(0, 0, aglAttrib);
        if (this.pixelFormat == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.context = AGL.aglCreateContext(this.pixelFormat, 0);
        int window = OS.GetControlOwner(this.handle);
        int port = OS.GetWindowPort(window);
        AGL.aglSetDrawable(this.context, port);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        AGL.aglDestroyContext(GLCanvas.this.context);
                        AGL.aglDestroyPixelFormat(GLCanvas.this.pixelFormat);
                    }
                }
            }
        };
        this.addListener(12, listener);
        this.setData(RESET_VISIBLE_REGION, new Runnable(){

            public void run() {
                if (GLCanvas.this.isDisposed()) {
                    return;
                }
                GLCanvas.this.fixBounds();
            }
        });
    }

    void fixBounds() {
        Rect bounds = new Rect();
        OS.GetControlBounds(this.handle, bounds);
        int window = OS.GetControlOwner(this.handle);
        int[] contentView = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
        CGPoint pt = new CGPoint();
        OS.HIViewConvertPoint(pt, OS.HIViewGetSuperview(this.handle), contentView[0]);
        bounds.left = (short)(bounds.left + (int)pt.x);
        bounds.top = (short)(bounds.top + (int)pt.y);
        bounds.right = (short)(bounds.right + (int)pt.x);
        bounds.bottom = (short)(bounds.bottom + (int)pt.y);
        short x = bounds.left;
        short y = bounds.top;
        int width = bounds.right - bounds.left;
        int height = bounds.bottom - bounds.top;
        int port = OS.GetWindowPort(window);
        OS.GetPortBounds(port, bounds);
        int[] glbounds = new int[]{x, bounds.bottom - bounds.top - y - height, width, height};
        AGL.aglSetInteger(this.context, 202, glbounds);
        AGL.aglEnable(this.context, 202);
        GCData data = new GCData();
        int gc = this.internal_new_GC(data);
        AGL.aglSetInteger(this.context, 254, data.visibleRgn);
        AGL.aglEnable(this.context, 254);
        this.internal_dispose_GC(gc, data);
    }

    public GLData getGLData() {
        this.checkWidget();
        GLData data = new GLData();
        int[] value = new int[1];
        AGL.aglDescribePixelFormat(this.pixelFormat, 5, value);
        data.doubleBuffer = value[0] != 0;
        AGL.aglDescribePixelFormat(this.pixelFormat, 6, value);
        data.stereo = value[0] != 0;
        AGL.aglDescribePixelFormat(this.pixelFormat, 8, value);
        data.redSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 9, value);
        data.greenSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 10, value);
        data.blueSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 11, value);
        data.alphaSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 12, value);
        data.depthSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 13, value);
        data.stencilSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 14, value);
        data.accumRedSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 15, value);
        data.accumGreenSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 16, value);
        data.accumBlueSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 17, value);
        data.accumAlphaSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 55, value);
        data.sampleBuffers = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 56, value);
        data.samples = value[0];
        return data;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return AGL.aglGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (AGL.aglGetCurrentContext() != this.context) {
            AGL.aglSetCurrentContext(this.context);
        }
    }

    public void swapBuffers() {
        this.checkWidget();
        AGL.aglSwapBuffers(this.context);
    }
}

