/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.classpath.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.internal.core.ClasspathEntry;

public class DriverClasspathContainer
implements IClasspathContainer {
    private String name;
    private DriverInstance mDriverInstance;

    public DriverClasspathContainer(String libName) {
        this.name = libName;
        this.mDriverInstance = DriverManager.getInstance().getDriverInstanceByName(this.name);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] entries = this.getEntries();
        if (entries != null) {
            return entries;
        }
        return new IClasspathEntry[0];
    }

    private IPath getPathForJavaIOFile(File inFile) {
        try {
            URL url = inFile.toURL();
            try {
                url = FileLocator.toFileURL((URL)url);
                Path path = new Path(url.getFile());
                return path;
            }
            catch (IOException iOException) {
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private IClasspathEntry[] getEntries() {
        ArrayList<ClasspathEntry> list = new ArrayList<ClasspathEntry>();
        for (int i = 0; i < this.mDriverInstance.getJarListAsArray().length; ++i) {
            String path = this.mDriverInstance.getJarListAsArray()[i];
            File file = new File(path);
            if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
            IPath jarPath = this.getPathForJavaIOFile(file);
            ClasspathEntry entry = new ClasspathEntry(1, 1, jarPath, new IPath[0], new IPath[0], null, null, null, true, new IAccessRule[0], false, new IClasspathAttribute[0]);
            list.add(entry);
        }
        if (list.size() > 0) {
            return list.toArray(new IClasspathEntry[list.size()]);
        }
        return new IClasspathEntry[0];
    }

    public String getDescription() {
        return this.name;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path("org.eclipse.datatools.connectivity.jdt.DRIVERLIBRARY").append(this.name);
    }
}

