/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JREResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectSystemLibraryQuickFix
extends JREResolution {
    private IPath fOldPath;
    private IJavaProject fProject;

    public SelectSystemLibraryQuickFix(IPath oldPath, IJavaProject project) {
        this.fOldPath = oldPath;
        this.fProject = project;
    }

    public void run(IMarker marker) {
        try {
            this.handleContainerResolutionError(this.fOldPath, this.fProject);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(LauncherMessages.JREContainerResolution_Unable_to_update_classpath_1, e.getStatus());
        }
    }

    protected void handleContainerResolutionError(final IPath oldPath, final IJavaProject project) throws CoreException {
        String lib = oldPath.segment(0);
        IPath initialPath = null;
        if ("JRE_LIB".equals(lib)) {
            initialPath = JavaRuntime.newDefaultJREContainerPath();
        } else if (JavaRuntime.JRE_CONTAINER.equals(lib)) {
            initialPath = oldPath;
        }
        IClasspathEntry initialEntry = JavaCore.newContainerEntry((IPath)initialPath);
        final IClasspathEntry containerEntry = BuildPathDialogAccess.configureContainerEntry((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (IClasspathEntry)initialEntry, (IJavaProject)project, (IClasspathEntry[])new IClasspathEntry[0]);
        if (containerEntry == null || containerEntry.getPath().equals((Object)oldPath)) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IPath newPath = containerEntry.getPath();
                    IClasspathEntry[] classpath = project.getRawClasspath();
                    int i = 0;
                    while (i < classpath.length) {
                        if (classpath[i].getPath().equals((Object)oldPath)) {
                            classpath[i] = JavaCore.newContainerEntry((IPath)newPath, (boolean)classpath[i].isExported());
                            break;
                        }
                        ++i;
                    }
                    project.setRawClasspath(classpath, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                throw (CoreException)e.getTargetException();
            }
            throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, LauncherMessages.JREContainerResolution_An_exception_occurred_while_updating_the_classpath__1, e.getTargetException()));
        }
        catch (InterruptedException interruptedException) {}
    }

    public String getLabel() {
        return MessageFormat.format((String)LauncherMessages.JREContainerResolution_Select_a_system_library_to_use_when_building__0__2, (Object[])new String[]{this.fProject.getElementName()});
    }
}

