/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.contentassist.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.editor.contentassist.SQLDBProposalsRequest;
import org.eclipse.datatools.sqltools.sql.ISQLSyntax;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParserProposalAdvisor;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ISQLCompletionEngine;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.ResultCollector;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCompletionProposalFactory;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLTemplateProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.SQLIntelligentTemplate;
import org.eclipse.datatools.sqltools.sqleditor.internal.templates.SQLTemplateProposal;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLDBUtils;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLWordFinder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.Workbench;

public class SQLParserCompletionEngine
implements ISQLCompletionEngine {
    private String _fFullText;
    private String _fStartText;
    private int _fWordOffset;
    private int _fDocumentOffset;
    private String _fWord;
    private int _fStartOffset;
    private SQLEditor _editor;
    private Point _selection;
    private SQLDevToolsConfiguration _config;
    private DatabaseVendorDefinitionId _databaseVendorDefinitionId;
    private ResultCollector resultCollector = null;
    private SQLCompletionProposalFactory fProposalFactory = new SQLCompletionProposalFactory();
    private ISQLDBProposalsService fDBProposalsService = null;

    public ICompletionProposal[] computeProposals(IDocument doc, ITypedRegion partition, int documentOffset, Point selection) {
        this.resultCollector = new ResultCollector();
        IEditorPart part = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part != null) {
            this._editor = (SQLEditor)((Object)part.getAdapter(SQLEditor.class));
        }
        if (this._editor == null) {
            return null;
        }
        this._fDocumentOffset = documentOffset;
        if (!this.needsContentAssist()) {
            return null;
        }
        this._databaseVendorDefinitionId = this._editor.getConnectionInfo().getDatabaseVendorDefinitionId();
        this._config = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._databaseVendorDefinitionId);
        SQLParser _parser = this._config.getSQLService().getSQLParser();
        this._selection = selection;
        String text = doc.get();
        if (text.trim().length() == 0) {
            this._fStartText = text.trim();
            this._fFullText = text.trim();
            this._fWordOffset = 0;
            this._fStartOffset = 0;
            this._fWord = text.trim();
        } else {
            String sqlCmdStartToCurrentCursorText;
            int wordOffset = SQLWordFinder.getWordStartOffset(text, documentOffset - 1);
            int expStart = 0;
            if (_parser != null) {
                SQLParserCompletionEngine.findStatementStart(text, this._fDocumentOffset - 1, _parser.getStatementStartTokens(), _parser.getStatementTerminators());
            }
            String uptoCurrentCursorText = text.substring(0, documentOffset);
            this._fStartText = sqlCmdStartToCurrentCursorText = text.substring(expStart, documentOffset);
            this._fFullText = uptoCurrentCursorText;
            this._fWordOffset = wordOffset;
            this._fStartOffset = expStart;
            this._fWord = this._fStartText.substring(this._fWordOffset + 1 - this._fStartOffset, this._fDocumentOffset - this._fStartOffset);
        }
        if (_parser == null) {
            return this.getTemplateProposalsAtLineStart();
        }
        String parseText = null;
        parseText = this._fFullText.equals("") ? this._fFullText : this._fFullText.substring(this._fStartOffset, this._fWordOffset + 1);
        boolean useDelimiter = this._editor.getSQLType() == 100;
        ParserParameters pp = new ParserParameters(useDelimiter, this._editor.getSQLType());
        this.prepareParserParameter(pp);
        ParsingResult result = _parser.parse(parseText + "!%^&", pp);
        result.getRootNode().setDocument(doc);
        ParserProposalAdvisor parserAdvisor = this._config.getSQLService().getParserProposalAdvisor();
        return this.getProposals(result, parserAdvisor);
    }

    protected void prepareParserParameter(ParserParameters pp) {
        pp.setProperty((Object)"__profile_name", (Object)this._editor.getConnectionInfo().getConnectionProfileName());
        pp.setProperty((Object)"__db_name", (Object)this._editor.getConnectionInfo().getDatabaseName());
        pp.setProperty((Object)"__consume_exception", (Object)Boolean.FALSE);
    }

    private ICompletionProposal[] getProposals(ParsingResult result, ParserProposalAdvisor advisor) {
        Database database;
        HashSet<String> unservedKeywords;
        boolean containsDT;
        String user = SQLDBUtils.getDefaultSchemaName(this._editor.getConnectionInfo());
        String[] parserProposals = advisor.getParserProposals(result);
        int replacementOffset = this._fWordOffset >= 0 ? this._fWordOffset + 1 : 0;
        int replacementLength = this._fDocumentOffset > this._fWordOffset ? this._fDocumentOffset - (this._fWordOffset + 1) + this._selection.y : this._fDocumentOffset;
        for (int i = 0; i < parserProposals.length; ++i) {
            String expected = parserProposals[i];
            if (advisor.isLocalVariableTokenDefinition(expected)) {
                String localVariablePrefix = advisor.getLocalVariablePrefix();
                if (this._fWord.startsWith(localVariablePrefix) && !this._fWord.startsWith(advisor.getGlobalVariablePrefix())) {
                    if (4096 != result.getScope()) {
                        this.resultCollector.setVariableList(new ArrayList<ICompletionProposal>(Arrays.asList(this.createVarProposals(result.getEntries("__parameters"), replacementOffset, replacementLength))));
                        break;
                    }
                } else if (this._fWord.equals("")) {
                    this.resultCollector.addVariable(new SQLCompletionProposal(localVariablePrefix, this._fDocumentOffset, this._selection.y, 1, null, localVariablePrefix, null, null, 0, this._editor.getAction("org.eclipse.ui.edit.text.contentAssist.proposals")));
                    continue;
                }
            }
            if (advisor.isGlobalVariableTokenDefinition(expected)) {
                String globalVariablePrefix = advisor.getGlobalVariablePrefix();
                if (this._fWord.startsWith(globalVariablePrefix)) {
                    ISQLSyntax syntax = this._config.getSQLService().getSQLSyntax();
                    this.resultCollector.setVariableList(new ArrayList<ICompletionProposal>(Arrays.asList(this.createVarProposals(syntax.getGlobalVariables(), replacementOffset, replacementLength))));
                    break;
                }
                if (this._fWord.equals("")) {
                    this.resultCollector.addVariable(new SQLCompletionProposal(globalVariablePrefix, this._fDocumentOffset, this._selection.y, 2, null, globalVariablePrefix, null, null, 0, this._editor.getAction("org.eclipse.ui.edit.text.contentAssist.proposals")));
                    continue;
                }
            }
            if (advisor.isIdentifierTokenDefinition(expected) && this._editor.getConnectionInfo().getSharedConnection() != null) {
                SQLDBProposalsRequest request = new SQLDBProposalsRequest(this._fWord, result.getScope(), user, result);
                List proposalList = this.fProposalFactory.getDBObjectProposals(request);
                this.resultCollector.setDBProposalList(this.adaptDBProposals(proposalList, request.getScope()), request.getScope());
            }
            if (advisor.isTokenDefinition(expected)) continue;
            if (!Character.isLetter(expected.charAt(0))) {
                if (!SQLParserCompletionEngine.startsWithIgnoreCase(expected, this._fWord)) continue;
                this.resultCollector.addOperator(new SQLCompletionProposal(expected, replacementOffset, replacementLength, expected.length(), null, expected, null, null, 1));
                continue;
            }
            if (this._fWord.equals("")) {
                this.resultCollector.addReservedKeyword(new SQLCompletionProposal(expected, this._fDocumentOffset, this._fWord.length() + this._selection.y, expected.length(), SQLEditorResources.getImage("keyword"), expected, null, null, 3));
                continue;
            }
            if (!SQLParserCompletionEngine.startsWithIgnoreCase(expected, this._fWord)) continue;
            this.resultCollector.addReservedKeyword(new SQLCompletionProposal(expected, replacementOffset, replacementLength, expected.length(), SQLEditorResources.getImage("keyword"), expected, null, null, 3));
        }
        if ((containsDT = advisor.containsDataTypeProposals(parserProposals, unservedKeywords = new HashSet<String>(result.getExpectedUnreservedKeywords()))) && (database = this._editor.getConnectionInfo().getDatabase()) != null && user != null) {
            EList schemas = ModelUtil.getSchemas((Database)database, (String)this._editor.getConnectionInfo().getDatabaseName());
            Iterator iter = schemas.iterator();
            while (iter.hasNext()) {
                Schema schema = (Schema)iter.next();
                if (!schema.getName().equals(user)) continue;
                EList udts = schema.getUserDefinedTypes();
                Iterator iterator = udts.iterator();
                while (iterator.hasNext()) {
                    UserDefinedType udt = (UserDefinedType)iterator.next();
                    if (!advisor.acceptsUserDefinedDataType(udt)) continue;
                    unservedKeywords.add(udt.getName());
                }
            }
        }
        Iterator iter = unservedKeywords.iterator();
        while (iter.hasNext()) {
            String sqlWordName = (String)iter.next();
            if (!SQLParserCompletionEngine.startsWithIgnoreCase(sqlWordName, this._fWord)) continue;
            this.resultCollector.addUnreservedKeywordList(new SQLCompletionProposal(sqlWordName, replacementOffset, replacementLength, sqlWordName.length(), SQLEditorResources.getImage("unreservedkeyword"), sqlWordName, null, null, 3));
        }
        ICompletionProposal[] results = this.resultCollector.getResults();
        List<Object> cmds = Arrays.asList("select", "insert", "create");
        int cmdSize = 0;
        for (int i = 0; i < results.length; ++i) {
            if (!cmds.contains(results[i].getDisplayString().toLowerCase())) continue;
            ++cmdSize;
        }
        boolean isStatementStart = cmdSize == cmds.size();
        ArrayList templateList = new SQLTemplateProposalsService().getProposals(this._editor, this._fDocumentOffset, this._fWord, isStatementStart, this._selection);
        ICompletionProposal[] templateResults = templateList.toArray(new SQLTemplateProposal[templateList.size()]);
        if (templateResults != null) {
            ICompletionProposal[] total = new ICompletionProposal[results.length + templateResults.length];
            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
            System.arraycopy(results, 0, total, templateResults.length, results.length);
            results = total;
        }
        return results;
    }

    public static int findStatementStart(String text, int offset, String[] startTokens, String[] terminators) {
        int i;
        if (terminators == null || terminators.length == 0) {
            return 0;
        }
        int lastWhitespace = i = offset;
        while (i >= 0) {
            String check;
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                lastWhitespace = i;
            }
            if ((check = text.substring(i, lastWhitespace)).length() != 0) {
                for (int k = 0; k < terminators.length; ++k) {
                    if (check.equalsIgnoreCase(terminators[k])) {
                        return i;
                    }
                    if (terminators[k].length() != 1 || Character.isLetter(terminators[k].charAt(0)) || !check.endsWith(terminators[k])) continue;
                    return i;
                }
            }
            --i;
        }
        return 0;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        int i;
        if (prefix == null) {
            return true;
        }
        int n = prefix.length();
        int m = string.length();
        for (i = 0; i < n && i < m && Character.toLowerCase(string.charAt(i)) == Character.toLowerCase(prefix.charAt(i)); ++i) {
        }
        return i == n;
    }

    protected boolean needsContentAssist() {
        String contentType = null;
        try {
            contentType = ((IDocumentExtension3)this._editor.getSV().getDocument()).getContentType("___sql_partitioning", this._fDocumentOffset, true);
        }
        catch (BadLocationException e) {
        }
        catch (BadPartitioningException badPartitioningException) {
            // empty catch block
        }
        return !contentType.equals("sql_comment") && !contentType.equals("sql_multiline_comment") && !contentType.equals("sql_double_quotes_identifier") && !contentType.equals("sql_character");
    }

    protected ICompletionProposal[] createVarProposals(String[] elements, int replacementOffset, int replacementLength) {
        if (elements == null) {
            return null;
        }
        ArrayList<SQLCompletionProposal> result = new ArrayList<SQLCompletionProposal>();
        for (int i = 0; i < elements.length; ++i) {
            int typeIndex = elements[i].indexOf(" - ");
            String replaceString = elements[i];
            if (typeIndex > 0) {
                replaceString = elements[i].substring(0, typeIndex);
            }
            if (!SQLParserCompletionEngine.startsWithIgnoreCase(replaceString, this._fWord)) continue;
            result.add(new SQLCompletionProposal(replaceString, replacementOffset, replacementLength, replaceString.length(), null, elements[i], null, null, 0));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    protected ICompletionProposal[] createVarProposals(HashMap elements, int replacementOffset, int replacementLength) {
        if (elements == null) {
            return null;
        }
        ArrayList<SQLCompletionProposal> result = new ArrayList<SQLCompletionProposal>();
        Iterator iter = elements.values().iterator();
        while (iter.hasNext()) {
            IASTSQLParam element = (IASTSQLParam)iter.next();
            if (!SQLParserCompletionEngine.startsWithIgnoreCase(element.getName(), this._fWord)) continue;
            result.add(new SQLCompletionProposal(element.getName(), replacementOffset, replacementLength, element.getName().length(), null, element.getName() + " - " + element.getType(), null, null, 0));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private int getRelevance(int dbObjectType) {
        switch (dbObjectType) {
            case 1: {
                return 2;
            }
            case 2: 
            case 9: {
                return 5;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return 2;
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        this.fProposalFactory.setFactoryDBContext(dbProposalsService);
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    protected ArrayList adaptDBProposals(List proposalList, int scope) {
        if (proposalList == null) {
            return new ArrayList();
        }
        boolean notShowTable = false;
        if ((scope & 0x4000) == 16384) {
            notShowTable = true;
        }
        ArrayList<SQLCompletionProposal> result = new ArrayList<SQLCompletionProposal>();
        String[] tokens = SQLUtil.splitDotStr((String)this._fWord);
        int indexInWord = this._fWord.lastIndexOf(46) + 1;
        int length = tokens.length;
        String objectName = null;
        String ownerName = null;
        String dbName = null;
        switch (length) {
            case 1: {
                objectName = tokens[0];
                break;
            }
            case 2: {
                ownerName = tokens[0];
                break;
            }
            case 3: {
                dbName = tokens[0];
                ownerName = tokens[1];
                objectName = tokens[2];
            }
        }
        String checkword = tokens[length - 1];
        if (checkword == null) {
            checkword = "";
        }
        for (int i = 0; i < proposalList.size(); ++i) {
            String replace;
            SQLDBProposal proposal = (SQLDBProposal)proposalList.get(i);
            if (proposal == null || proposal.getName() == null) continue;
            String name = proposal.getName();
            StringBuffer fullName = new StringBuffer(name);
            if (length >= 2 && proposal.getParentAlias() != null) {
                fullName = fullName.insert(0, '.').insert(0, proposal.getParentAlias());
            }
            if (length >= 3 && proposal.getGrandParentName() != null) {
                fullName = fullName.insert(0, '.').insert(0, proposal.getGrandParentName());
            }
            if (length >= 4 && proposal.getGrandGrandParentName() != null) {
                fullName = fullName.insert(0, '.').insert(0, proposal.getGrandGrandParentName());
            }
            Image image = proposal.getImage();
            StringBuffer display = new StringBuffer();
            SQLObject parentObject = (SQLObject)proposal.getParentObject();
            boolean displayParent = !notShowTable && this.needsDisplayOwner(proposal, length);
            boolean bl = displayParent = displayParent && proposal.getDBObject() != null;
            if (displayParent && proposal.getParentAlias() != null) {
                display.append(proposal.getParentAlias());
                display.append('.');
            }
            display.append(proposal.getName());
            String string = replace = display.length() > fullName.length() ? display.toString() : fullName.toString();
            if (length != 3) {
                display.insert(0, ' ');
            }
            int relevance = this.getRelevance(proposal.getType());
            int replaceOffset = this._fWordOffset + 1;
            if (SQLParserCompletionEngine.startsWithIgnoreCase(replace.toString(), this._fWord)) {
                result.add(new SQLCompletionProposal(replace, replaceOffset, this._fWord.length() + this._selection.y, replace.length(), image, display.toString(), null, null, relevance));
                continue;
            }
            if (objectName != null && SQLParserCompletionEngine.startsWithIgnoreCase(proposal.getName(), this._fWord)) {
                result.add(new SQLCompletionProposal(replace, replaceOffset, this._fWord.length() + this._selection.y, replace.length(), image, display.toString(), null, null, relevance));
                continue;
            }
            if (length != 3 || !SQLParserCompletionEngine.startsWithIgnoreCase(name, objectName)) continue;
            if (ownerName == null) {
                replace = dbName + ".." + display.toString();
            } else if (proposal.getDBObject() instanceof Table) {
                replace = ((Table)proposal.getDBObject()).getSchema().getName() + "." + display.toString();
            }
            result.add(new SQLCompletionProposal(replace, replaceOffset, this._fWord.length() + this._selection.y, replace.length(), image, display.toString(), null, null, relevance));
        }
        return result;
    }

    public boolean needsDisplayOwner(SQLDBProposal proposal, int length) {
        if (proposal.getDBObject() instanceof Table || proposal.getDBObject() instanceof ViewTable || proposal.getDBObject() instanceof Column) {
            boolean isShow = SQLEditorPlugin.getDefault().getPreferenceStore().getBoolean("show.owner.of.table");
            if (!isShow) {
                return false;
            }
            if (length == 3) {
                return false;
            }
        } else if (proposal.getDBObject() instanceof Event || proposal.getDBObject() instanceof Database || proposal.getDBObject() instanceof Catalog) {
            return false;
        }
        return true;
    }

    protected ICompletionProposal[] getTemplateProposalsAtLineStart() {
        int lineNumber = 0;
        int lineOffset = 0;
        IDocument document = this._editor.getSV().getDocument();
        try {
            lineNumber = document.getLineOfOffset(this._fDocumentOffset);
            lineOffset = document.getLineOffset(lineNumber);
            String text = document.get(lineOffset, this._fDocumentOffset - lineOffset);
            if (text != null && !text.trim().equals("")) {
                return null;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        ArrayList templateList = new SQLTemplateProposalsService().getProposals(this._editor, this._fDocumentOffset, this._fWord, true, this._selection);
        ICompletionProposal[] templateResults = templateList.toArray(new SQLTemplateProposal[templateList.size()]);
        return templateResults;
    }

    public IContextInformation[] computeContextInformation(IDocument doc, ITypedRegion partition, int documentOffset, Point selection) {
        IContextInformation[] contextInformations = null;
        contextInformations = this.computeTemplateContextInformation(doc, partition, documentOffset, selection);
        return contextInformations;
    }

    private IContextInformation[] computeTemplateContextInformation(IDocument doc, ITypedRegion partition, int documentOffset, Point selection) {
        String tempalteId = SQLEditorPlugin.getDefault().getPreferenceStore().getString("intelligence.template");
        if (tempalteId == null || tempalteId.trim().equals("")) {
            return null;
        }
        String contextInfo = null;
        SQLIntelligentTemplate template = SQLEditorPlugin.getDefault().getTemplateStore().getRegisteredIntelligentTemplate(tempalteId);
        if (template == null) {
            return null;
        }
        String word = this.findWord(doc.get(), documentOffset);
        contextInfo = template.getContextInformation(word);
        if (contextInfo != null) {
            return new ContextInformation[]{new ContextInformation(contextInfo, contextInfo)};
        }
        return null;
    }

    private String findWord(String text, int offset) {
        int i;
        int start = offset;
        int end = offset;
        for (i = offset - 1; i > 0 && this.isValidChar(text.charAt(i)); --i) {
            --start;
        }
        for (i = offset; i < text.length() && this.isValidChar(text.charAt(i)); ++i) {
            ++end;
        }
        return text.substring(start, end);
    }

    private boolean isValidChar(char character) {
        return character != ' ' && character != '\n' && character != '\t' && character != '\r' && character != '(' && character != ',' && character != ')';
    }
}

