/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.rte.fe;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.EngineeringOptionID;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlScript;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGenerationOptions;
import org.eclipse.datatools.modelbase.sql.constraints.Assertion;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EObject;

public class GenericDdlGenerator
implements DDLGenerator {
    protected EngineeringOption[] options = null;
    protected EngineeringOptionCategory[] categories = null;
    private GenericDdlBuilder builder = null;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$schema$Database;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$schema$Schema;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$tables$Table;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$constraints$Index;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$routines$Procedure;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$routines$UserDefinedFunction;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$tables$ViewTable;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$tables$Trigger;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$schema$Sequence;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$datatypes$UserDefinedType;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$constraints$UniqueConstraint;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$constraints$CheckConstraint;
    static /* synthetic */ Class class$org$eclipse$datatools$modelbase$sql$constraints$ForeignKey;

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        String[] statements = new String[]{};
        EngineeringOption[] options = this.getSelectedOptions(elements);
        if (this.generateCreateStatement(options)) {
            statements = this.createSQLObjects(elements, this.generateQuotedIdentifiers(options), this.generateFullyQualifiedNames(options), progressMonitor);
        }
        if (this.generateDropStatement(options)) {
            int i;
            String[] drop = this.dropSQLObjects(elements, this.generateQuotedIdentifiers(options), this.generateFullyQualifiedNames(options), progressMonitor);
            String[] temp = statements;
            statements = new String[temp.length + drop.length];
            for (i = 0; i < drop.length; ++i) {
                statements[i] = drop[i];
            }
            for (i = 0; i < temp.length; ++i) {
                statements[i + drop.length] = temp[i];
            }
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        String[] statements = this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        String[] statements = this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    protected String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        GenericDdlScript script = new GenericDdlScript();
        if (this.builder == null) {
            this.builder = new GenericDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables(options) || (statement = this.builder.createTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (o instanceof Index) {
                if (!this.generateIndexes(options) || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateIndexStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures(options) || (statement = this.builder.createProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateStoredProcedureStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions(options) || (statement = this.builder.createUserDefinedFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateUserDefinedFunctionStatement(statement);
                continue;
            }
            if (o instanceof Schema) {
                if (!this.generateSchemas(options) || (statement = this.builder.createSchema((Schema)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateSchemaStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedType) {
                if (!this.generateSchemas(options) || (statement = this.builder.createUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateUserDefinedTypeStatement(statement);
                continue;
            }
            if (!(o instanceof Assertion) || !this.generateAssertions(options) || (statement = this.builder.createAssertion((Assertion)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateAssertionStatement(statement);
        }
        return script.getStatements();
    }

    protected String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        GenericDdlScript script = new GenericDdlScript();
        if (this.builder == null) {
            this.builder = new GenericDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables(options) || (statement = this.builder.dropTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (o instanceof Index) {
                if (!this.generateIndexes(options) || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropIndexStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures(options) || (statement = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropStoredProcedureStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions(options) || (statement = this.builder.dropFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropUserDefinedFunctionStatement(statement);
                continue;
            }
            if (o instanceof Schema) {
                if (!this.generateSchemas(options) || (statement = this.builder.dropSchema((Schema)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropSchemaStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedType) {
                if (!this.generateSchemas(options) || (statement = this.builder.dropUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropUserDefinedTypeStatement(statement);
                continue;
            }
            if (!(o instanceof Assertion) || !this.generateAssertions(options) || (statement = this.builder.dropAssertion((Assertion)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropAssertionStatement(statement);
        }
        return script.getStatements();
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    public EngineeringOption[] getOptions(SQLObject[] elements) {
        return this.calculateOptions(elements);
    }

    public EngineeringOption[] getSelectedOptions(SQLObject[] elements) {
        if (this.options == null) {
            this.getOptions(elements);
        }
        return this.options;
    }

    public boolean generateDropStatement(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_DROP_STATEMENTS", options);
    }

    public boolean generateCreateStatement(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_CREATE_STATEMENTS", options);
    }

    public boolean generateCommentStatement(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_COMMENTS", options);
    }

    public boolean generateDatabase(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_DATABASE", options);
    }

    public boolean generateSchemas(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_SCHEMAS", options);
    }

    public boolean generateQuotedIdentifiers(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_QUOTED_IDENTIFIER", options);
    }

    public boolean generateFullyQualifiedNames(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FULLY_QUALIFIED_NAME", options);
    }

    public boolean generateTables(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_TABLES", options);
    }

    public boolean generateIndexes(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_INDICES", options);
    }

    public boolean generateStoredProcedures(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_STOREDPROCEDURES", options);
    }

    public boolean generateViews(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_VIEWS", options);
    }

    public boolean generateTriggers(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_TRIGGERS", options);
    }

    public boolean generateSequences(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_SEQUENCES", options);
    }

    public boolean generateFunctions(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FUNCTIONS", options);
    }

    public boolean generateUserDefinedTypes(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_USER_DEFINED_TYPE", options);
    }

    public boolean generateCKConstraints(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_CK_CONSTRAINTS", options);
    }

    public boolean generatePKConstraints(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_PK_CONSTRAINTS", options);
    }

    public boolean generateFKConstraints(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FK_CONSTRAINTS", options);
    }

    public boolean generateAssertions(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_ASSERTIONS", options);
    }

    private boolean getOptionValueByID(String optionID, EngineeringOption[] options) {
        return EngineeringOptionID.getOptionValueByID(optionID, options);
    }

    protected Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        for (int i = 0; i < elements.length; ++i) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
        }
        return s;
    }

    private EngineeringOption[] calculateOptions(SQLObject[] elements) {
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        for (int i = 0; i < categories_new.length; ++i) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
                continue;
            }
            if (!categories_new[i].getId().equals("GENERATE_ELEMENTS")) continue;
            additional_element = categories_new[i];
        }
        this.options = this.getOptionDependency(elements, general_options, additional_element);
        return this.options;
    }

    private EngineeringOption[] getOptionDependency(SQLObject[] elements, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        LinkedHashSet<String> sOptions = new LinkedHashSet<String>();
        sOptions.add("GENERATE_FULLY_QUALIFIED_NAME");
        sOptions.add("GENERATE_QUOTED_IDENTIFIER");
        sOptions.add("GENERATE_DROP_STATEMENTS");
        sOptions.add("GENERATE_CREATE_STATEMENTS");
        sOptions.add("GENERATE_COMMENTS");
        sOptions.addAll(this.getAllContainedDisplayableElementSetDepedency(elements));
        int idx = 0;
        int size = 0;
        EngineeringOption[] options = new EngineeringOption[sOptions.size()];
        int i = 0;
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            options[i] = this.getEngineeringOption((String)it.next(), general_options, additional_element);
            if (options[i] != null && options[i].getCategory().getId().equals("GENERATE_ELEMENTS")) {
                idx = i;
                ++size;
            }
            ++i;
        }
        if (size == 1) {
            EngineeringOption option = options[idx];
            option.setBoolean(true);
        }
        return options;
    }

    protected EngineeringOption getEngineeringOption(String id, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_COMMENTS"), resource.getString("GENERATE_COMMENTS_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMAS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_SCHEMAS"), resource.getString("GENERATE_SCHEMAS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CK_CONSTRAINTS"), resource.getString("GENERATE_CK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TIGGER"), resource.getString("GENERATE_TIGGER_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_SEQUENCE"), resource.getString("GENERATE_SEQUENCE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, resource.getString("GENERATE_USER_DEFINED_TYPE"), resource.getString("GENERATE_USER_DEFINED_TYPE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ASSERTIONS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_ASSERTIONS"), resource.getString("GENERATE_GENERATE_ASSERTION_DES"), true, additional_element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Set getAllContainedDisplayableElementSetDepedency(SQLObject[] elements) {
        SingletonOptionDependency sod = SingletonOptionDependency.getSingletonObject();
        TreeSet s = new TreeSet();
        for (int i = 0; i < elements.length; ++i) {
            Class key = null;
            if (elements[i] instanceof Database) {
                key = class$org$eclipse$datatools$modelbase$sql$schema$Database == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.schema.Database") : class$org$eclipse$datatools$modelbase$sql$schema$Database;
            } else if (elements[i] instanceof Schema) {
                key = class$org$eclipse$datatools$modelbase$sql$schema$Schema == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.schema.Schema") : class$org$eclipse$datatools$modelbase$sql$schema$Schema;
            } else if (elements[i] instanceof PersistentTable) {
                key = class$org$eclipse$datatools$modelbase$sql$tables$Table == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.tables.Table") : class$org$eclipse$datatools$modelbase$sql$tables$Table;
            } else if (elements[i] instanceof Index) {
                key = class$org$eclipse$datatools$modelbase$sql$constraints$Index == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.Index") : class$org$eclipse$datatools$modelbase$sql$constraints$Index;
            } else if (elements[i] instanceof Procedure) {
                key = class$org$eclipse$datatools$modelbase$sql$routines$Procedure == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.routines.Procedure") : class$org$eclipse$datatools$modelbase$sql$routines$Procedure;
            } else if (elements[i] instanceof UserDefinedFunction) {
                key = class$org$eclipse$datatools$modelbase$sql$routines$UserDefinedFunction == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction") : class$org$eclipse$datatools$modelbase$sql$routines$UserDefinedFunction;
            } else if (elements[i] instanceof ViewTable) {
                key = class$org$eclipse$datatools$modelbase$sql$tables$ViewTable == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.tables.ViewTable") : class$org$eclipse$datatools$modelbase$sql$tables$ViewTable;
            } else if (elements[i] instanceof Trigger) {
                key = class$org$eclipse$datatools$modelbase$sql$tables$Trigger == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.tables.Trigger") : class$org$eclipse$datatools$modelbase$sql$tables$Trigger;
            } else if (elements[i] instanceof Sequence) {
                key = class$org$eclipse$datatools$modelbase$sql$schema$Sequence == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.schema.Sequence") : class$org$eclipse$datatools$modelbase$sql$schema$Sequence;
            } else if (elements[i] instanceof UserDefinedType) {
                key = class$org$eclipse$datatools$modelbase$sql$datatypes$UserDefinedType == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType") : class$org$eclipse$datatools$modelbase$sql$datatypes$UserDefinedType;
            } else if (elements[i] instanceof UniqueConstraint) {
                key = class$org$eclipse$datatools$modelbase$sql$constraints$UniqueConstraint == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint") : class$org$eclipse$datatools$modelbase$sql$constraints$UniqueConstraint;
            } else if (elements[i] instanceof CheckConstraint) {
                key = class$org$eclipse$datatools$modelbase$sql$constraints$CheckConstraint == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint") : class$org$eclipse$datatools$modelbase$sql$constraints$CheckConstraint;
            } else if (elements[i] instanceof ForeignKey) {
                key = class$org$eclipse$datatools$modelbase$sql$constraints$ForeignKey == null ? GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.ForeignKey") : class$org$eclipse$datatools$modelbase$sql$constraints$ForeignKey;
            }
            try {
                int mask = sod.getMask(key);
                this.populateOptions(s, mask);
                continue;
            }
            catch (Exception e) {
                System.err.println("Missing definition for: " + elements[i].getClass().toString());
                e.printStackTrace();
            }
        }
        return s;
    }

    protected void populateOptions(Set s, int mask) {
        if ((mask & 1) == 1) {
            s.add("GENERATE_DATABASE");
        }
        if ((mask & 4) == 4) {
            s.add("GENERATE_TABLES");
        }
        if ((mask & 0x80) == 128) {
            s.add("GENERATE_INDICES");
        }
        if ((mask & 8) == 8) {
            s.add("GENERATE_STOREDPROCEDURES");
        }
        if ((mask & 0x10) == 16) {
            s.add("GENERATE_FUNCTIONS");
        }
        if ((mask & 0x20) == 32) {
            s.add("GENERATE_VIEWS");
        }
        if ((mask & 0x40) == 64) {
            s.add("GENERATE_TRIGGERS");
        }
        if ((mask & 0x100) == 256) {
            s.add("GENERATE_SEQUENCES");
        }
        if ((mask & 0x200) == 512) {
            s.add("GENERATE_USER_DEFINED_TYPE");
        }
        if ((mask & 0x400) == 1024) {
            s.add("GENERATE_PK_CONSTRAINTS");
        }
        if ((mask & 0x1000) == 4096) {
            s.add("GENERATE_CK_CONSTRAINTS");
        }
        if ((mask & 0x800) == 2048) {
            s.add("GENERATE_FK_CONSTRAINTS");
        }
        if ((mask & 2) == 2) {
            s.add("GENERATE_SCHEMAS");
        }
    }

    protected final void setDdlBuilder(GenericDdlBuilder builder) {
        this.builder = builder;
    }

    public static class SingletonOptionDependency {
        private Map data = new HashMap();
        private static SingletonOptionDependency ref;

        private SingletonOptionDependency() {
        }

        public static SingletonOptionDependency getSingletonObject() {
            if (ref == null) {
                ref = new SingletonOptionDependency();
                int mask = 7396;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$schema$Database == null ? (class$org$eclipse$datatools$modelbase$sql$schema$Database = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.schema.Database")) : class$org$eclipse$datatools$modelbase$sql$schema$Database, new Integer(mask));
                mask = 7396;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$schema$Schema == null ? (class$org$eclipse$datatools$modelbase$sql$schema$Schema = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.schema.Schema")) : class$org$eclipse$datatools$modelbase$sql$schema$Schema, new Integer(mask));
                mask = 7364;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$tables$Table == null ? (class$org$eclipse$datatools$modelbase$sql$tables$Table = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.tables.Table")) : class$org$eclipse$datatools$modelbase$sql$tables$Table, new Integer(mask));
                mask = 128;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$constraints$Index == null ? (class$org$eclipse$datatools$modelbase$sql$constraints$Index = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.Index")) : class$org$eclipse$datatools$modelbase$sql$constraints$Index, new Integer(mask));
                mask = 8;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$routines$Procedure == null ? (class$org$eclipse$datatools$modelbase$sql$routines$Procedure = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.routines.Procedure")) : class$org$eclipse$datatools$modelbase$sql$routines$Procedure, new Integer(mask));
                mask = 16;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$routines$UserDefinedFunction == null ? (class$org$eclipse$datatools$modelbase$sql$routines$UserDefinedFunction = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction")) : class$org$eclipse$datatools$modelbase$sql$routines$UserDefinedFunction, new Integer(mask));
                mask = 96;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$tables$ViewTable == null ? (class$org$eclipse$datatools$modelbase$sql$tables$ViewTable = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.tables.ViewTable")) : class$org$eclipse$datatools$modelbase$sql$tables$ViewTable, new Integer(mask));
                mask = 64;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$tables$Trigger == null ? (class$org$eclipse$datatools$modelbase$sql$tables$Trigger = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.tables.Trigger")) : class$org$eclipse$datatools$modelbase$sql$tables$Trigger, new Integer(mask));
                mask = 256;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$schema$Sequence == null ? (class$org$eclipse$datatools$modelbase$sql$schema$Sequence = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.schema.Sequence")) : class$org$eclipse$datatools$modelbase$sql$schema$Sequence, new Integer(mask));
                mask = 512;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$datatypes$UserDefinedType == null ? (class$org$eclipse$datatools$modelbase$sql$datatypes$UserDefinedType = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType")) : class$org$eclipse$datatools$modelbase$sql$datatypes$UserDefinedType, new Integer(mask));
                mask = 1024;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$constraints$UniqueConstraint == null ? (class$org$eclipse$datatools$modelbase$sql$constraints$UniqueConstraint = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint")) : class$org$eclipse$datatools$modelbase$sql$constraints$UniqueConstraint, new Integer(mask));
                mask = 2048;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$constraints$ForeignKey == null ? (class$org$eclipse$datatools$modelbase$sql$constraints$ForeignKey = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.ForeignKey")) : class$org$eclipse$datatools$modelbase$sql$constraints$ForeignKey, new Integer(mask));
                mask = 4096;
                SingletonOptionDependency.ref.data.put(class$org$eclipse$datatools$modelbase$sql$constraints$CheckConstraint == null ? (class$org$eclipse$datatools$modelbase$sql$constraints$CheckConstraint = GenericDdlGenerator.class$("org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint")) : class$org$eclipse$datatools$modelbase$sql$constraints$CheckConstraint, new Integer(mask));
            }
            return ref;
        }

        public Integer getMask(Class key) {
            return (Integer)this.data.get(key);
        }
    }
}

