/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.php.internal.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.editor.contentassist.CodeDataCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.editor.contentassist.PartialProposal;
import org.eclipse.php.internal.ui.editor.contentassist.TemporaryCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompletionProposalGroup {
    public static final String ELEMENT_NAME_SEPARATOR = "_";
    public static final String COLLAPSED_PREFIX = "...";
    public static final String COLLAPSED_SUFFIX = "*";
    public static final String PATH_SEPARATOR = Character.toString('/');
    private static final Path COMPLETION_TREE_ROOT = new Path("ROOT");
    protected int offset;
    protected CodeData[] codeDataProposals;
    protected ICompletionProposal[] completionProposals;
    protected String key;
    protected int segmentsToCut;
    protected int selectionLength;
    protected PHPProjectModel projectModel;
    protected boolean groupOptions;
    protected boolean cutCommonPrefix;

    public CompletionProposalGroup() {
        this.setData(0, null, null, this.selectionLength);
        this.setOffset(0);
    }

    public void setData(int n, CodeData[] codeDataArray, String string, int n2, boolean bl) {
        Path path;
        this.setOffset(n);
        if (bl) {
            path = new ArrayList(1);
            int n3 = 0;
            while (n3 < codeDataArray.length) {
                if (string.equalsIgnoreCase(codeDataArray[n3].getName())) {
                    path.add(codeDataArray[n3]);
                }
                ++n3;
            }
            codeDataArray = path.toArray(new CodeData[path.size()]);
        }
        this.setCodeDataProposals(codeDataArray);
        this.key = string;
        if (string != null) {
            path = CompletionProposalGroup.elementNameToPath(string);
            if (this.cutCommonPrefix) {
                this.segmentsToCut = path.segmentCount();
                if (this.segmentsToCut > 0 && !path.hasTrailingSeparator()) {
                    --this.segmentsToCut;
                }
            }
        }
        this.selectionLength = n2;
    }

    public void setData(int n, CodeData[] codeDataArray, String string, int n2) {
        this.setData(n, codeDataArray, string, n2, false);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public CodeData[] getCodeDataProposals() {
        return this.codeDataProposals;
    }

    private void setCodeDataProposals(CodeData[] codeDataArray) {
        this.completionProposals = null;
        this.codeDataProposals = codeDataArray;
    }

    public ICompletionProposal[] getCompletionProposals(PHPProjectModel pHPProjectModel) {
        this.projectModel = pHPProjectModel;
        if (this.completionProposals == null) {
            ICompletionProposal[] iCompletionProposalArray = this.completionProposals = this.calcCompletionProposals(pHPProjectModel);
            int n = this.completionProposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal iCompletionProposal = iCompletionProposalArray[n2];
                if (iCompletionProposal instanceof CodeDataCompletionProposal) {
                    ((CodeDataCompletionProposal)iCompletionProposal).setOffset(this.offset);
                }
                ++n2;
            }
        }
        return this.completionProposals;
    }

    private ElementTree buildCompletionTree(PHPProjectModel pHPProjectModel, CodeData[] codeDataArray) {
        ElementTree elementTree = new ElementTree();
        CodeData[] codeDataArray2 = codeDataArray;
        int n = codeDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData codeData = codeDataArray2[n2];
            String string = codeData.getName();
            Path path = CompletionProposalGroup.elementNameToPath(string);
            this.treeRecursiveCreateElement(pHPProjectModel, elementTree, COMPLETION_TREE_ROOT.append((IPath)path), codeData);
            ++n2;
        }
        return elementTree;
    }

    private void treeRecursiveCreateElement(PHPProjectModel pHPProjectModel, ElementTree elementTree, IPath iPath, CodeData codeData) {
        if (iPath.segmentCount() == 1 && !elementTree.includes(iPath)) {
            elementTree.createElement(iPath, (Object)codeData);
            return;
        }
        IPath iPath2 = iPath.removeLastSegments(1);
        iPath2.removeLastSegments(1);
        if (!elementTree.includes(iPath2)) {
            this.treeRecursiveCreateElement(pHPProjectModel, elementTree, iPath2, null);
        }
        if (!elementTree.includes(iPath)) {
            if (codeData != null) {
                elementTree.createElement(iPath, (Object)codeData);
            } else {
                elementTree.createElement(iPath, null);
            }
        } else if (codeData != null) {
            Object object = elementTree.getElementData(iPath);
            if (object instanceof LinkedHashSet) {
                ((LinkedHashSet)object).add(codeData);
            } else {
                LinkedHashSet<CodeData> linkedHashSet = new LinkedHashSet<CodeData>(2);
                linkedHashSet.add((CodeData)object);
                linkedHashSet.add(codeData);
                elementTree.setElementData(iPath, linkedHashSet);
            }
        }
    }

    private Collection<IPath> calculateProposalPaths(ElementTree elementTree, IPath iPath, boolean bl) {
        boolean bl2;
        if (elementTree == null) {
            return null;
        }
        Collection collection = Arrays.asList(iPath);
        int n = elementTree.getChildCount(iPath);
        if (n == 0) {
            if (elementTree.getElementData(iPath) != null) {
                return collection;
            }
            return null;
        }
        IPath[] iPathArray = elementTree.getChildren(iPath);
        boolean bl3 = bl2 = n > 1;
        if (bl2) {
            int n2 = 0;
            while (n2 < iPathArray.length) {
                if (n2 + 1 < iPathArray.length && !iPathArray[n2].lastSegment().equalsIgnoreCase(iPathArray[n2 + 1].lastSegment())) {
                    bl2 = false;
                    break;
                }
                ++n2;
            }
        }
        if (n > 1 && bl) {
            return collection;
        }
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        boolean bl4 = n > 1 && !bl2;
        IPath[] iPathArray2 = iPathArray;
        int n3 = iPathArray.length;
        int n4 = 0;
        while (n4 < n3) {
            IPath iPath2 = iPathArray2[n4];
            Collection<IPath> collection2 = this.calculateProposalPaths(elementTree, iPath2, bl || bl4);
            if (collection2 != null) {
                arrayList.addAll(collection2);
            }
            ++n4;
        }
        return arrayList;
    }

    protected ICompletionProposal[] calcCompletionProposals(PHPProjectModel pHPProjectModel) {
        if (this.codeDataProposals == null || this.codeDataProposals.length == 0) {
            return ContentAssistSupport.EMPTY_CodeDataCompletionProposal_ARRAY;
        }
        CodeData[] codeDataArray = ModelSupport.getCodeDataStartingWith((CodeData[])this.codeDataProposals, (String)this.key);
        codeDataArray = ModelSupport.removeFilteredCodeData((CodeData[])codeDataArray, (CodeDataFilter)ModelSupport.INTERNAL_CODEDATA_FILTER);
        if (!this.groupOptions) {
            ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[codeDataArray.length];
            int n = 0;
            while (n < iCompletionProposalArray.length) {
                iCompletionProposalArray[n] = this.createElementProposal(pHPProjectModel, codeDataArray[n]);
                ++n;
            }
            return iCompletionProposalArray;
        }
        ElementTree elementTree = this.buildCompletionTree(pHPProjectModel, codeDataArray);
        ArrayList<Object> arrayList = new ArrayList<Object>(codeDataArray.length);
        if (elementTree.getChildCount(elementTree.getRoot()) > 0) {
            Path path = COMPLETION_TREE_ROOT;
            Collection<IPath> collection = this.calculateProposalPaths(elementTree, (IPath)path, false);
            for (IPath iPath : collection) {
                Object object = elementTree.getElementData(iPath);
                Collection collection2 = !(object instanceof Collection) ? (Collection)Arrays.asList((CodeData)object) : (Collection)object;
                for (CodeData codeData : collection2) {
                    if (codeData != null) {
                        arrayList.add(this.createElementProposal(pHPProjectModel, codeData));
                        continue;
                    }
                    IPath iPath2 = iPath.removeFirstSegments(1);
                    String string = String.valueOf(CompletionProposalGroup.elementPathToName(iPath2)) + ELEMENT_NAME_SEPARATOR;
                    arrayList.add(this.createGroupProposal(iPath, string));
                }
            }
        }
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    private CodeDataCompletionProposal createElementProposal(PHPProjectModel pHPProjectModel, Object object) {
        if (!this.cutCommonPrefix) {
            return this.createProposal(pHPProjectModel, (CodeData)object);
        }
        return new PartialProposal(this.createProposal(pHPProjectModel, (CodeData)object), this.segmentsToCut);
    }

    static String elementPathToName(IPath iPath) {
        return iPath.toString().replaceAll(PATH_SEPARATOR, ELEMENT_NAME_SEPARATOR);
    }

    static Path elementNameToPath(String string) {
        return new Path(string.replaceAll(ELEMENT_NAME_SEPARATOR, PATH_SEPARATOR));
    }

    private TemporaryCompletionProposal createGroupProposal(IPath iPath, String string) {
        return new TemporaryCompletionProposal((ICompletionProposal)new CompletionProposal(string, this.getOffset() - this.key.length(), this.key.length(), string.length(), null, String.valueOf(this.segmentsToCut > 0 ? "..._" : "") + CompletionProposalGroup.elementPathToName(iPath.removeFirstSegments(this.segmentsToCut + 1)) + ELEMENT_NAME_SEPARATOR + COLLAPSED_SUFFIX, null, null));
    }

    protected abstract CodeDataCompletionProposal createProposal(PHPProjectModel var1, CodeData var2);

    public void setGroupOptions(boolean bl) {
        this.groupOptions = bl;
    }

    public void setCutCommonPrefix(boolean bl) {
        this.cutCommonPrefix = bl;
    }
}

