/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PhpVariableTypeUtil;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PhpTemplateArrayVariableResolver
extends TemplateVariableResolver {
    private static final String DEFAULT_VAR = "array";

    public PhpTemplateArrayVariableResolver() {
        super("array_variable", PHPUIMessages.getString("PhpTemplateArrayVariableResolver.2"));
    }

    protected String[] resolveAll(TemplateContext templateContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        final PhpTemplateContext phpTemplateContext = (PhpTemplateContext)templateContext;
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        if (iModelManager == null) {
            return new String[]{DEFAULT_VAR};
        }
        IStructuredModel iStructuredModel = iModelManager.getExistingModelForRead(phpTemplateContext.getDocument());
        if (iStructuredModel == null) {
            return new String[]{DEFAULT_VAR};
        }
        try {
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData == null) {
                String[] stringArray = new String[]{DEFAULT_VAR};
                return stringArray;
            }
            final PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)phpTemplateContext.getStart());
            final PHPVariablesTypeManager pHPVariablesTypeManager = pHPFileData.getVariableTypeManager();
            PHPVariableData[] pHPVariableDataArray = pHPVariablesTypeManager.getVariables(pHPCodeContext);
            if (pHPVariableDataArray == null) {
                String[] stringArray = new String[]{DEFAULT_VAR};
                return stringArray;
            }
            ArrayList<PHPVariableData> arrayList2 = new ArrayList<PHPVariableData>();
            int n = 0;
            while (n < pHPVariableDataArray.length) {
                PHPVariableData pHPVariableData = pHPVariableDataArray[n];
                PHPVariableTypeData pHPVariableTypeData = pHPVariablesTypeManager.getVariableTypeDataByPosition(pHPCodeContext, pHPVariableData.getName(), phpTemplateContext.getStart());
                if (pHPVariableTypeData != null) {
                    arrayList2.add(pHPVariableData);
                }
                ++n;
            }
            Collections.sort(arrayList2, new Comparator(){

                public int compare(Object object, Object object2) {
                    PHPVariableData pHPVariableData = (PHPVariableData)object;
                    PHPVariableData pHPVariableData2 = (PHPVariableData)object2;
                    PHPVariableTypeData pHPVariableTypeData = pHPVariablesTypeManager.getVariableTypeDataByPosition(pHPCodeContext, pHPVariableData.getName(), phpTemplateContext.getStart());
                    String string = this.getVariableType(pHPVariableTypeData);
                    boolean bl = PhpVariableTypeUtil.isArray((String)string);
                    PHPVariableTypeData pHPVariableTypeData2 = pHPVariablesTypeManager.getVariableTypeDataByPosition(pHPCodeContext, pHPVariableData2.getName(), phpTemplateContext.getStart());
                    String string2 = this.getVariableType(pHPVariableTypeData2);
                    boolean bl2 = PhpVariableTypeUtil.isArray((String)string2);
                    if (bl && bl2 || !bl && !bl2) {
                        return pHPVariableData.getName().compareToIgnoreCase(pHPVariableData.getName());
                    }
                    if (bl) {
                        return -1;
                    }
                    if (bl2) {
                        return 1;
                    }
                    if (string == null && string2 == null) {
                        return pHPVariableData.getName().compareToIgnoreCase(pHPVariableData2.getName());
                    }
                    if (string == null) {
                        return -1;
                    }
                    if (string2 == null) {
                        return 1;
                    }
                    return pHPVariableData.getName().compareToIgnoreCase(pHPVariableData2.getName());
                }

                private String getVariableType(PHPVariableTypeData pHPVariableTypeData) {
                    return pHPVariableTypeData.getType();
                }
            });
            for (PHPVariableData pHPVariableData : arrayList2) {
                arrayList.add(pHPVariableData.getName());
            }
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

