/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathBasePage;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathOrderingWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.LibrariesWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.ProjectsWorkbookPage;
import org.eclipse.php.internal.ui.util.ImageDisposer;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludePathBlock {
    private IWorkspaceRoot fWorkspaceRoot;
    private ListDialogField fIncludePathList;
    private StatusInfo fIncludePathStatus;
    private IProject fCurrProject;
    private PHPProjectOptions phpOptions = null;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private TabFolder fTabFolder;
    private int fPageIndex;
    private ProjectsWorkbookPage fProjectsPage;
    private LibrariesWorkbookPage fLibrariesPage;
    private IncludePathBasePage fCurrPage;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private IRunnableContext fRunnableContext;
    private boolean fUseNewPage;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public IncludePathBlock(IRunnableContext iRunnableContext, IStatusChangeListener iStatusChangeListener, int n, boolean bl, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        this.fPageContainer = iWorkbenchPreferenceContainer;
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fContext = iStatusChangeListener;
        this.fUseNewPage = bl;
        this.fPageIndex = n;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = iRunnableContext;
        IncludePathAdapter includePathAdapter = new IncludePathAdapter();
        String[] stringArray = new String[]{PHPUIMessages.getString("IncludePathsBlock_includepath_up_button"), PHPUIMessages.getString("IncludePathsBlock_includepath_down_button")};
        this.fIncludePathList = new ListDialogField(null, stringArray, (ILabelProvider)new IPListLabelProvider());
        this.fIncludePathList.setDialogFieldListener(includePathAdapter);
        this.fIncludePathList.setLabelText(PHPUIMessages.getString("IncludePathsBlock_includepath_label"));
        this.fIncludePathList.setUpButtonIndex(0);
        this.fIncludePathList.setDownButtonIndex(1);
        this.fIncludePathStatus = new StatusInfo();
        this.fCurrProject = null;
        this.phpOptions = null;
    }

    public Control createControl(Composite composite) {
        this.fSWTWidget = composite;
        new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.setFont(composite2.getFont());
        IWorkbench iWorkbench = PHPUiPlugin.getDefault().getWorkbench();
        Image image = iWorkbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new ProjectsWorkbookPage(this.fIncludePathList, this.fPageContainer);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(PHPUIMessages.getString("IncludePathsBlock_tab_projects"));
        tabItem.setImage(image);
        tabItem.setData((Object)this.fProjectsPage);
        tabItem.setControl(this.fProjectsPage.getControl((Composite)tabFolder));
        this.fLibrariesPage = new LibrariesWorkbookPage(this.fIncludePathList, this.fPageContainer);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(PHPUIMessages.getString("IncludePathsBlock_tab_libraries"));
        tabItem.setImage(PHPPluginImages.get("org.eclipse.php.ui.library_obj.gif"));
        tabItem.setData((Object)this.fLibrariesPage);
        tabItem.setControl(this.fLibrariesPage.getControl((Composite)tabFolder));
        Image image2 = PHPPluginImages.DESC_TOOL_INCLUDEPATH_ORDER.createImage();
        composite2.addDisposeListener((DisposeListener)new ImageDisposer(image2));
        IncludePathOrderingWorkbookPage includePathOrderingWorkbookPage = new IncludePathOrderingWorkbookPage(this.fIncludePathList);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(PHPUIMessages.getString("IncludePathsBlock_tab_order"));
        tabItem.setImage(image2);
        tabItem.setData((Object)includePathOrderingWorkbookPage);
        tabItem.setControl(includePathOrderingWorkbookPage.getControl((Composite)tabFolder));
        if (this.fCurrProject != null) {
            this.fLibrariesPage.init(this.fCurrProject);
            this.fProjectsPage.init(this.fCurrProject);
        }
        tabFolder.setSelection(this.fPageIndex);
        this.fCurrPage = (IncludePathBasePage)tabFolder.getItem(this.fPageIndex).getData();
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IncludePathBlock.this.tabChanged(selectionEvent.item);
            }
        });
        this.fTabFolder = tabFolder;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.php.help.adding_elements_to_a_project_s_include_path");
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    public void init(IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        this.fCurrProject = iProject;
        this.phpOptions = PHPProjectOptions.forProject((IProject)this.fCurrProject);
        List list = null;
        IProject iProject2 = this.fCurrProject.getProject();
        if (iProject2.exists() && iIncludePathEntryArray == null) {
            iIncludePathEntryArray = this.phpOptions.readRawIncludePath();
        }
        if (iIncludePathEntryArray != null) {
            list = this.getExistingEntries(iIncludePathEntryArray);
        }
        if (list == null) {
            list = this.getDefaultIncludePath(iProject);
        }
        this.fIncludePathList.setElements(list);
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (IncludePathBlock.this.fSWTWidget == null || IncludePathBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    IncludePathBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fIncludePathList.refresh();
        if (this.fProjectsPage != null) {
            this.fProjectsPage.init(this.fCurrProject);
            this.fLibrariesPage.init(this.fCurrProject);
        }
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.fIncludePathList.getSize();
        stringBuffer.append('[').append(n).append(']');
        int n2 = 0;
        while (n2 < n) {
            IPListElement iPListElement = (IPListElement)this.fIncludePathList.getElement(n2);
            iPListElement.appendEncodedSettings(stringBuffer);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean hasChangesInDialog() {
        String string = this.getEncodedSettings();
        return !string.equals(this.fUserSettingsTimeStamp);
    }

    public void initializeTimeStamps() {
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    private ArrayList getExistingEntries(IIncludePathEntry[] iIncludePathEntryArray) {
        ArrayList<IPListElement> arrayList = new ArrayList<IPListElement>();
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray[n];
            arrayList.add(IPListElement.createFromExisting(iIncludePathEntry, this.fCurrProject));
            ++n;
        }
        return arrayList;
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    public IIncludePathEntry[] getRawIncludePath() {
        List list = this.fIncludePathList.getElements();
        int n = list.size();
        IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[list.size()];
        int n2 = 0;
        while (n2 < n) {
            IPListElement iPListElement = (IPListElement)list.get(n2);
            iIncludePathEntryArray[n2] = iPListElement.getIncludePathEntry();
            ++n2;
        }
        return iIncludePathEntryArray;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    private List getDefaultIncludePath(IProject iProject) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private void includePathDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fIncludePathList) {
            this.updateIncludePathStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            StatusInfo statusInfo = this.fIncludePathStatus;
            this.fContext.statusChanged((IStatus)statusInfo);
        }
    }

    public void updateIncludePathStatus() {
        this.fIncludePathStatus.setOK();
        List list = this.fIncludePathList.getElements();
        IPListElement iPListElement = null;
        int n = 0;
        IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[list.size()];
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            IPListElement iPListElement2 = (IPListElement)list.get(n2);
            iIncludePathEntryArray[n2] = iPListElement2.getIncludePathEntry();
            if (iPListElement2.isMissing()) {
                ++n;
                if (iPListElement == null) {
                    iPListElement = iPListElement2;
                }
            }
            --n2;
        }
        if (n > 0) {
            if (n == 1) {
                this.fIncludePathStatus.setWarning(MessageFormat.format(PHPUIMessages.getString("IncludePathsBlock_warning_EntryMissing"), iPListElement.getPath().toString()));
            } else {
                this.fIncludePathStatus.setWarning(MessageFormat.format(PHPUIMessages.getString("IncludePathsBlock_warning_EntriesMissing"), String.valueOf(n)));
            }
        }
    }

    public static void createProject(IProject iProject, IPath iPath, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(PHPUIMessages.getString("IncludePathsBlock_operationdesc_project"), 10);
        try {
            if (!iProject.exists()) {
                IProjectDescription iProjectDescription = iProject.getWorkspace().newProjectDescription(iProject.getName());
                if (Platform.getLocation().equals((Object)iPath)) {
                    iPath = null;
                }
                iProjectDescription.setLocation(iPath);
                iProject.create(iProjectDescription, iProgressMonitor);
                iProgressMonitor = null;
            }
            if (!iProject.isOpen()) {
                iProject.open(iProgressMonitor);
                iProgressMonitor = null;
            }
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    public static void addPHPNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!iProject.hasNature("org.eclipse.php.core.PHPNature")) {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "org.eclipse.php.core.PHPNature";
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        } else {
            iProgressMonitor.worked(1);
        }
    }

    public void configurePHPProject(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.setTaskName(PHPUIMessages.getString("IncludePathsBlock_operationdesc_php"));
        iProgressMonitor.beginTask("", 10);
        try {
            this.internalConfigurePHPProject(this.fIncludePathList.getElements(), iProgressMonitor);
        }
        finally {
            iProgressMonitor.done();
        }
        this.updateUI();
    }

    public IIncludePathEntry[] getIncludepathEntries() {
        List list = this.fIncludePathList.getElements();
        int n = list.size();
        IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[n];
        int n2 = 0;
        while (n2 < n) {
            IPListElement iPListElement = (IPListElement)list.get(n2);
            iIncludePathEntryArray[n2] = iPListElement.getIncludePathEntry();
            ++n2;
        }
        return iIncludePathEntryArray;
    }

    private void internalConfigurePHPProject(List list, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        iProgressMonitor.worked(2);
        int n = list.size();
        IIncludePathEntry[] iIncludePathEntryArray = new IIncludePathEntry[n];
        int n2 = 0;
        while (n2 < n) {
            IPListElement iPListElement = (IPListElement)list.get(n2);
            IResource iResource = iPListElement.getResource();
            if (iResource instanceof IFolder && !iResource.exists()) {
                this.createFolder((IFolder)iResource, true, true, null);
            }
            iIncludePathEntryArray[n2] = iPListElement.getIncludePathEntry();
            ++n2;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        iProgressMonitor.worked(1);
        this.phpOptions.setRawIncludePath(iIncludePathEntryArray, new SubProgressMonitor(iProgressMonitor, 7));
        this.initializeTimeStamps();
    }

    private void createFolder(IFolder iFolder, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFolder.exists()) {
            IContainer iContainer = iFolder.getParent();
            if (iContainer instanceof IFolder) {
                this.createFolder((IFolder)iContainer, bl, bl2, null);
            }
            iFolder.create(bl, bl2, iProgressMonitor);
        }
    }

    public static boolean hasClassfiles(IResource iResource) throws CoreException {
        if (iResource.isDerived()) {
            return true;
        }
        if (iResource instanceof IContainer) {
            IResource[] iResourceArray = ((IContainer)iResource).members();
            int n = 0;
            while (n < iResourceArray.length) {
                if (IncludePathBlock.hasClassfiles(iResourceArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource iResource) throws CoreException {
        if (iResource.isDerived()) {
            iResource.delete(false, null);
        } else if (iResource instanceof IContainer) {
            IResource[] iResourceArray = ((IContainer)iResource).members();
            int n = 0;
            while (n < iResourceArray.length) {
                IncludePathBlock.removeOldClassfiles(iResourceArray[n]);
                ++n;
            }
        }
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List list;
            TabItem tabItem = (TabItem)widget;
            IncludePathBasePage includePathBasePage = (IncludePathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(list = this.fCurrPage.getSelection()).isEmpty()) {
                includePathBasePage.setSelection(list, false);
            }
            this.fCurrPage = includePathBasePage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int n) {
        switch (n) {
            case 1: 
            case 4: 
            case 5: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    private IPListElement findElement(IIncludePathEntry iIncludePathEntry) {
        int n = 0;
        int n2 = this.fIncludePathList.getSize();
        while (n < n2) {
            IPListElement iPListElement = (IPListElement)this.fIncludePathList.getElement(n);
            if (iPListElement.getEntryKind() == iIncludePathEntry.getEntryKind() && iPListElement.getPath().equals((Object)iIncludePathEntry.getPath())) {
                return iPListElement;
            }
            ++n;
        }
        return null;
    }

    public void setElementToReveal(IIncludePathEntry iIncludePathEntry, String string) {
        int n = this.getPageIndex(iIncludePathEntry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = n;
        } else {
            this.fTabFolder.setSelection(n);
            IPListElement iPListElement = this.findElement(iIncludePathEntry);
            if (iPListElement != null) {
                Object object;
                Object object2 = iPListElement;
                if (string != null && (object = iPListElement.findAttributeElement(string)) != null) {
                    object2 = object;
                }
                object = (IncludePathBasePage)this.fTabFolder.getItem(n).getData();
                ArrayList<Object> arrayList = new ArrayList<Object>(1);
                arrayList.add(object2);
                ((IncludePathBasePage)object).setSelection(arrayList, true);
            }
        }
    }

    public void dispose() {
        this.fLibrariesPage.dispose();
    }

    private class IncludePathAdapter
    implements IDialogFieldListener {
        private IncludePathAdapter() {
        }

        public void changeControlPressed(DialogField dialogField) {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            IncludePathBlock.this.includePathDialogFieldChanged(dialogField);
        }
    }
}

