/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.loader;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.documentModel.parser.PhpStructuredDocumentReParser;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class PHPDocumentLoader
extends HTMLDocumentLoader {
    private static final boolean DEBUG = false;
    private CodedReaderCreator fCodedReaderCreator;

    protected IEncodedDocument newEncodedDocument() {
        IEncodedDocument iEncodedDocument = super.newEncodedDocument();
        assert (iEncodedDocument instanceof BasicStructuredDocument);
        ((BasicStructuredDocument)iEncodedDocument).setReParser((IStructuredTextReParser)new PhpStructuredDocumentReParser());
        return iEncodedDocument;
    }

    public RegionParser getParser() {
        PhpSourceParser phpSourceParser = new PhpSourceParser();
        this.addHTMLishTag(phpSourceParser, "script");
        this.addHTMLishTag(phpSourceParser, "style");
        return phpSourceParser;
    }

    public IDocumentLoader newInstance() {
        return new PHPDocumentLoader();
    }

    public IDocumentPartitioner getDefaultDocumentPartitioner() {
        return new PHPStructuredTextPartitioner();
    }

    protected CodedReaderCreator getCodedReaderCreator() {
        if (this.fCodedReaderCreator == null) {
            this.fCodedReaderCreator = new PHPCodedReaderCreator();
        }
        return this.fCodedReaderCreator;
    }

    class PHPCodedReaderCreator
    extends CodedReaderCreator {
        PHPCodedReaderCreator() {
        }

        protected EncodingMemento createMemento(IContentDescription iContentDescription) {
            String string = iContentDescription.getContentType().getDefaultCharset();
            String string2 = (String)iContentDescription.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
            String string3 = (String)iContentDescription.getProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET);
            String string4 = iContentDescription.getCharset();
            if (string2 == null && string == null) {
                string4 = string = ResourcesPlugin.getEncoding();
                string2 = string;
            }
            if (string4 == null) {
                Logger.log((int)201, (String)"charset equaled null!");
            } else if (string4.length() == 0) {
                Logger.log((int)201, (String)"charset equaled emptyString!");
            }
            byte[] byArray = (byte[])iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
            EncodingMemento encodingMemento = PHPCodedReaderCreator.createEncodingMemento((byte[])byArray, (String)string4, (String)string2, (String)string3, (String)string, null);
            if (!encodingMemento.isValid()) {
                encodingMemento.setAppropriateDefault(string);
            }
            return encodingMemento;
        }
    }
}

