/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.text;

import javax.swing.text.Segment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public final class TextSequenceUtilities {
    private TextSequenceUtilities() {
    }

    public static TextSequence createTextSequence(IStructuredDocumentRegion iStructuredDocumentRegion) {
        return TextSequenceUtilities.createTextSequence(iStructuredDocumentRegion, 0, iStructuredDocumentRegion.getLength());
    }

    public static TextSequence createTextSequence(IStructuredDocumentRegion iStructuredDocumentRegion, int n, int n2) {
        String string = ((BasicStructuredDocument)iStructuredDocumentRegion.getParentDocument()).get(n, n2);
        Segment segment = new Segment(string.toCharArray(), 0, string.length());
        return new SimpleTextSequence(iStructuredDocumentRegion, segment, 0, segment.count, n);
    }

    public static String getType(TextSequence textSequence, int n) {
        int n2 = textSequence.getOriginalOffset(n);
        return TextSequenceUtilities.getTypeByAbsoluteOffset(textSequence, n2);
    }

    public static String getTypeByAbsoluteOffset(TextSequence textSequence, int n) {
        ITextRegion iTextRegion;
        IStructuredDocumentRegion iStructuredDocumentRegion = textSequence.getSource();
        if (iStructuredDocumentRegion.getEndOffset() == n && iStructuredDocumentRegion.getEndOffset() > 0) {
            --n;
        }
        if ((iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n)) == null) {
            return null;
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            try {
                return ((IPhpScriptRegion)iTextRegion).getPhpTokenType(n - iStructuredDocumentRegion.getStart() - iTextRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                assert (false);
                return null;
            }
        }
        if (iTextRegion != null) {
            return iTextRegion.getType();
        }
        return null;
    }

    private static abstract class AbstractTextSequence
    implements TextSequence {
        IStructuredDocumentRegion source;
        Segment segment;
        int segmentOriginalStart;

        protected AbstractTextSequence(IStructuredDocumentRegion iStructuredDocumentRegion, Segment segment, int n) {
            this.source = iStructuredDocumentRegion;
            this.segment = segment;
            this.segmentOriginalStart = n;
        }

        public IStructuredDocumentRegion getSource() {
            return this.source;
        }

        public char charAt(int n) {
            return this.segment.array[this.getSegmentOffset(n)];
        }

        public CharSequence subSequence(int n, int n2) {
            return this.subTextSequence(n, n2);
        }

        protected abstract int getSegmentOffset(int var1);
    }

    private static class CompositeTextSequence
    extends AbstractTextSequence
    implements TextSequence {
        private final int[] indexes;
        private int length = -1;

        CompositeTextSequence(IStructuredDocumentRegion iStructuredDocumentRegion, Segment segment, int[] nArray, int n) {
            super(iStructuredDocumentRegion, segment, n);
            this.indexes = nArray;
        }

        public int length() {
            if (this.length == -1) {
                int n = 0;
                int n2 = 1;
                while (n2 < this.indexes.length) {
                    n += this.indexes[n2];
                    n2 += 2;
                }
                this.length = n;
            }
            return this.length;
        }

        public int getOriginalOffset(int n) {
            int n2 = this.segmentOriginalStart;
            int n3 = 0;
            while (n3 < this.indexes.length) {
                if (n - this.indexes[n3 + 1] < 0) {
                    n2 += this.indexes[n3] + n;
                    break;
                }
                n -= this.indexes[n3 + 1];
                n3 += 2;
            }
            return n2;
        }

        protected int getSegmentOffset(int n) {
            int n2 = this.segment.offset;
            int n3 = 0;
            while (n3 < this.indexes.length) {
                if (n - this.indexes[n3 + 1] < 0) {
                    n2 += this.indexes[n3] + n;
                    break;
                }
                n -= this.indexes[n3 + 1];
                n3 += 2;
            }
            return n2;
        }

        public TextSequence subTextSequence(int n, int n2) {
            if (n == 0 && n2 == this.length()) {
                return this;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.indexes.length) {
                if (n5 + this.indexes[n6 + 1] > n) {
                    n3 = n6 >> 1;
                    break;
                }
                n5 += this.indexes[n6 + 1];
                n6 += 2;
            }
            n6 = n5;
            int n7 = n3 << 1;
            while (n7 < this.indexes.length) {
                if (n6 + this.indexes[n7 + 1] >= n2) {
                    n4 = n7 >> 1;
                    break;
                }
                n6 += this.indexes[n7 + 1];
                n7 += 2;
            }
            n7 = n4 - n3 + 1;
            if (n7 == 1) {
                int n8 = this.indexes[n3 << 1] + n - n5;
                int n9 = n2 - n;
                return new SimpleTextSequence(this.source, this.segment, n8, n9, this.segmentOriginalStart);
            }
            int[] nArray = new int[n7 << 1];
            nArray[0] = this.indexes[n3 << 1] + n - n5;
            nArray[1] = this.indexes[(n3 << 1) + 1] - (n - n5);
            int n10 = 2;
            while (n10 < nArray.length - 3) {
                nArray[n10] = this.indexes[n10 + (n3 << 1)];
                nArray[n10 + 1] = this.indexes[n10 + (n3 << 1) + 1];
                ++n10;
            }
            nArray[nArray.length - 2] = this.indexes[n4 << 1];
            nArray[nArray.length - 1] = n2 - n6;
            return new CompositeTextSequence(this.source, this.segment, nArray, this.segmentOriginalStart);
        }

        public TextSequence cutTextSequence(int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.indexes.length) {
                if (n5 + this.indexes[n6 + 1] > n) {
                    n3 = n6 >> 1;
                    break;
                }
                n5 += this.indexes[n6 + 1];
                n6 += 2;
            }
            n6 = n5;
            int n7 = n3 << 1;
            while (n7 < this.indexes.length) {
                if (n6 + this.indexes[n7 + 1] >= n2) {
                    n4 = n7 >> 1;
                    break;
                }
                n6 += this.indexes[n7 + 1];
                n7 += 2;
            }
            n7 = this.indexes.length >> 1;
            int n8 = n3 + n7 - n4 + 1;
            int[] nArray = new int[n8 << 1];
            int n9 = 0;
            while (n9 < n3) {
                nArray[n9 << 1] = this.indexes[n9 << 1];
                nArray[(n9 << 1) + 1] = this.indexes[(n9 << 1) + 1];
                ++n9;
            }
            nArray[n9 << 1] = this.indexes[n3 << 1];
            nArray[(n9 << 1) + 1] = n - n5;
            nArray[++n9 << 1] = this.indexes[n4 << 1] + (n2 - n6);
            nArray[(n9 << 1) + 1] = this.indexes[(n4 << 1) + 1] - (n2 - n6);
            ++n9;
            int n10 = n7 - n8;
            while (n9 + n10 < n7) {
                nArray[n9 << 1] = this.indexes[n9 + n10 << 1];
                nArray[(n9 << 1) + 1] = this.indexes[(n9 + n10 << 1) + 1];
                ++n9;
            }
            return new CompositeTextSequence(this.source, this.segment, nArray, this.segmentOriginalStart);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.length());
            int n = 0;
            while (n < this.indexes.length) {
                stringBuffer.append(this.segment.array, this.segment.offset + this.indexes[n], this.indexes[n + 1]);
                n += 2;
            }
            return stringBuffer.toString();
        }
    }

    private static class SimpleTextSequence
    extends AbstractTextSequence
    implements TextSequence {
        private final int offset;
        private final int length;

        SimpleTextSequence(IStructuredDocumentRegion iStructuredDocumentRegion, Segment segment, int n, int n2, int n3) {
            super(iStructuredDocumentRegion, segment, n3);
            this.offset = n;
            this.length = n2;
        }

        public int getOriginalOffset(int n) {
            return this.segmentOriginalStart + this.offset + n;
        }

        protected int getSegmentOffset(int n) {
            return this.segment.offset + this.offset + n;
        }

        public int length() {
            return this.length;
        }

        public TextSequence subTextSequence(int n, int n2) {
            return new SimpleTextSequence(this.source, this.segment, this.offset + n, n2 - n, this.segmentOriginalStart);
        }

        public TextSequence cutTextSequence(int n, int n2) {
            if (n == 0) {
                return this.subTextSequence(n2, this.length);
            }
            if (n2 == this.length) {
                return this.subTextSequence(0, n);
            }
            int[] nArray = new int[]{this.offset, n, this.offset + n2, this.length - n2};
            return new CompositeTextSequence(this.source, this.segment, nArray, this.segmentOriginalStart);
        }

        public String toString() {
            return new String(this.segment.array, this.segment.offset + this.offset, this.length);
        }
    }
}

