/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;

public class XDebugLaunchListener
implements ILaunchesListener {
    private static final String SYSTEM_DEBUG_PROPERTY = IDELayerFactory.getIDELayer().getSystemDebugProperty();
    private static XDebugLaunchListener instance;
    private boolean webLaunchActive;

    private XDebugLaunchListener() {
    }

    public static XDebugLaunchListener getInstance() {
        if (instance == null) {
            instance = new XDebugLaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)instance);
        }
        return instance;
    }

    public static void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)instance);
    }

    public void launchesAdded(ILaunch[] iLaunchArray) {
        this.updateStatus(iLaunchArray, true);
    }

    public void launchesChanged(ILaunch[] iLaunchArray) {
        this.updateStatus(iLaunchArray, true);
    }

    public void launchesRemoved(ILaunch[] iLaunchArray) {
        this.updateStatus(iLaunchArray, false);
    }

    public void updateStatus(ILaunch[] iLaunchArray, boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < iLaunchArray.length) {
            ILaunch iLaunch = iLaunchArray[n];
            IDebugTarget iDebugTarget = iLaunch.getDebugTarget();
            if (iDebugTarget instanceof IDBGpDebugTarget && ((IDBGpDebugTarget)iDebugTarget).isWebLaunch()) {
                this.webLaunchActive = bl;
            }
            bl2 |= !iLaunch.isTerminated();
            ++n;
        }
        System.setProperty(SYSTEM_DEBUG_PROPERTY, bl2 ? "true" : "false");
    }

    public boolean isWebLaunchActive() {
        return this.webLaunchActive;
    }
}

