/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathMapper
implements IXMLPreferencesStorable {
    private Map<VirtualPath, VirtualPath> remoteToLocalMap = new HashMap<VirtualPath, VirtualPath>();
    private Map<VirtualPath, VirtualPath> localToRemoteMap = new HashMap<VirtualPath, VirtualPath>();
    private Map<VirtualPath, PathEntry.Type> localToPathEntryType = new HashMap<VirtualPath, PathEntry.Type>();

    /*
     * Unable to fully structure code
     */
    public synchronized void addEntry(String var1_1, PathEntry var2_2) {
        var3_3 = new VirtualPath(var1_1);
        var4_4 = var2_2.getAbstractPath().clone();
        if (var3_3.getLastSegment().equalsIgnoreCase(var4_4.getLastSegment())) ** GOTO lbl10
        return;
        while (var3_3.getLastSegment().equalsIgnoreCase(var4_4.getLastSegment())) {
            var3_3.removeLastSegment();
            var4_4.removeLastSegment();
lbl10:
            // 2 sources

            if (var3_3.getSegmentsCount() > 0 && var4_4.getSegmentsCount() > 1) continue;
        }
        if (!var3_3.equals(var4_4)) {
            this.remoteToLocalMap.put(var3_3, var4_4);
            this.localToRemoteMap.put(var4_4, var3_3);
            this.localToPathEntryType.put(var4_4, var2_2.getType());
        }
    }

    public String getRemoteFile(String string) {
        VirtualPath virtualPath = this.getPath(this.localToRemoteMap, new VirtualPath(string));
        if (virtualPath != null) {
            return virtualPath.toString();
        }
        return null;
    }

    public VirtualPath getLocalPathMapping(VirtualPath virtualPath) {
        return this.remoteToLocalMap.get(virtualPath);
    }

    public PathEntry getLocalFile(String string) {
        VirtualPath virtualPath = this.getPath(this.remoteToLocalMap, new VirtualPath(string));
        if (virtualPath != null) {
            String string2 = virtualPath.toString();
            PathEntry.Type type = this.getPathType(virtualPath);
            if (type == PathEntry.Type.WORKSPACE) {
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string2);
                if (iResource != null) {
                    return new PathEntry(virtualPath, type, (Object)iResource.getParent());
                }
            } else {
                File file = new File(string2);
                if (file.exists()) {
                    if (type == PathEntry.Type.INCLUDE_FOLDER || type == PathEntry.Type.INCLUDE_VAR) {
                        return new PathEntry(virtualPath, type, null);
                    }
                    return new PathEntry(virtualPath, type, (Object)file.getParentFile());
                }
            }
        }
        return null;
    }

    protected VirtualPath getPath(Map<VirtualPath, VirtualPath> map, VirtualPath virtualPath) {
        virtualPath = virtualPath.clone();
        VirtualPath virtualPath2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (virtualPath.getSegmentsCount() > 0) {
            virtualPath2 = map.get(virtualPath);
            if (virtualPath2 != null) {
                virtualPath2 = virtualPath2.clone();
                break;
            }
            linkedList.add(virtualPath.removeLastSegment());
        }
        if (virtualPath2 == null && (virtualPath2 = map.get(virtualPath)) != null) {
            virtualPath2 = virtualPath2.clone();
        }
        if (virtualPath2 != null) {
            ListIterator listIterator = linkedList.listIterator(linkedList.size());
            while (listIterator.hasPrevious()) {
                virtualPath2.addLastSegment((String)listIterator.previous());
            }
        }
        return virtualPath2;
    }

    protected PathEntry.Type getPathType(VirtualPath virtualPath) {
        virtualPath = virtualPath.clone();
        while (virtualPath.getSegmentsCount() > 0) {
            PathEntry.Type type = this.localToPathEntryType.get(virtualPath);
            if (type != null) {
                return type;
            }
            virtualPath.removeLastSegment();
        }
        return null;
    }

    public synchronized Mapping[] getMapping() {
        ArrayList<Mapping> arrayList = new ArrayList<Mapping>(this.localToRemoteMap.size());
        for (VirtualPath virtualPath : this.localToRemoteMap.keySet()) {
            VirtualPath virtualPath2 = this.localToRemoteMap.get(virtualPath);
            PathEntry.Type type = this.localToPathEntryType.get(virtualPath);
            arrayList.add(new Mapping(virtualPath, virtualPath2, type));
        }
        return arrayList.toArray(new Mapping[arrayList.size()]);
    }

    public synchronized void setMapping(Mapping[] mappingArray) {
        this.remoteToLocalMap.clear();
        this.localToRemoteMap.clear();
        this.localToPathEntryType.clear();
        Mapping[] mappingArray2 = mappingArray;
        int n = mappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping mapping = mappingArray2[n2];
            this.localToRemoteMap.put(mapping.localPath, mapping.remotePath);
            this.remoteToLocalMap.put(mapping.remotePath, mapping.localPath);
            this.localToPathEntryType.put(mapping.localPath, mapping.type);
            ++n2;
        }
    }

    public synchronized void addMapping(Mapping mapping) {
        this.localToRemoteMap.put(mapping.localPath, mapping.remotePath);
        this.remoteToLocalMap.put(mapping.remotePath, mapping.localPath);
        this.localToPathEntryType.put(mapping.localPath, mapping.type);
    }

    public synchronized void removeMapping(Mapping mapping) {
        this.localToRemoteMap.remove(mapping.localPath);
        this.remoteToLocalMap.remove(mapping.remotePath);
        this.localToPathEntryType.remove(mapping.localPath);
    }

    public synchronized void restoreFromMap(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        this.remoteToLocalMap.clear();
        this.localToRemoteMap.clear();
        this.localToPathEntryType.clear();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap2 = (HashMap)hashMap.get(iterator.next());
            String string = (String)hashMap2.get("local");
            String string2 = (String)hashMap2.get("remote");
            String string3 = (String)hashMap2.get("type");
            if (string == null || string2 == null || string3 == null) continue;
            PathEntry.Type type = PathEntry.Type.valueOf(string3);
            VirtualPath virtualPath = new VirtualPath(string);
            VirtualPath virtualPath2 = new VirtualPath(string2);
            this.remoteToLocalMap.put(virtualPath2, virtualPath);
            this.localToRemoteMap.put(virtualPath, virtualPath2);
            this.localToPathEntryType.put(virtualPath, type);
        }
    }

    public synchronized HashMap storeToMap() {
        HashMap hashMap = new HashMap();
        Iterator<VirtualPath> iterator = this.localToRemoteMap.keySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            VirtualPath virtualPath = iterator.next();
            VirtualPath virtualPath2 = this.localToRemoteMap.get(virtualPath);
            PathEntry.Type type = this.localToPathEntryType.get(virtualPath);
            hashMap2.put("local", virtualPath);
            hashMap2.put("remote", virtualPath2);
            if (type != null) {
                hashMap2.put("type", type.name());
            }
            hashMap.put("item" + n++, hashMap2);
        }
        return hashMap;
    }

    public static class Mapping
    implements Cloneable {
        public VirtualPath localPath;
        public VirtualPath remotePath;
        public PathEntry.Type type;

        public Mapping() {
        }

        public Mapping(VirtualPath virtualPath, VirtualPath virtualPath2, PathEntry.Type type) {
            this.localPath = virtualPath;
            this.remotePath = virtualPath2;
            this.type = type;
        }

        public Mapping clone() {
            return new Mapping(this.localPath, this.remotePath, this.type);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Mapping)) {
                return false;
            }
            Mapping mapping = (Mapping)object;
            return mapping.localPath.equals(this.localPath) && mapping.remotePath.equals(this.remotePath) && mapping.type == this.type;
        }

        public int hashCode() {
            return this.localPath.hashCode() + 13 * this.remotePath.hashCode() + 31 * this.type.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Mapping { ");
            stringBuilder.append(this.localPath).append(", ").append(this.remotePath).append(", ").append((Object)this.type);
            return stringBuilder.toString();
        }
    }
}

