/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;

public class PHPexeItem {
    public static final String SAPI_CLI = "CLI";
    public static final String SAPI_CGI = "CGI";
    private static final Pattern PHP_VERSION = Pattern.compile("PHP (\\d\\.\\d\\.\\d+).*? \\((.*?)\\)");
    private static final Pattern PHP_CLI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path => (.*?)");
    private static final Pattern PHP_CGI_CONFIG = Pattern.compile("Configuration File \\(php.ini\\) Path </td><td class=\"v\">(.*?)</td>");
    private String sapiType;
    private String name;
    private File config;
    private File detectedConfig;
    private File executable;
    private String version;
    private boolean editable = true;
    private String debuggerID;
    private boolean isDefault;

    public PHPexeItem(String string, String string2, String string3, String string4) {
        this.name = string;
        this.debuggerID = string4;
        this.executable = new File(string2);
        if (string3 != null && string3.length() > 0) {
            this.config = new File(string3);
        }
        this.detectFromPHPExe();
    }

    public PHPexeItem(String string, File file, File file2, String string2, boolean bl) {
        this.name = string;
        this.executable = file;
        this.config = file2;
        this.debuggerID = string2;
        this.editable = bl;
        this.detectFromPHPExe();
    }

    public PHPexeItem() {
    }

    public String getDebuggerID() {
        return this.debuggerID;
    }

    public void setDebuggerID(String string) {
        this.debuggerID = string;
    }

    public File getINILocation() {
        return this.config;
    }

    public File getDetectedINILocation() {
        return this.detectedConfig;
    }

    public void setINILocation(File file) {
        this.config = file;
    }

    public String getSapiType() {
        return this.sapiType;
    }

    public void setSapiType(String string) {
        this.sapiType = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public File getExecutable() {
        return this.executable;
    }

    public void setExecutable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("PHP executable path is null");
        }
        if (file.equals(this.executable)) {
            return;
        }
        this.executable = file;
        this.config = null;
        this.detectFromPHPExe();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.executable == null ? 0 : this.executable.hashCode());
        n = 31 * n + (this.config == null ? 0 : this.config.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PHPexeItem pHPexeItem = (PHPexeItem)object;
        if (this.config == null ? pHPexeItem.config != null : !this.config.equals(pHPexeItem.config)) {
            return false;
        }
        return !(this.name == null ? pHPexeItem.name != null : !this.name.equals(pHPexeItem.name));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append(" [path: ").append(this.executable.getAbsolutePath());
        stringBuilder.append(", config file: ").append(this.config.getAbsolutePath());
        stringBuilder.append(", sapi: ").append(this.sapiType);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    protected void detectFromPHPExe() {
        block15: {
            if (this.executable == null) {
                throw new IllegalStateException("PHP executable path is null");
            }
            File file = PHPINIUtil.createTemporaryPHPINIFile();
            try {
                String string;
                PHPexes.changePermissions(this.executable);
                String string2 = PHPexeItem.exec(this.executable.getAbsolutePath(), "-c", file.getParentFile().getAbsolutePath(), "-v");
                Matcher matcher = PHP_VERSION.matcher(string2);
                if (matcher.find()) {
                    this.version = matcher.group(1);
                    string = matcher.group(2);
                    if (string.startsWith("cgi")) {
                        this.sapiType = SAPI_CGI;
                    } else if (string.startsWith("cli")) {
                        this.sapiType = SAPI_CLI;
                    } else {
                        PHPDebugPlugin.logWarningMessage("Can't determine type of the PHP executable");
                        return;
                    }
                    if (this.name == null) {
                        this.name = "PHP " + this.version + " (" + this.sapiType + ")";
                    }
                } else {
                    PHPDebugPlugin.logWarningMessage("Can't determine version of the PHP executable");
                    return;
                }
                if (this.detectedConfig != null) break block15;
                string2 = PHPexeItem.exec(this.executable.getAbsolutePath(), "-c", file.getParentFile().getAbsolutePath(), "-i");
                if (this.sapiType == SAPI_CLI) {
                    matcher = PHP_CLI_CONFIG.matcher(string2);
                } else if (this.sapiType == SAPI_CGI) {
                    matcher = PHP_CGI_CONFIG.matcher(string2);
                }
                if (matcher.find()) {
                    string = matcher.group(1);
                    this.detectedConfig = new File(string.trim(), "php.ini");
                    if (!this.detectedConfig.exists()) {
                        this.detectedConfig = null;
                    }
                    break block15;
                }
                PHPDebugPlugin.logWarningMessage("Can't determine PHP.ini location of the PHP executable");
                return;
            }
            catch (IOException iOException) {
                DebugPlugin.log((Throwable)iOException);
            }
        }
    }

    private static String exec(String ... stringArray) throws IOException {
        String string;
        Process process = Runtime.getRuntime().exec(stringArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder.toString();
    }
}

