/**
 * 
 */
package lib.org.eclipse.php.test.headless.core;

import org.eclipse.jface.text.IDocument;

/**
 * @author seva, 2007
 *
 */
public class Utils {

	public static int getOffset(int line, int offsetAtLine, IDocument testDocument) throws Exception {
		if (line > testDocument.getNumberOfLines())
			throw new IllegalArgumentException("Line " + line + " does not exist");
		final int lineOffset = testDocument.getLineOffset(line);
		final int documentOffset = lineOffset + offsetAtLine;
		if (testDocument.getLineOfOffset(documentOffset) != line)
			throw new IllegalArgumentException("Line offset " + line + ":" + offsetAtLine + " does not exist");
		return documentOffset;
	}

}
