/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.File;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

public class PHPCodeDataHTMLDescriptionUtilities {
    private static Pattern dolar_pattern = Pattern.compile("\\$");
    private static Pattern unknown_type_pattern = Pattern.compile("unknown_type\\ ");
    private static StringBuffer descriptionText = new StringBuffer();
    private static StringBuffer helpBuffer = new StringBuffer();

    public static final String createFunctionDescriptionText(PHPCodeData pHPCodeData, PHPProjectModel pHPProjectModel) {
        Object object;
        boolean bl;
        descriptionText.delete(0, descriptionText.length());
        String string = pHPCodeData.getDescription();
        PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
        String string2 = pHPCodeData.isUserCode() ? pHPCodeData.getUserData().getFileName() : null;
        boolean bl2 = bl = pHPCodeData2 != null && pHPCodeData2 instanceof PHPClassData;
        if (string2 != null) {
            object = new File(string2);
            Path path = new Path(string2);
            if (path.getDevice() != null && !((File)object).exists()) {
                string2 = new Path(string2).lastSegment();
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string2));
            } else {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string2));
            }
        }
        if (bl) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(pHPCodeData2.getName(), pHPProjectModel));
        }
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        if (pHPCodeData.getDocBlock() != null) {
            object = pHPCodeData.getDocBlock().getTags(7);
            if (object.hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getParamTagTableRows((Iterator)object));
            }
            if ((object = pHPCodeData.getDocBlock().getTags(6)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getReturnTagTableRows((Iterator)object));
            }
            if ((object = pHPCodeData.getDocBlock().getTags(29)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getThrowTagTableRows((Iterator)object));
            }
            if ((object = pHPCodeData.getDocBlock().getTags(8)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getSeeAlsoTagTableRows((Iterator)object, pHPProjectModel, pHPCodeData));
            }
            if ((object = pHPCodeData.getDocBlock().getTags(2)).hasNext()) {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDeprecatedTagTableRow((Iterator)object));
            }
        }
        return descriptionText.toString();
    }

    public static String createClassDescriptionText(PHPClassData pHPClassData, PHPProjectModel pHPProjectModel) {
        Path path;
        Object object;
        descriptionText.delete(0, descriptionText.length());
        PHPFileData cfr_ignored_0 = (PHPFileData)pHPClassData.getContainer();
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = pHPClassData.getInterfacesNamesData();
        String string = null;
        String string2 = null;
        String[] stringArray = null;
        String string3 = pHPClassData.getDescription();
        String string4 = string = pHPClassData.isUserCode() ? pHPClassData.getUserData().getFileName() : null;
        if (string != null) {
            object = new File(string);
            path = new Path(string);
            if (path.getDevice() != null && !((File)object).exists()) {
                string = new Path(string).lastSegment();
            }
        }
        if (pHPSuperClassNameData != null) {
            string2 = pHPSuperClassNameData.getName();
        }
        if (pHPInterfaceNameDataArray != null && pHPInterfaceNameDataArray.length > 0) {
            stringArray = new String[pHPInterfaceNameDataArray.length];
            int n = 0;
            while (n < pHPInterfaceNameDataArray.length) {
                path = pHPInterfaceNameDataArray[n];
                stringArray[n] = path.getName();
                ++n;
            }
        }
        if (string != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string));
        }
        if (string2 != null) {
            descriptionText.append("<br><dt>Extends</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(string2);
            descriptionText.append("</dd>");
        }
        if (stringArray != null) {
            descriptionText.append("<br><dt>Implements</dt>");
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                descriptionText.append("<dd>");
                descriptionText.append((String)object);
                descriptionText.append("</dd>");
                ++n2;
            }
        }
        if (string3.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string3));
        }
        return descriptionText.toString();
    }

    public static String createVariableDescriptionText(PHPVariableData pHPVariableData) {
        descriptionText.delete(0, descriptionText.length());
        String string = pHPVariableData.getDescription();
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        return descriptionText.toString();
    }

    public static String createClassVariableDescriptionText(PHPClassVarData pHPClassVarData, PHPProjectModel pHPProjectModel) {
        String string;
        descriptionText.delete(0, descriptionText.length());
        String string2 = pHPClassVarData.getDescription();
        PHPCodeData pHPCodeData = pHPClassVarData.getContainer();
        String string3 = pHPCodeData != null ? pHPCodeData.getName() : null;
        String string4 = string = pHPCodeData != null ? pHPClassVarData.getUserData().getFileName() : null;
        if (string != null) {
            File file = new File(string);
            Path path = new Path(string);
            if (path.getDevice() != null && !file.exists()) {
                string = new Path(string).lastSegment();
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string));
            } else {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string));
            }
        }
        if (string3 != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(string3, pHPProjectModel));
        }
        if (string2.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string2));
        }
        return descriptionText.toString();
    }

    public static String createPHPConstantDescriptionText(PHPConstantData pHPConstantData) {
        descriptionText.delete(0, descriptionText.length());
        String string = pHPConstantData.getDescription();
        String string2 = pHPConstantData.getUserData() != null ? pHPConstantData.getUserData().getFileName() : null;
        String string3 = pHPConstantData.getValue();
        if (string2 != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string2));
        }
        if (string3 != null && string3.length() > 0) {
            descriptionText.append("<br><dt>Value</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(string3);
            descriptionText.append("</dd>");
        }
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        return descriptionText.toString();
    }

    public static String createPHPClassConstDescriptionText(PHPClassConstData pHPClassConstData, PHPProjectModel pHPProjectModel) {
        descriptionText.delete(0, descriptionText.length());
        String string = pHPClassConstData.getDescription();
        String string2 = pHPClassConstData.getContainer().getName();
        String string3 = pHPClassConstData.getUserData() != null ? pHPClassConstData.getUserData().getFileName() : null;
        String string4 = pHPClassConstData.getValue();
        if (string3 != null) {
            File file = new File(string3);
            Path path = new Path(string3);
            if (path.getDevice() != null && !file.exists()) {
                string3 = new Path(string3).lastSegment();
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string3));
            } else {
                descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getLocationTableRow(string3));
            }
        }
        if (string2 != null) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getClassNameTableRow(string2, pHPProjectModel));
        }
        if (string4 != null && string4.length() > 0) {
            descriptionText.append("<br><dt>Value</dt>");
            descriptionText.append("<dd>");
            descriptionText.append(string4);
            descriptionText.append("</dd>");
        }
        if (string.length() > 0) {
            descriptionText.append(PHPCodeDataHTMLDescriptionUtilities.getDescriptionTableRow(string));
        }
        return descriptionText.toString();
    }

    private static String getLocationTableRow(String string) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Location</dt> ");
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getSeeAlsoTagTableRows(Iterator iterator, PHPProjectModel pHPProjectModel, PHPCodeData pHPCodeData) {
        String[] stringArray;
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>See Also</dt>");
        helpBuffer.append("<dd>");
        UserData userData = pHPCodeData.getUserData();
        String string = userData != null ? userData.getFileName() : null;
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        String string2 = pHPDocTag.getValue();
        String[] stringArray2 = stringArray = string2.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            if (pHPProjectModel.getFileData(string3) != null) {
                helpBuffer.append(string3);
                break;
            }
            if (pHPProjectModel.getClass(string3).length > 0) {
                helpBuffer.append(string3);
                break;
            }
            if (pHPProjectModel.getConstant(string3).length > 0) {
                helpBuffer.append(string3);
                break;
            }
            boolean bl = false;
            if (pHPCodeData instanceof PHPFunctionData && pHPCodeData.getContainer() != null && pHPCodeData.getContainer() instanceof PHPClassData) {
                if (string3.indexOf(40) != -1) {
                    string3 = string3.substring(0, string3.indexOf(40));
                }
                if (string != null && pHPProjectModel.getClassFunctionData(string, pHPCodeData.getContainer().getName(), string3) != null) {
                    helpBuffer.append(string3);
                    break;
                }
                if (string != null) {
                    CodeData[] codeDataArray;
                    PHPCodeContext pHPCodeContext = ModelSupport.createContext((CodeData)pHPCodeData);
                    if (string3.startsWith("$")) {
                        string3 = string3.substring(1);
                    }
                    CodeData[] codeDataArray2 = codeDataArray = pHPProjectModel.getVariables(string, pHPCodeContext, string3, true);
                    int n3 = codeDataArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CodeData codeData = codeDataArray2[n4];
                        if (((PHPCodeData)codeData).getName().equals(string3)) {
                            helpBuffer.append(string3);
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (bl) break;
                if (pHPProjectModel.getFunction(string3) != null && pHPProjectModel.getFunction(string3).length > 0) {
                    helpBuffer.append(string3);
                    break;
                }
            }
            helpBuffer.append(string3);
            ++n2;
        }
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getDeprecatedTagTableRow(Iterator iterator) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Deprecated</dt>");
        helpBuffer.append("<dd>");
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        helpBuffer.append(pHPDocTag.getValue());
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getReturnTagTableRows(Iterator iterator) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Returns</dt>");
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        String string = pHPDocTag.getValue();
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getThrowTagTableRows(Iterator iterator) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Throws</dt>");
        PHPDocTag pHPDocTag = (PHPDocTag)iterator.next();
        String string = pHPDocTag.getValue();
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getParamTagTableRows(Iterator iterator) {
        Object object;
        helpBuffer.delete(0, helpBuffer.length());
        while (iterator.hasNext()) {
            object = (PHPDocTag)iterator.next();
            String string = object.getValue();
            string = dolar_pattern.matcher(string).replaceAll("");
            if ((string = unknown_type_pattern.matcher(string).replaceAll("")).split(" ").length <= 1) continue;
            helpBuffer.append("<dd>");
            helpBuffer.append(string);
            helpBuffer.append("</dd>");
        }
        if (helpBuffer.toString().length() > 0) {
            object = "<br><dt>Parameters</dt>";
            helpBuffer = helpBuffer.insert(0, ((String)object).toCharArray(), 0, ((String)object).length());
        }
        return helpBuffer.toString();
    }

    private static String getDescriptionTableRow(String string) {
        helpBuffer.delete(0, helpBuffer.length());
        string = string.replaceAll("\\n", "<br>");
        helpBuffer.append("<br><dt>Description</dt>");
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    private static String getClassNameTableRow(String string, PHPProjectModel pHPProjectModel) {
        helpBuffer.delete(0, helpBuffer.length());
        helpBuffer.append("<br><dt>Class</dt>");
        helpBuffer.append("<dd>");
        helpBuffer.append(string);
        helpBuffer.append("</dd>");
        return helpBuffer.toString();
    }

    public static String getHTMLHyperlinkDescriptionText(CodeData codeData, PHPProjectModel pHPProjectModel) {
        if (!(codeData instanceof PHPCodeData)) {
            return "";
        }
        if (codeData instanceof PHPFunctionData) {
            return PHPCodeDataHTMLDescriptionUtilities.createFunctionDescriptionText((PHPCodeData)codeData, pHPProjectModel);
        }
        if (codeData instanceof PHPClassData) {
            return PHPCodeDataHTMLDescriptionUtilities.createClassDescriptionText((PHPClassData)codeData, pHPProjectModel);
        }
        if (codeData instanceof PHPClassVarData) {
            return PHPCodeDataHTMLDescriptionUtilities.createClassVariableDescriptionText((PHPClassVarData)codeData, pHPProjectModel);
        }
        if (codeData instanceof PHPVariableData) {
            return PHPCodeDataHTMLDescriptionUtilities.createVariableDescriptionText((PHPVariableData)codeData);
        }
        if (codeData instanceof PHPConstantData) {
            return PHPCodeDataHTMLDescriptionUtilities.createPHPConstantDescriptionText((PHPConstantData)codeData);
        }
        if (codeData instanceof PHPClassConstData) {
            return PHPCodeDataHTMLDescriptionUtilities.createPHPClassConstDescriptionText((PHPClassConstData)codeData, pHPProjectModel);
        }
        return "";
    }
}

