/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserExecuter;
import org.eclipse.php.internal.core.phpModel.parser.PhpParser;

public class PhpParserSchedulerTask
implements Runnable {
    private volatile boolean threadAlive = true;
    private static final int BUFFER_MAX_SIZE = Integer.MAX_VALUE;
    private final LinkedList<ParserExecuter> buffer = new LinkedList();
    protected static final PhpParserSchedulerTask instance = new PhpParserSchedulerTask();

    private PhpParserSchedulerTask() {
    }

    public static PhpParserSchedulerTask getInstance() {
        return instance;
    }

    public void run() {
        while (this.threadAlive) {
            try {
                ParserExecuter parserExecuter = this.release();
                assert (parserExecuter != null);
                Thread.sleep(500L);
                if (this.buffer.size() > 0) {
                    ParserExecuter parserExecuter2 = this.buffer.getFirst();
                    if (parserExecuter2.filename.equals(parserExecuter.filename)) continue;
                }
                parserExecuter.run();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized ParserExecuter release() throws InterruptedException {
        while (this.buffer.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ParserExecuter parserExecuter = this.buffer.removeFirst();
        this.notifyAll();
        return parserExecuter;
    }

    public synchronized void schedule(PHPParserManager pHPParserManager, PhpParser phpParser, ParserClient parserClient, String string, Reader reader, Pattern[] patternArray, long l, boolean bl) {
        ParserExecuter parserExecuter;
        if (this.buffer.size() > 0) {
            parserExecuter = this.buffer.getFirst();
            if (parserExecuter.filename.equals(string)) {
                this.buffer.removeFirst();
            }
        }
        while (this.buffer.size() >= Integer.MAX_VALUE) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        parserExecuter = new ParserExecuter(pHPParserManager, phpParser, parserClient, string, reader, patternArray, l, bl);
        this.buffer.addFirst(parserExecuter);
        this.notifyAll();
    }
}

