/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ti;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.core.ti.IEvaluationStatisticsListener;
import org.eclipse.php.internal.core.ti.IPruner;
import org.eclipse.php.internal.core.ti.evaluators.DefaultGoalEvaluatorFactory;
import org.eclipse.php.internal.core.ti.evaluators.IGoalEvaluator;
import org.eclipse.php.internal.core.ti.evaluators.IGoalEvaluatorFactory;
import org.eclipse.php.internal.core.ti.goals.IGoal;

public class TIEngine {
    private final LinkedList<WorkingPair> workingQueue = new LinkedList();
    private final Map<IGoal, GoalEvaluationState> goalStates = new HashMap<IGoal, GoalEvaluationState>();
    private final Map<IGoalEvaluator, EvaluatorState> evaluatorStates = new HashMap<IGoalEvaluator, EvaluatorState>();
    private final IGoalEvaluatorFactory evaluatorFactory;
    private IEvaluationStatisticsListener statisticsListener;

    public TIEngine() {
        this(new DefaultGoalEvaluatorFactory());
    }

    public TIEngine(IGoalEvaluatorFactory iGoalEvaluatorFactory) {
        this.evaluatorFactory = iGoalEvaluatorFactory;
    }

    private void notifyEvaluator(IGoalEvaluator iGoalEvaluator, IGoal iGoal) {
        long l = 0L;
        GoalEvaluationState goalEvaluationState = this.goalStates.get(iGoal);
        Object object = goalEvaluationState.result;
        IGoal.State state = goalEvaluationState.state;
        if (state == IGoal.State.WAITING) {
            state = IGoal.State.RECURSIVE;
        }
        l = System.currentTimeMillis();
        IGoal[] iGoalArray = iGoalEvaluator.subGoalDone(iGoal, object, state);
        this.statisticsListener.evaluatorReceivedResult(iGoalEvaluator, iGoal, iGoalArray, System.currentTimeMillis() - l);
        if (iGoalArray == null) {
            iGoalArray = IGoal.NO_GOALS;
        }
        int n = 0;
        while (n < iGoalArray.length) {
            this.workingQueue.add(new WorkingPair(iGoalArray[n], iGoalEvaluator));
            ++n;
        }
        EvaluatorState evaluatorState = this.evaluatorStates.get(iGoalEvaluator);
        --evaluatorState.subgoalsLeft;
        evaluatorState.subgoalsLeft += iGoalArray.length;
        evaluatorState.totalSubgoals += iGoalArray.length;
        evaluatorState.subgoals.addAll((Collection<IGoal>)Arrays.asList(iGoalArray));
        if (state == IGoal.State.DONE && object != null) {
            ++evaluatorState.successfulSubgoals;
        }
        if (evaluatorState.subgoalsLeft == 0) {
            l = System.currentTimeMillis();
            Object object2 = iGoalEvaluator.produceResult();
            this.statisticsListener.evaluatorProducedResult(iGoalEvaluator, object, System.currentTimeMillis() - l);
            GoalEvaluationState goalEvaluationState2 = this.goalStates.get(iGoalEvaluator.getGoal());
            Assert.isNotNull((Object)goalEvaluationState2);
            goalEvaluationState2.state = IGoal.State.DONE;
            goalEvaluationState2.result = object2;
            if (goalEvaluationState2.creator != null) {
                this.notifyEvaluator(goalEvaluationState2.creator, iGoalEvaluator.getGoal());
            }
        }
    }

    public Object evaluateGoal(IGoal iGoal, IPruner iPruner, IEvaluationStatisticsListener iEvaluationStatisticsListener) {
        Object object;
        long l = 0L;
        if (iEvaluationStatisticsListener == null) {
            iEvaluationStatisticsListener = new DefaultEvaluatorStatisticsListener();
        }
        this.statisticsListener = iEvaluationStatisticsListener;
        this.reset();
        if (iPruner != null) {
            iPruner.init();
        }
        this.workingQueue.add(new WorkingPair(iGoal, null));
        iEvaluationStatisticsListener.evaluationStarted(iGoal);
        while (!this.workingQueue.isEmpty()) {
            Object object2;
            object = this.workingQueue.getFirst();
            this.workingQueue.removeFirst();
            GoalEvaluationState goalEvaluationState = this.goalStates.get(((WorkingPair)object).goal);
            if (goalEvaluationState != null && ((WorkingPair)object).creator != null) {
                this.notifyEvaluator(((WorkingPair)object).creator, ((WorkingPair)object).goal);
                continue;
            }
            boolean bl = false;
            if (iPruner != null && ((WorkingPair)object).creator != null) {
                bl = iPruner.prune(((WorkingPair)object).goal);
            }
            if (bl) {
                this.storeGoal(((WorkingPair)object).goal, IGoal.State.PRUNED, null, ((WorkingPair)object).creator);
                this.notifyEvaluator(((WorkingPair)object).creator, ((WorkingPair)object).goal);
                continue;
            }
            IGoalEvaluator iGoalEvaluator = this.evaluatorFactory.createEvaluator(((WorkingPair)object).goal);
            Assert.isNotNull((Object)iGoalEvaluator);
            iEvaluationStatisticsListener.goalEvaluatorAssigned(((WorkingPair)object).goal, iGoalEvaluator);
            l = System.currentTimeMillis();
            IGoal[] iGoalArray = iGoalEvaluator.init();
            if (iGoalArray == null) {
                iGoalArray = IGoal.NO_GOALS;
            }
            iEvaluationStatisticsListener.evaluatorInitialized(iGoalEvaluator, iGoalArray, System.currentTimeMillis() - l);
            if (iGoalArray.length > 0) {
                int n = 0;
                while (n < iGoalArray.length) {
                    this.workingQueue.add(new WorkingPair(iGoalArray[n], iGoalEvaluator));
                    ++n;
                }
                object2 = new EvaluatorState(iGoalArray.length);
                ((EvaluatorState)object2).subgoals.addAll((Collection<IGoal>)Arrays.asList(iGoalArray));
                this.evaluatorStates.put(iGoalEvaluator, (EvaluatorState)object2);
                this.storeGoal(((WorkingPair)object).goal, IGoal.State.WAITING, null, ((WorkingPair)object).creator);
                continue;
            }
            l = System.currentTimeMillis();
            object2 = iGoalEvaluator.produceResult();
            iEvaluationStatisticsListener.evaluatorProducedResult(iGoalEvaluator, object2, System.currentTimeMillis() - l);
            this.storeGoal(((WorkingPair)object).goal, IGoal.State.DONE, object2, ((WorkingPair)object).creator);
            if (((WorkingPair)object).creator == null) continue;
            this.notifyEvaluator(((WorkingPair)object).creator, ((WorkingPair)object).goal);
        }
        object = this.goalStates.get(iGoal);
        Assert.isTrue((((GoalEvaluationState)object).state == IGoal.State.DONE ? 1 : 0) != 0);
        return ((GoalEvaluationState)object).result;
    }

    private void storeGoal(IGoal iGoal, IGoal.State state, Object object, IGoalEvaluator iGoalEvaluator) {
        GoalEvaluationState goalEvaluationState = new GoalEvaluationState();
        goalEvaluationState.result = object;
        goalEvaluationState.state = state;
        goalEvaluationState.creator = iGoalEvaluator;
        this.goalStates.put(iGoal, goalEvaluationState);
        this.statisticsListener.goalStateChanged(iGoal, state, null);
    }

    private void reset() {
        this.workingQueue.clear();
        this.goalStates.clear();
        this.evaluatorStates.clear();
    }

    class DefaultEvaluatorStatisticsListener
    implements IEvaluationStatisticsListener {
        DefaultEvaluatorStatisticsListener() {
        }

        public void evaluationStarted(IGoal iGoal) {
        }

        public void evaluatorInitialized(IGoalEvaluator iGoalEvaluator, IGoal[] iGoalArray, long l) {
        }

        public void evaluatorProducedResult(IGoalEvaluator iGoalEvaluator, Object object, long l) {
        }

        public void evaluatorReceivedResult(IGoalEvaluator iGoalEvaluator, IGoal iGoal, IGoal[] iGoalArray, long l) {
        }

        public void goalEvaluatorAssigned(IGoal iGoal, IGoalEvaluator iGoalEvaluator) {
        }

        public void goalStateChanged(IGoal iGoal, IGoal.State state, IGoal.State state2) {
        }
    }

    class EvaluatorState {
        public long timeCreated;
        public int totalSubgoals;
        public int successfulSubgoals;
        public int subgoalsLeft;
        public List<IGoal> subgoals = new ArrayList<IGoal>();

        public EvaluatorState(int n) {
            this.subgoalsLeft = n;
            this.timeCreated = System.currentTimeMillis();
            this.totalSubgoals = n;
        }
    }

    class GoalEvaluationState {
        public IGoalEvaluator creator;
        public IGoal.State state;
        public Object result;

        GoalEvaluationState() {
        }
    }

    class WorkingPair {
        IGoal goal;
        IGoalEvaluator creator;

        public WorkingPair(IGoal iGoal, IGoalEvaluator iGoalEvaluator) {
            this.goal = iGoal;
            this.creator = iGoalEvaluator;
        }
    }
}

