/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.php.internal.core.PHPCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketMap<K, V> {
    private Map<K, Set<V>> map;
    private Set<V> defaultSet = new HashSet<V>(1);

    public BucketMap() {
        this.map = new HashMap<K, Set<V>>();
    }

    public BucketMap(Set<V> set) {
        this();
        this.defaultSet = set;
    }

    public BucketMap(int n) {
        this.map = new HashMap<K, Set<V>>(n);
    }

    public void add(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = this.createSet();
            this.map.put(k, set);
        }
        set.add(v);
    }

    private Set<V> createSet() {
        if (this.defaultSet instanceof Cloneable) {
            try {
                Method method = this.defaultSet.getClass().getMethod("clone", new Class[]{null});
                return (Set)method.invoke(this.defaultSet, new Object[0]);
            }
            catch (Exception exception) {}
        }
        try {
            return (Set)this.defaultSet.getClass().newInstance();
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return new HashSet(1);
        }
    }

    public void addAll(K k, Collection<V> collection) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            set = this.createSet();
            this.map.put(k, set);
        }
        set.addAll(collection);
    }

    public void merge(BucketMap<K, V> bucketMap) {
        for (K k : bucketMap.getKeys()) {
            this.addAll(k, bucketMap.getSet(k));
        }
    }

    public boolean contains(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return false;
        }
        return set.contains(v);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public Set<V> get(K k) {
        Set<V> set = this.getSet(k);
        if (set == null) {
            return this.createSet();
        }
        return set;
    }

    public Set<V> getSet(Object object) {
        return this.map.get(object);
    }

    public Set<V> getAll() {
        Set<V> set = this.createSet();
        for (Set<V> set2 : this.map.values()) {
            for (V v : set2) {
                set.add(v);
            }
        }
        return set;
    }

    public boolean remove(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return false;
        }
        boolean bl = set.remove(v);
        if (set.size() == 0) {
            this.map.remove(k);
        }
        return bl;
    }

    public Collection<V> removeAll(K k) {
        if (this.map.remove(k) != null) {
            return this.map.remove(k);
        }
        return this.createSet();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> getKeys() {
        return this.map.keySet();
    }
}

