/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup.containers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPDirectorySourceContainer;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPExternalArchiveSourceContainer;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPVariableSourceContainer;

public class PHPCompositeSourceContainer
extends CompositeSourceContainer {
    private IProject project;

    public PHPCompositeSourceContainer(IProject iProject, ILaunchConfiguration iLaunchConfiguration) {
        this.project = iProject;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        IIncludePathEntry[] iIncludePathEntryArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ProjectSourceContainer projectSourceContainer = new ProjectSourceContainer(this.project, false);
        arrayList.add(projectSourceContainer);
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)this.project);
        if (pHPProjectOptions != null && (iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath()) != null) {
            IIncludePathEntry[] iIncludePathEntryArray2 = iIncludePathEntryArray;
            int n = iIncludePathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                IPath iPath;
                IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray2[n2];
                if (iIncludePathEntry.getEntryKind() == 1) {
                    iPath = iIncludePathEntry.getPath();
                    file = new File(iPath.toOSString());
                    if (iIncludePathEntry.getContentKind() == 2) {
                        arrayList.add((Object)new PHPExternalArchiveSourceContainer(file.getAbsolutePath(), false, this.project));
                    } else {
                        arrayList.add((Object)new PHPDirectorySourceContainer(file, false, this.project));
                    }
                } else if (iIncludePathEntry.getEntryKind() == 2) {
                    iPath = iIncludePathEntry.getResource();
                    if (iPath instanceof IProject) {
                        file = (IProject)iIncludePathEntry.getResource();
                        arrayList.add(new ProjectSourceContainer((IProject)file, false));
                    }
                } else if (iIncludePathEntry.getEntryKind() == 4) {
                    iPath = iIncludePathEntry.getPath();
                    arrayList.add((Object)new PHPVariableSourceContainer(iPath, this.project));
                }
                ++n2;
            }
        }
        iIncludePathEntryArray = new ISourceContainer[arrayList.size()];
        arrayList.toArray(iIncludePathEntryArray);
        return iIncludePathEntryArray;
    }

    public Object[] findSourceElements(String string) throws CoreException {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        if (iResource != null) {
            return new Object[]{iResource};
        }
        Object[] objectArray = super.findSourceElements(string);
        return objectArray;
    }

    public String getName() {
        return "PHPComposite";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

