/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugMessagesRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugMessages";
    private static final String MESSAGE_TAG = "message";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private static final String OVERRIDES_ATTRIBUTE = "overridesId";
    private IntHashtable messagesHash = new IntHashtable(50);
    private Dictionary<String, Integer> messagesTypes = new Hashtable<String, Integer>();
    private IntHashtable handlers = new IntHashtable();
    private static DebugMessagesRegistry instance = null;

    private DebugMessagesRegistry() {
        String string;
        IConfigurationElement iConfigurationElement;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        HashMap<String, IConfigurationElement> hashMap = new HashMap<String, IConfigurationElement>();
        Object[] objectArray = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            iConfigurationElement = objectArray[n2];
            if (MESSAGE_TAG.equals(iConfigurationElement.getName())) {
                String string2;
                string = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, iConfigurationElement);
                }
                if ((string2 = iConfigurationElement.getAttribute(OVERRIDES_ATTRIBUTE)) != null) {
                    hashMap.put(string2, null);
                }
            }
            ++n2;
        }
        iConfigurationElement = hashMap.values();
        iConfigurationElement.remove(null);
        for (IConfigurationElement iConfigurationElement2 : iConfigurationElement) {
            objectArray = new IDebugMessage[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.core.phpDebugMessages", (IDebugMessage[])objectArray, iConfigurationElement2){
                private final /* synthetic */ IDebugMessage[] val$messages;
                private final /* synthetic */ IConfigurationElement val$element;
                {
                    this.val$messages = iDebugMessageArray;
                    this.val$element = iConfigurationElement;
                    super(string);
                }

                public void run() throws Exception {
                    this.val$messages[0] = (IDebugMessage)this.val$element.createExecutableExtension(DebugMessagesRegistry.CLASS_ATTRIBUTE);
                }
            });
            if (objectArray[0] == null || this.messagesHash.containsKey(objectArray[0].getType())) continue;
            this.messagesHash.put(objectArray[0].getType(), (Object)objectArray[0]);
            this.messagesTypes.put(iConfigurationElement2.getAttribute(ID_ATTRIBUTE), new Integer(objectArray[0].getType()));
            string = iConfigurationElement2.getAttribute(HANDLER_ATTRIBUTE);
            if (string == null || this.handlers.containsKey(objectArray[0].getType())) continue;
            this.handlers.put(objectArray[0].getType(), (Object)new DebugMessageHandlerFactory(iConfigurationElement2));
        }
    }

    private IntHashtable getMessages() {
        return this.messagesHash;
    }

    private Dictionary<String, Integer> getMessagesTypes() {
        return this.messagesTypes;
    }

    private IntHashtable getHandlers() {
        return this.handlers;
    }

    private static DebugMessagesRegistry getInstance() {
        if (instance == null) {
            instance = new DebugMessagesRegistry();
        }
        return instance;
    }

    public static IDebugMessage getMessage(int n) throws Exception {
        IntHashtable intHashtable = DebugMessagesRegistry.getInstance().getMessages();
        if (intHashtable.containsKey(n)) {
            return (IDebugMessage)intHashtable.get(n).getClass().newInstance();
        }
        throw new Exception("Can't find message for ID = " + n + " in Debug messages registry!");
    }

    public static IDebugMessage getMessage(String string) throws Exception {
        return (IDebugMessage)DebugMessagesRegistry.getInstance().getMessages().get(DebugMessagesRegistry.getInstance().getMessagesTypes().get(string).intValue()).getClass().newInstance();
    }

    public static IDebugMessageHandler getHandler(IDebugMessage iDebugMessage) {
        DebugMessageHandlerFactory debugMessageHandlerFactory = (DebugMessageHandlerFactory)DebugMessagesRegistry.getInstance().getHandlers().get(iDebugMessage.getType());
        if (debugMessageHandlerFactory != null) {
            return debugMessageHandlerFactory.createHandler();
        }
        return null;
    }

    class DebugMessageHandlerFactory {
        IConfigurationElement element;

        public DebugMessageHandlerFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IDebugMessageHandler createHandler() {
            final IDebugMessageHandler[] iDebugMessageHandlerArray = new IDebugMessageHandler[1];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable("Error creation handler for extension-point org.eclipse.php.internal.debug.core.phpDebugMessages"){

                public void run() throws Exception {
                    iDebugMessageHandlerArray[0] = (IDebugMessageHandler)DebugMessageHandlerFactory.this.element.createExecutableExtension(DebugMessagesRegistry.HANDLER_ATTRIBUTE);
                }
            });
            return iDebugMessageHandlerArray[0];
        }
    }
}

