/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;

public class ExpressionsValueDeserializer {
    private String fEncoding;

    public ExpressionsValueDeserializer(String string) {
        this.fEncoding = string;
    }

    public ExpressionValue deserializer(Expression expression, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{78};
        }
        return this.build(expression, new VariableReader(byArray));
    }

    private String getText(byte[] byArray) {
        try {
            return new String(byArray, this.fEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    private ExpressionValue build(Expression expression, VariableReader variableReader) {
        char c = variableReader.readType();
        switch (c) {
            case 'i': {
                return this.buildIntType(variableReader);
            }
            case 'd': {
                return this.buildDoubleType(variableReader);
            }
            case 's': {
                return this.buildSringType(variableReader);
            }
            case 'b': {
                return this.buildBooleanType(variableReader);
            }
            case 'r': {
                return this.buildResourceType(variableReader);
            }
            case 'a': {
                return this.buildArrayType(expression, variableReader);
            }
            case 'O': {
                return this.buildObjectType(expression, variableReader);
            }
        }
        return ExpressionValue.NULL_VALUE;
    }

    private ExpressionValue buildIntType(VariableReader variableReader) {
        String string = variableReader.readToken();
        String string2 = "(int) " + string;
        return new ExpressionValue(ExpressionValue.INT_TYPE, string, string2, null);
    }

    private ExpressionValue buildDoubleType(VariableReader variableReader) {
        String string = variableReader.readToken();
        String string2 = "(double) " + string;
        return new ExpressionValue(ExpressionValue.DOUBLE_TYPE, string, string2, null);
    }

    private ExpressionValue buildSringType(VariableReader variableReader) {
        String string = variableReader.readString();
        String string2 = "(string:" + string.length() + ") " + string.replaceAll("\\\\", "\\\\\\\\");
        return new ExpressionValue(ExpressionValue.STRING_TYPE, string, string2, null);
    }

    private ExpressionValue buildBooleanType(VariableReader variableReader) {
        String string = variableReader.readToken();
        String string2 = "(boolean) " + (string.equals("0") ? "false" : "true");
        return new ExpressionValue(ExpressionValue.BOOLEAN_TYPE, string, string2, null);
    }

    private ExpressionValue buildResourceType(VariableReader variableReader) {
        int n = variableReader.readInt();
        variableReader.readInt();
        String string = variableReader.readToken();
        String string2 = "resource (" + n + ") of type (" + string + ')';
        return new ExpressionValue(ExpressionValue.RESOURCE_TYPE, string, string2, null);
    }

    private ExpressionValue buildArrayType(Expression expression, VariableReader variableReader) {
        int n;
        int n2 = n = variableReader.readInt();
        if (variableReader.isLastEnd()) {
            n = 0;
        }
        Expression[] expressionArray = new Expression[n];
        int n3 = 0;
        while (n3 < n) {
            char c = variableReader.readType();
            String string = c == 'i' ? Integer.toString(variableReader.readInt()) : variableReader.readString();
            expressionArray[n3] = expression == null ? this.createDefaultVariable(string) : expression.createChildExpression(string, String.valueOf('[') + string + ']');
            expressionArray[n3].setValue(this.build(expression, variableReader));
            ++n3;
        }
        return new ExpressionValue(ExpressionValue.ARRAY_TYPE, "Array", "Array [" + n2 + ']', expressionArray);
    }

    private ExpressionValue buildObjectType(Expression expression, VariableReader variableReader) {
        String string = variableReader.readString();
        int n = variableReader.readInt();
        if (variableReader.isLastEnd()) {
            n = 0;
        }
        Expression[] expressionArray = new Expression[n];
        int n2 = 0;
        while (n2 < n) {
            char c = variableReader.readType();
            String string2 = c == 'i' ? Integer.toString(variableReader.readInt()) : variableReader.readString();
            expressionArray[n2] = expression == null ? this.createDefaultVariable(string2) : expression.createChildExpression(string2, "->" + string2);
            expressionArray[n2].setValue(this.build(expression, variableReader));
            ++n2;
        }
        String string3 = "Object of: " + string;
        return new ExpressionValue(ExpressionValue.OBJECT_TYPE, string, string3, expressionArray);
    }

    private Expression createDefaultVariable(String string) {
        return new DefaultExpression(String.valueOf('$') + string);
    }

    private class VariableReader
    extends ByteArrayInputStream {
        private VariableReader(byte[] byArray) {
            super(byArray);
        }

        private char readType() {
            int n;
            char c;
            do {
                if ((n = super.read()) != -1) continue;
                return ' ';
            } while ((c = (char)n) == ';' || c == ':' || c == '{' || c == '}');
            return c;
        }

        private String readToken() {
            char c;
            StringBuffer stringBuffer = new StringBuffer(6);
            while ((c = (char)super.read()) == ';' || c == ':') {
            }
            while (c != ';' && c != ':') {
                stringBuffer.append(c);
                c = (char)super.read();
            }
            return stringBuffer.toString();
        }

        private String readString() {
            int n = this.readInt();
            while ((char)super.read() != '\"') {
            }
            byte[] byArray = new byte[n];
            this.read(byArray, 0, n);
            super.read();
            return ExpressionsValueDeserializer.this.getText(byArray);
        }

        public int readInt() {
            char c;
            int n = 0;
            boolean bl = false;
            do {
                if ((c = (char)super.read()) != '-') continue;
                bl = true;
            } while (!Character.isDigit(c));
            do {
                n *= 10;
                n += Character.getNumericValue(c);
                this.mark(1);
            } while (Character.isDigit(c = (char)super.read()));
            if (bl) {
                n *= -1;
            }
            return n;
        }

        private boolean isLastEnd() {
            this.reset();
            char c = (char)super.read();
            return c == ';';
        }
    }
}

