/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPstack;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;
import org.eclipse.php.internal.debug.core.zend.model.ResolveBlackList;

public class ContextManager {
    private PHPDebugTarget fTarget;
    private IRemoteDebugger fDebugger;
    private StackLayer[] fPreviousLayers;
    private IStackFrame[] fPreviousFrames = null;
    private Map<String, Expression[]> fStackVariables;
    private Map<String, String> fResolvedStackLayersMap;
    private int fSuspendCount;
    private IVariable[] fVariables;

    public ContextManager(PHPDebugTarget pHPDebugTarget, IRemoteDebugger iRemoteDebugger) {
        this.fTarget = pHPDebugTarget;
        this.fSuspendCount = pHPDebugTarget.getSuspendCount();
        this.fDebugger = iRemoteDebugger;
        this.fStackVariables = new HashMap<String, Expression[]>();
        this.fResolvedStackLayersMap = new HashMap<String, String>();
    }

    public void cacheResolvedStackLayers(String string, String string2) {
        if (!this.fResolvedStackLayersMap.containsKey(string)) {
            this.fResolvedStackLayersMap.put(string, string2);
        }
    }

    public String getCachedResolvedStackLayer(String string) {
        if (this.fResolvedStackLayersMap.containsKey(string)) {
            return this.fResolvedStackLayersMap.get(string);
        }
        return "";
    }

    public void addToResolveBlacklist(VirtualPath virtualPath, ResolveBlackList.Type type) {
        ResolveBlackList.getInstance().add(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), virtualPath, type);
    }

    public boolean isResolveBlacklisted(String string) {
        return ResolveBlackList.getInstance().containsEntry(this.fDebugger.getDebugHandler().getDebugTarget().getLaunch(), string);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        PHPstack pHPstack = this.fDebugger.getCallStack();
        PHPThread pHPThread = (PHPThread)this.fTarget.getThreads()[0];
        StackLayer[] stackLayerArray = pHPstack.getLayers();
        boolean bl = false;
        if (stackLayerArray.length == 1) {
            bl = true;
        }
        if (this.fPreviousFrames == null) {
            this.fPreviousFrames = this.createNewFrames(stackLayerArray, pHPThread);
            this.fVariables = this.createVariables(bl, false, true);
            this.createStackVariables(stackLayerArray);
            this.fSuspendCount = this.fTarget.getSuspendCount();
            return this.fPreviousFrames;
        }
        if (this.fSuspendCount == this.fTarget.getSuspendCount()) {
            return this.fPreviousFrames;
        }
        this.fSuspendCount = this.fTarget.getSuspendCount();
        boolean bl2 = this.compareLayers(stackLayerArray, this.fPreviousLayers);
        if (bl2) {
            this.fVariables = this.createVariables(bl, false, false);
            PHPStackFrame pHPStackFrame = (PHPStackFrame)this.fPreviousFrames[0];
            int n = pHPStackFrame.getIdentifier();
            String string = pHPStackFrame.getAbsoluteFileName();
            String string2 = pHPStackFrame.getSourceName();
            this.fPreviousFrames[0] = new PHPStackFrame(pHPThread, string, bl ? "" : this.fPreviousFrames[1].getName(), this.fTarget.getLastStop(), n, string2);
        } else {
            this.fPreviousFrames = this.createNewFrames(stackLayerArray, pHPThread);
            this.fVariables = this.createVariables(bl, false, true);
        }
        this.createStackVariables(stackLayerArray);
        return this.fPreviousFrames;
    }

    public IVariable[] getVariables() {
        return this.fVariables;
    }

    public Expression[] getStackVariables(PHPStackFrame pHPStackFrame) {
        String string = "";
        try {
            string = pHPStackFrame.getName();
        }
        catch (DebugException debugException) {
            Logger.logException("PHP Problem getting name from stack", debugException);
        }
        Expression[] expressionArray = new Expression[]{};
        if (!string.equals("")) {
            String string2 = String.valueOf(string) + pHPStackFrame.getAbsoluteFileName();
            expressionArray = this.fStackVariables.get(string2);
        }
        return expressionArray;
    }

    private boolean compareLayers(StackLayer[] stackLayerArray, StackLayer[] stackLayerArray2) {
        if (stackLayerArray.length != stackLayerArray2.length) {
            return false;
        }
        int n = 1;
        while (n < stackLayerArray.length) {
            if (!this.compareLayer(stackLayerArray[n], stackLayerArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean compareLayer(StackLayer stackLayer, StackLayer stackLayer2) {
        return stackLayer.getCallerFileName().equals(stackLayer2.getCallerFileName()) && stackLayer.getCallerFunctionName().equals(stackLayer2.getCallerFunctionName()) && stackLayer.getCallerLineNumber() == stackLayer2.getCallerLineNumber() && stackLayer.getCalledFileName().equals(stackLayer2.getCalledFileName()) && stackLayer.getCalledFunctionName().equals(stackLayer2.getCalledFunctionName()) && stackLayer.getCalledLineNumber() == stackLayer2.getCalledLineNumber();
    }

    private IStackFrame[] createNewFrames(StackLayer[] stackLayerArray, PHPThread pHPThread) throws DebugException {
        RemoteDebugger remoteDebugger = (RemoteDebugger)this.fDebugger;
        String string = remoteDebugger.getCurrentWorkingDirectory();
        String string2 = null;
        IStackFrame[] iStackFrameArray = new IStackFrame[(stackLayerArray.length - 1) * 2 + 1];
        int n = (stackLayerArray.length - 1) * 2 + 1;
        int n2 = 1;
        while (n2 < stackLayerArray.length) {
            String string3 = stackLayerArray[n2].getCallerFileName();
            String string4 = remoteDebugger.convertToLocalFilename(string3, string, n < iStackFrameArray.length ? ((PHPStackFrame)iStackFrameArray[n]).getSourceName() : null);
            if (string4 == null) {
                string4 = string3;
            }
            iStackFrameArray[n - 1] = new PHPStackFrame(pHPThread, string3, stackLayerArray[n2].getCallerFunctionName(), stackLayerArray[n2].getCallerLineNumber() + 1, n, string4);
            --n;
            string3 = stackLayerArray[n2].getCalledFileName();
            string4 = remoteDebugger.convertToLocalFilename(string3, string, string4);
            if (string4 == null) {
                string4 = string3;
            }
            iStackFrameArray[n - 1] = new PHPStackFrame(pHPThread, string3, stackLayerArray[n2].getCalledFunctionName(), stackLayerArray[n2].getCalledLineNumber() + 1, n, stackLayerArray[n2], string4);
            --n;
            if (!stackLayerArray[n2].getCalledFileName().equals(this.fTarget.getLastFileName())) {
                string2 = string4;
            }
            ++n2;
        }
        String string5 = remoteDebugger.convertToLocalFilename(this.fTarget.getLastFileName(), string, string2);
        if (string5 == null) {
            string5 = this.fTarget.getLastFileName();
        }
        iStackFrameArray[0] = new PHPStackFrame(pHPThread, this.fTarget.getLastFileName(), stackLayerArray.length == 1 ? "" : iStackFrameArray[1].getName(), this.fTarget.getLastStop(), n, string5);
        this.fPreviousLayers = stackLayerArray;
        return iStackFrameArray;
    }

    private void createStackVariables(StackLayer[] stackLayerArray) {
        this.fStackVariables.clear();
        StackLayer[] stackLayerArray2 = stackLayerArray;
        int n = stackLayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackLayer stackLayer = stackLayerArray2[n2];
            Expression[] expressionArray = stackLayer.getVariables();
            if (expressionArray.length != 0) {
                String string = String.valueOf(stackLayer.getCalledFunctionName()) + stackLayer.getCalledFileName();
                this.fStackVariables.put(string, expressionArray);
            }
            ++n2;
        }
    }

    private IVariable[] createVariables(boolean bl, boolean bl2, boolean bl3) {
        IVariable[] iVariableArray;
        DefaultExpressionsManager defaultExpressionsManager = this.fTarget.getExpressionManager();
        if (defaultExpressionsManager == null) {
            return new IVariable[0];
        }
        if (bl3) {
            defaultExpressionsManager.clear();
        }
        Expression[] expressionArray = defaultExpressionsManager.getLocalVariables(1);
        Expression[] expressionArray2 = defaultExpressionsManager.getGlobalVariables(1);
        if (bl) {
            iVariableArray = new PHPVariable[expressionArray.length];
            int n = 0;
            while (n < expressionArray.length) {
                iVariableArray[n] = new PHPVariable(this.fTarget, expressionArray[n]);
                ++n;
            }
        } else {
            iVariableArray = new PHPVariable[expressionArray.length + 1];
            int n = 0;
            while (n < expressionArray.length) {
                iVariableArray[n + 1] = new PHPVariable(this.fTarget, expressionArray[n]);
                ++n;
            }
            String string = "$GLOBALS";
            DefaultExpression defaultExpression = new DefaultExpression(string);
            String string2 = "Array";
            String string3 = String.valueOf(string2) + " [" + new Integer(expressionArray2.length).toString() + "]";
            ExpressionValue expressionValue = new ExpressionValue(5, string2, string3, expressionArray2);
            defaultExpression.setValue(expressionValue);
            iVariableArray[0] = new PHPVariable(this.fTarget, defaultExpression, true);
        }
        return iVariableArray;
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.fDebugger;
    }
}

