/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveBlackList
implements ILaunchesListener {
    private static Map<ILaunch, Map<VirtualPath, Type>> blackListMap;
    private static ResolveBlackList instance;

    static {
        instance = new ResolveBlackList();
    }

    private ResolveBlackList() {
        blackListMap = new HashMap<ILaunch, Map<VirtualPath, Type>>();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public static ResolveBlackList getInstance() {
        return instance;
    }

    private static Map<VirtualPath, Type> getByLaunch(ILaunch iLaunch) {
        if (!blackListMap.containsKey(iLaunch)) {
            blackListMap.put(iLaunch, new HashMap());
        }
        return blackListMap.get(iLaunch);
    }

    public void add(ILaunch iLaunch, VirtualPath virtualPath, Type type) {
        ResolveBlackList.getByLaunch(iLaunch).put(virtualPath, type);
    }

    public boolean containsEntry(ILaunch iLaunch, String string) {
        if (!VirtualPath.isAbsolute(string)) {
            return false;
        }
        Map<VirtualPath, Type> map = ResolveBlackList.getByLaunch(iLaunch);
        for (VirtualPath virtualPath : map.keySet()) {
            VirtualPath virtualPath2 = new VirtualPath(string);
            Type type = map.get(virtualPath);
            if (type == Type.FILE) {
                if (!virtualPath.equals(virtualPath2)) continue;
                return true;
            }
            if (type == Type.FOLDER) {
                virtualPath2.removeLastSegment();
                if (!virtualPath.equals(virtualPath2)) continue;
                return true;
            }
            if (type != Type.RECURSIVE || !virtualPath.isPrefixOf(virtualPath2)) continue;
            return true;
        }
        return false;
    }

    public void launchesAdded(ILaunch[] iLaunchArray) {
    }

    public void launchesChanged(ILaunch[] iLaunchArray) {
    }

    public void launchesRemoved(ILaunch[] iLaunchArray) {
        ILaunch[] iLaunchArray2 = iLaunchArray;
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch iLaunch = iLaunchArray2[n2];
            blackListMap.remove(iLaunch);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        FOLDER,
        RECURSIVE;

    }
}

