/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.hovers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPDebugTextHover
extends AbstractPHPTextHover {
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        PHPDebugTarget pHPDebugTarget;
        if (iTextViewer == null || iTextViewer.getDocument() == null) {
            return null;
        }
        if (iTextViewer instanceof PHPStructuredTextViewer) {
            this.setEditorPart((IEditorPart)((PHPStructuredTextViewer)iTextViewer).getTextEditor());
        }
        if ((pHPDebugTarget = this.getDebugTarget()) == null) {
            return null;
        }
        int n = iRegion.getOffset();
        IStructuredDocumentRegion iStructuredDocumentRegion = ((IStructuredDocument)iTextViewer.getDocument()).getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion = null;
        if (iStructuredDocumentRegion != null) {
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        }
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
        if (iTextRegion instanceof ITextRegionContainer) {
            iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
            iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            IPhpScriptRegion iPhpScriptRegion = (IPhpScriptRegion)iTextRegion;
            try {
                iTextRegion = iPhpScriptRegion.getPhpToken(n - iStructuredDocumentRegion2.getStartOffset() - iTextRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                iTextRegion = null;
            }
            if (iTextRegion != null) {
                Object object;
                Object object2;
                int n2 = 0;
                int n3 = 0;
                String string = iTextRegion.getType();
                if (string == "PHP_VARIABLE") {
                    n2 = iRegion.getOffset();
                    n3 = iRegion.getLength();
                } else if (string == "PHP_STRING") {
                    try {
                        String string2;
                        object2 = iPhpScriptRegion.getPhpToken(iTextRegion.getEnd());
                        object = iPhpScriptRegion.getPhpToken(iTextRegion.getStart() - 1);
                        if (object.getType() == "PHP_OBJECT_OPERATOR" && (object = (Object)iPhpScriptRegion.getPhpToken(object.getStart() - 1)).getType() == "PHP_VARIABLE" && !"(".equals(string2 = iTextViewer.getDocument().get(iPhpScriptRegion.getStart() + object2.getStart(), object2.getLength()))) {
                            n2 = iPhpScriptRegion.getStart() + object.getStart();
                            n3 = iTextRegion.getEnd() - object.getStart();
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (n3 > 0) {
                    object2 = null;
                    try {
                        object = this.getVariableRange(iTextViewer, n2, n3);
                        object2 = iTextViewer.getDocument().get(object[0], object[1]);
                        object2 = "<B>" + (String)object2 + " = </B>" + this.getValue(pHPDebugTarget, (String)object2);
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.logException((String)"Error retrieving the value\n", (Throwable)badLocationException);
                    }
                    return object2;
                }
            }
        }
        return null;
    }

    protected int[] getVariableRange(final ITextViewer iTextViewer, final int n, final int n2) {
        final int[] nArray = new int[]{n, n2};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TextSelection textSelection = (TextSelection)iTextViewer.getSelectionProvider().getSelection();
                if (textSelection.isEmpty()) {
                    return;
                }
                int n4 = textSelection.getOffset();
                int n22 = n4 + textSelection.getLength();
                int n3 = n + n2;
                if (n >= n4 && n < n22 && n3 <= n22) {
                    nArray[0] = textSelection.getOffset();
                    nArray[1] = textSelection.getLength();
                }
            }
        });
        return nArray;
    }

    protected String getValue(PHPDebugTarget pHPDebugTarget, String string) {
        DefaultExpressionsManager defaultExpressionsManager = pHPDebugTarget.getExpressionManager();
        Expression expression = defaultExpressionsManager.buildExpression(string);
        pHPDebugTarget.getExpressionManager().getExpressionValue(expression, 1);
        defaultExpressionsManager.update(expression, 1);
        String string2 = expression.getValue().getValueAsString();
        if (string2 != null && string2.length() == 0) {
            string2 = "Empty";
            return string2;
        }
        if (string2 != null) {
            this.tab.matcher(string2).replaceAll("    ");
        }
        return string2;
    }

    protected PHPDebugTarget getDebugTarget() {
        IAdaptable iAdaptable = DebugUITools.getDebugContext();
        if (iAdaptable instanceof PHPStackFrame) {
            PHPStackFrame pHPStackFrame = (PHPStackFrame)iAdaptable;
            IEditorInput iEditorInput = this.getEditorPart().getEditorInput();
            if (iEditorInput instanceof FileEditorInput) {
                FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorPart().getEditorInput();
                String string = pHPStackFrame.getSourceName();
                String string2 = fileEditorInput.getFile().getProjectRelativePath().toString();
                if (string != null && string.endsWith(String.valueOf('/') + string2) || string.equals(string2)) {
                    PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)pHPStackFrame.getDebugTarget();
                    return pHPDebugTarget;
                }
            } else {
                PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)pHPStackFrame.getDebugTarget();
                return pHPDebugTarget;
            }
        }
        return null;
    }
}

