/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PHPExeCompositeFragment
extends CompositeFragment
implements IPHPExeCompositeFragment {
    private PHPexeItem[] existingItems;
    private StringDialogField fPHPexeName;
    private StringButtonDialogField fPHPExePath;
    private StringButtonDialogField fPHPIni;
    private List<String> debuggersIds;
    private Label fDebuggersLabel;
    private Combo fDebuggers;
    private String initialName;

    public PHPExeCompositeFragment(Composite composite, IControlHandler iControlHandler, boolean bl) {
        super(composite, iControlHandler, bl);
        this.setDescription("Specify the PHP Executable Information");
        this.setDisplayName("PHP Executable");
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_PHPEXE"));
        this.debuggersIds = new LinkedList<String>(PHPDebuggersRegistry.getDebuggersIds());
        this.createControl();
    }

    public void setExistingItems(PHPexeItem[] pHPexeItemArray) {
        this.existingItems = pHPexeItemArray;
    }

    public void setData(Object object) {
        if (object != null && !(object instanceof PHPexeItem)) {
            throw new IllegalArgumentException("Data must be instance of PHPExeItem");
        }
        super.setData(object);
        this.init();
    }

    public PHPexeItem getPHPExeItem() {
        return (PHPexeItem)super.getData();
    }

    protected String getPHPexeName() {
        return this.fPHPexeName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fPHPExePath.getText());
    }

    protected File getIniLocation() {
        return new File(this.fPHPIni.getText());
    }

    protected void createControl() {
        PixelConverter pixelConverter = new PixelConverter((Control)this);
        GridLayout gridLayout = new GridLayout(1, true);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fPHPexeName = new StringDialogField();
        this.fPHPexeName.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpName);
        this.fPHPExePath = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField dialogField) {
                FileDialog fileDialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                fileDialog.setFilterPath(PHPExeCompositeFragment.this.fPHPExePath.getText());
                fileDialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPRootDialog_message);
                String string = fileDialog.open();
                if (string != null) {
                    PHPExeCompositeFragment.this.fPHPExePath.setText(string);
                }
            }
        });
        this.fPHPExePath.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpHome);
        this.fPHPExePath.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPIni = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField dialogField) {
                FileDialog fileDialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                fileDialog.setFilterPath(PHPExeCompositeFragment.this.fPHPIni.getText());
                fileDialog.setFilterExtensions(new String[]{"*.ini", "*.*"});
                fileDialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPIniDialog_message);
                String string = fileDialog.open();
                if (string != null) {
                    PHPExeCompositeFragment.this.fPHPIni.setText(string);
                }
            }
        });
        this.fPHPIni.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpIni);
        this.fPHPIni.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPexeName.doFillIntoGrid(composite, 3);
        this.fPHPExePath.doFillIntoGrid(composite, 3);
        ((GridData)this.fPHPExePath.getTextControl((Composite)composite).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fPHPIni.doFillIntoGrid(composite, 3);
        ((GridData)this.fPHPIni.getTextControl((Composite)composite).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fDebuggersLabel = new Label(composite, 16448);
        this.fDebuggersLabel.setFont(composite.getFont());
        this.fDebuggersLabel.setText(PHPDebugUIMessages.addPHPexeDialog_phpDebugger);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.fDebuggersLabel.setLayoutData((Object)gridData);
        this.fDebuggers = new Combo(composite, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.fDebuggers.setLayoutData((Object)gridData);
        int n = 0;
        while (n < this.debuggersIds.size()) {
            String string = this.debuggersIds.get(n);
            String string2 = PHPDebuggersRegistry.getDebuggerName((String)string);
            this.fDebuggers.add(string2, n);
            ++n;
        }
        this.init();
        this.createFieldListeners();
        this.validate();
        Dialog.applyDialogFont((Control)this);
    }

    protected void createFieldListeners() {
        this.fPHPexeName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                PHPExeCompositeFragment.this.validate();
            }
        });
        this.fPHPExePath.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                PHPExeCompositeFragment.this.validate();
            }
        });
        this.fPHPIni.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                PHPExeCompositeFragment.this.validate();
            }
        });
        this.fDebuggers.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                PHPExeCompositeFragment.this.validate();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPExeCompositeFragment.this.validate();
            }
        });
    }

    protected void init() {
        PHPexeItem pHPexeItem = this.getPHPExeItem();
        if (pHPexeItem == null || pHPexeItem.getName() == null) {
            this.fPHPexeName.setText("");
            this.fPHPExePath.setText("");
            this.fPHPIni.setText("");
            String string = PHPDebuggersRegistry.getDefaultDebuggerId();
            if (string != null) {
                int n = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName((String)string));
                this.fDebuggers.select(n);
            } else if (this.fDebuggers.getItemCount() > 0) {
                this.fDebuggers.select(0);
            } else {
                this.hideDebuggersCombo();
            }
            this.setTitle("Add PHP Executable");
        } else {
            this.initialName = pHPexeItem.getName();
            this.fPHPexeName.setTextWithoutUpdate(pHPexeItem.getName());
            this.fPHPexeName.setEnabled(pHPexeItem.isEditable());
            this.fPHPExePath.setTextWithoutUpdate(pHPexeItem.getExecutable().getAbsolutePath());
            this.fPHPExePath.setEnabled(pHPexeItem.isEditable());
            if (pHPexeItem.getINILocation() != null) {
                this.fPHPIni.setTextWithoutUpdate(pHPexeItem.getINILocation().toString());
            }
            this.fPHPIni.setEnabled(pHPexeItem.isEditable());
            String string = pHPexeItem.getDebuggerID();
            this.fDebuggers.setEnabled(pHPexeItem.isEditable());
            this.fDebuggersLabel.setEnabled(pHPexeItem.isEditable());
            int n = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName((String)string));
            if (n > -1) {
                this.fDebuggers.select(n);
            } else if (this.fDebuggers.getItemCount() > 0) {
                this.fDebuggers.select(0);
            } else {
                this.hideDebuggersCombo();
            }
            this.setTitle("Edit PHP Executable");
        }
        this.controlHandler.setTitle(this.getTitle());
        this.validate();
    }

    private void hideDebuggersCombo() {
        this.fDebuggers.setVisible(false);
        this.fDebuggersLabel.setVisible(false);
    }

    protected void validate() {
        String string;
        Object object;
        PHPexeItem pHPexeItem = this.getPHPExeItem();
        if (pHPexeItem != null && !pHPexeItem.isEditable()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_readOnlyPHPExe, 1);
            return;
        }
        String string2 = this.fPHPexeName.getText();
        if (string2 == null || string2.trim().length() == 0) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterName, 1);
            return;
        }
        if (this.existingItems != null) {
            object = this.existingItems;
            int n = this.existingItems.length;
            int n2 = 0;
            while (n2 < n) {
                string = object[n2];
                if (!string.getName().equals(this.initialName) && string.getName().equals(string2)) {
                    this.setMessage(PHPDebugUIMessages.addPHPexeDialog_duplicateName, 3);
                    return;
                }
                ++n2;
            }
        }
        if ((string = this.fPHPExePath.getText()).length() == 0) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterLocation, 1);
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_locationNotExists, 3);
            return;
        }
        if (!file.getName().toLowerCase().contains("php")) {
            this.setMessage("Selected location doesn't refer to a valid PHP executable", 3);
            return;
        }
        String string3 = this.fPHPIni.getText();
        object = null;
        if (string3.trim().length() > 0 && !((File)(object = new File(string3))).exists()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_iniLocationNotExists, 3);
            return;
        }
        pHPexeItem.setName(string2);
        pHPexeItem.setExecutable(file);
        pHPexeItem.setDebuggerID(this.debuggersIds.get(this.fDebuggers.getSelectionIndex()));
        pHPexeItem.setINILocation((File)object);
        this.setMessage(this.getDescription(), 0);
        this.controlHandler.update();
    }

    protected void setMessage(String string, int n) {
        this.controlHandler.setMessage(string, n);
        this.setComplete(n == 0);
        this.controlHandler.update();
    }

    public boolean performOk() {
        return true;
    }
}

