/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.preferences;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.osgi.framework.Bundle;

public class PHPexes {
    private static final String DEFAULT_ATTRIBUTE = "default";
    private static final String EXTENSION_POINT_NAME = "phpExe";
    private static final String LOCATION_ATTRIBUTE = "location";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DEBUGGER_ID_ATTRIBUTE = "debuggerID";
    private static final String PHPEXE_TAG = "phpExe";
    public static final String SEPARATOR = ";";
    private static final String VERSION_ATTRIBUTE = "version";
    public static final String ZEND_DEBUGGER_ID = "org.eclipse.php.debug.core.zendDebugger";
    private static Object lock = new Object();
    private static PHPexes instance;
    private HashMap<String, HashMap<String, PHPexeItem>> items = new HashMap();
    private HashMap<String, PHPexeItem> defaultItems = new HashMap();
    private final LinkedList<IPHPExesListener> listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPexes getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new PHPexes();
            }
            return instance;
        }
    }

    private PHPexes() {
        this.load();
    }

    public static void changePermissions(File file) {
        LocalFile localFile;
        IFileInfo iFileInfo;
        if (!Platform.getOS().equals("win32") && !(iFileInfo = (localFile = new LocalFile(file)).fetchInfo()).getAttribute(4)) {
            iFileInfo.setAttribute(4, true);
            try {
                localFile.putInfo(iFileInfo, 1024, null);
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
        }
    }

    public void addItem(PHPexeItem pHPexeItem) {
        String string = pHPexeItem.getDebuggerID();
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.items.put(string, hashMap);
        }
        if (hashMap.isEmpty()) {
            this.setDefaultItem(pHPexeItem);
        }
        hashMap.put(pHPexeItem.getName(), pHPexeItem);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PHPExesEvent pHPExesEvent = new PHPExesEvent(pHPexeItem);
            ((IPHPExesListener)iterator.next()).phpExeAdded(pHPExesEvent);
        }
    }

    public PHPexeItem getDefaultItem(String string) {
        return this.defaultItems.get(string);
    }

    public boolean hasItems(String string) {
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        return hashMap != null && hashMap.size() > 0;
    }

    public boolean hasItems() {
        return this.getAllItems().length > 0;
    }

    public PHPexeItem[] getEditableItems() {
        Set<String> set = PHPDebuggersRegistry.getDebuggersIds();
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        for (String string : set) {
            HashMap<String, PHPexeItem> hashMap = this.items.get(string);
            if (hashMap == null) continue;
            Set<String> set2 = hashMap.keySet();
            for (String string2 : set2) {
                PHPexeItem pHPexeItem = hashMap.get(string2);
                if (!pHPexeItem.isEditable()) continue;
                arrayList.add(pHPexeItem);
            }
        }
        return arrayList.toArray(new PHPexeItem[arrayList.size()]);
    }

    public PHPexeItem getItem(String string, String string2) {
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string2);
    }

    public PHPexeItem getItemForFile(String string, String string2) {
        Set<String> set = PHPDebuggersRegistry.getDebuggersIds();
        for (String string3 : set) {
            HashMap<String, PHPexeItem> hashMap = this.items.get(string3);
            if (hashMap == null) continue;
            Set<String> set2 = hashMap.keySet();
            for (String string4 : set2) {
                PHPexeItem pHPexeItem = hashMap.get(string4);
                boolean bl = true;
                if (string2 == null) {
                    bl = pHPexeItem.getINILocation() == null;
                } else {
                    boolean bl2 = pHPexeItem.getINILocation() == null ? string2 == null || string2.equals("") : (bl = string2.equals(pHPexeItem.getINILocation().toString()));
                }
                if (!bl || !string.equals(pHPexeItem.getExecutable().toString())) continue;
                return pHPexeItem;
            }
        }
        return null;
    }

    public PHPexeItem[] getItems(String string) {
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        if (hashMap == null) {
            return null;
        }
        PHPexeItem[] pHPexeItemArray = new PHPexeItem[hashMap.size()];
        return hashMap.values().toArray(pHPexeItemArray);
    }

    public PHPexeItem[] getAllItems() {
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        Set<String> set = this.items.keySet();
        for (String string : set) {
            HashMap<String, PHPexeItem> hashMap = this.items.get(string);
            if (hashMap == null) continue;
            Collection<PHPexeItem> collection = hashMap.values();
            for (PHPexeItem pHPexeItem : collection) {
                arrayList.add(pHPexeItem);
            }
        }
        return arrayList.toArray(new PHPexeItem[arrayList.size()]);
    }

    private void load() {
        int n;
        Object object;
        String[] stringArray;
        String[] stringArray2;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.items = new HashMap();
        this.loadExtensions();
        String string = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES);
        if (string == null) {
            string = "";
        }
        String[] stringArray3 = string.length() > 0 ? string.split(SEPARATOR) : new String[]{};
        String string2 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS);
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray4 = string2.length() > 0 ? string2.split(SEPARATOR) : new String[]{};
        String string3 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_INIS);
        if (string3 == null) {
            string3 = "";
        }
        String[] stringArray5 = string3.length() > 0 ? string3.split(SEPARATOR) : new String[stringArray4.length];
        String string4 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS);
        if (string4 == null) {
            string4 = "";
        }
        String[] stringArray6 = stringArray2 = string4.length() > 0 ? string4.split(SEPARATOR) : new String[]{};
        assert (stringArray3.length == stringArray4.length);
        int n2 = 0;
        while (n2 < stringArray4.length) {
            stringArray = "null".equals(stringArray5[n2]) ? null : stringArray5[n2];
            object = new PHPexeItem(stringArray3[n2], stringArray4[n2], (String)stringArray, stringArray2[n2]);
            if (((PHPexeItem)object).getExecutable() != null && (n = (int)(WorkbenchActivityHelper.filterItem((Object)new IPluginContribution((PHPexeItem)object){
                private final /* synthetic */ PHPexeItem val$item;
                {
                    this.val$item = pHPexeItem;
                }

                public String getLocalId() {
                    return this.val$item.getDebuggerID();
                }

                public String getPluginId() {
                    return "org.eclipse.php.debug.core";
                }
            }) ? 1 : 0)) == 0) {
                this.addItem((PHPexeItem)object);
            }
            ++n2;
        }
        String string5 = preferences.getString(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULTS);
        if (string5 == null) {
            string5 = "";
        }
        String[] stringArray7 = stringArray = string5.length() > 0 ? string5.split(SEPARATOR) : new String[]{};
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            object = stringArray7[n];
            String[] stringArray8 = ((String)object).split("=");
            if (stringArray8.length == 2) {
                this.setDefaultItem(stringArray8[0], stringArray8[1]);
            }
            ++n;
        }
    }

    private void loadExtensions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "phpExe");
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("windows");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            if ("phpExe".equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(NAME_ATTRIBUTE);
                String string2 = iConfigurationElement.getAttribute(LOCATION_ATTRIBUTE);
                String string3 = iConfigurationElement.getAttribute(VERSION_ATTRIBUTE);
                String string4 = iConfigurationElement.getAttribute(DEBUGGER_ID_ATTRIBUTE);
                if (string4 == null || string4.equals("")) {
                    string4 = ZEND_DEBUGGER_ID;
                }
                boolean bl2 = "true".equalsIgnoreCase(iConfigurationElement.getAttribute(DEFAULT_ATTRIBUTE));
                if (bl) {
                    string2 = String.valueOf(string2) + ".exe";
                }
                String string5 = iConfigurationElement.getDeclaringExtension().getNamespaceIdentifier();
                final String string6 = string4;
                boolean bl3 = WorkbenchActivityHelper.filterItem((Object)new IPluginContribution(){

                    public String getLocalId() {
                        return string6;
                    }

                    public String getPluginId() {
                        return "org.eclipse.php.debug.core";
                    }
                });
                if (!bl3) {
                    URL uRL = FileLocator.find((Bundle)Platform.getBundle((String)string5), (IPath)new Path(string2), new HashMap());
                    boolean bl4 = false;
                    if (uRL != null) {
                        try {
                            uRL = FileLocator.resolve((URL)uRL);
                            String string7 = uRL.getFile();
                            File file = new File(string7);
                            if (file.exists()) {
                                PHPexeItem pHPexeItem = new PHPexeItem(string, file, null, string4, false);
                                pHPexeItem.setVersion(string3);
                                this.addItem(pHPexeItem);
                                if (bl2) {
                                    this.setDefaultItem(pHPexeItem);
                                }
                                bl4 = true;
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    if (!bl4) {
                        PHPDebugPlugin.getDefault().getLog().log((IStatus)new Status(1, PHPDebugPlugin.getID(), 1001, "PHP executable " + string2 + " not found neither in plugin " + string5 + " nor in fragments attached to it", null));
                    }
                }
            }
            ++n2;
        }
    }

    public void removeItem(PHPexeItem pHPexeItem) {
        Iterator<Object> iterator;
        String string = pHPexeItem.getDebuggerID();
        HashMap<String, PHPexeItem> hashMap = this.items.get(string);
        PHPexeItem pHPexeItem2 = null;
        if (hashMap != null) {
            pHPexeItem2 = hashMap.remove(pHPexeItem.getName());
        }
        if (pHPexeItem2 != null && pHPexeItem2.isDefault()) {
            this.defaultItems.remove(string);
            iterator = hashMap.values().iterator();
            if (iterator.hasNext()) {
                this.setDefaultItem((PHPexeItem)iterator.next());
            }
        }
        iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            PHPExesEvent pHPExesEvent = new PHPExesEvent(pHPexeItem);
            ((IPHPExesListener)iterator.next()).phpExeRemoved(pHPExesEvent);
        }
    }

    public void setDefaultItem(PHPexeItem pHPexeItem) {
        String string = pHPexeItem.getDebuggerID();
        PHPexeItem pHPexeItem2 = this.defaultItems.get(string);
        if (pHPexeItem2 == pHPexeItem) {
            return;
        }
        if (pHPexeItem2 != null) {
            pHPexeItem2.setDefault(false);
        }
        pHPexeItem.setDefault(true);
        this.defaultItems.put(string, pHPexeItem);
    }

    public void setDefaultItem(String string, String string2) {
        PHPexeItem pHPexeItem = this.getItem(string, string2);
        if (pHPexeItem != null) {
            this.setDefaultItem(pHPexeItem);
        }
    }

    public void save() {
        Object object;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        PHPexeItem[] pHPexeItemArray = this.getEditableItems();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            object = pHPexeItemArray[n];
            if (n > 0) {
                stringBuffer.append(SEPARATOR);
                stringBuffer2.append(SEPARATOR);
                stringBuffer3.append(SEPARATOR);
                stringBuffer4.append(SEPARATOR);
            }
            stringBuffer.append(((PHPexeItem)object).getExecutable().toString());
            stringBuffer2.append(((PHPexeItem)object).getINILocation() != null ? ((PHPexeItem)object).getINILocation().toString() : "null");
            stringBuffer3.append(((PHPexeItem)object).getName());
            stringBuffer4.append(((PHPexeItem)object).getDebuggerID());
            ++n;
        }
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_NAMES, stringBuffer3.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_LOCATIONS, stringBuffer.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_INIS, stringBuffer2.toString());
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEBUGGERS, stringBuffer4.toString());
        StringBuffer stringBuffer5 = new StringBuffer();
        object = this.defaultItems.values().iterator();
        while (object.hasNext()) {
            PHPexeItem pHPexeItem = (PHPexeItem)object.next();
            stringBuffer5.append(pHPexeItem.getDebuggerID());
            stringBuffer5.append('=');
            stringBuffer5.append(pHPexeItem.getName());
            if (!object.hasNext()) continue;
            stringBuffer5.append(SEPARATOR);
        }
        preferences.setValue(PHPDebugCorePreferenceNames.INSTALLED_PHP_DEFAULTS, stringBuffer5.toString());
        PHPDebugPlugin.getDefault().savePluginPreferences();
    }

    public void addPHPExesListener(IPHPExesListener iPHPExesListener) {
        this.listeners.add(iPHPExesListener);
    }

    public void removePHPExesListener(IPHPExesListener iPHPExesListener) {
        this.listeners.remove(iPHPExesListener);
    }
}

