/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBaseVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.Base64;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;

public abstract class DBGpValue
extends DBGpElement
implements IValue {
    private boolean modifiable = false;
    private IVariable[] variables = new IVariable[0];
    private DBGpBaseVariable owner;
    private String valueString = "";
    private static final String ENCODING_BASE64 = "base64";

    public DBGpValue(DBGpBaseVariable dBGpBaseVariable) {
        super(dBGpBaseVariable.getDebugTarget());
        this.owner = dBGpBaseVariable;
    }

    public DBGpValue(DBGpBaseVariable dBGpBaseVariable, Node node) {
        super(dBGpBaseVariable.getDebugTarget());
        this.owner = dBGpBaseVariable;
        this.simpleParseNode(node);
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    boolean isModifiable() {
        return this.modifiable;
    }

    void setModifiable(boolean bl) {
        this.modifiable = bl;
    }

    public abstract String getReferenceTypeName() throws DebugException;

    public String getValueString() throws DebugException {
        return this.valueString;
    }

    void setValueString(String string) {
        this.valueString = string;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }

    boolean verifyValue(String string) throws DebugException {
        return false;
    }

    public void setValue(String string) throws DebugException {
    }

    public DBGpBaseVariable getOwner() {
        return this.owner;
    }

    void simpleParseNode(Node node) {
        String string = null;
        String string2 = DBGpResponse.getAttribute(node, "encoding");
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            string = this.decodeValue(node2.getNodeValue(), string2);
        }
        this.genValueString(string);
    }

    private String decodeValue(String string, String string2) {
        String string3 = string;
        if (string2 != null && string2.equalsIgnoreCase(ENCODING_BASE64) && string != null && string.trim().length() != 0) {
            DBGpTarget dBGpTarget = (DBGpTarget)this.getDebugTarget();
            string3 = Base64.decode(string.trim(), dBGpTarget.getSessionEncoding());
        }
        return string3;
    }

    abstract void genValueString(String var1);
}

