/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.handlers.IDebugRequestHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.BlockingQueue;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationAdministrator;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationClient;
import org.eclipse.php.internal.debug.core.zend.communication.ResponseHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugMessagesRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageImpl;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.OutputNotification;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugConnectionThread
implements Runnable {
    protected static int startMessageId = new DebugSessionStartedNotification().getType();
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    protected boolean validProtocol;
    private boolean isInitialized;
    private InputMessageHandler inputMessageHandler;
    private CommunicationClient communicationClient;
    private CommunicationAdministrator administrator;
    private IDebugMessage CONNECTION_CLOSED_MSG = new DummyDebugMessage();
    protected boolean isDebugMode = System.getProperty("loggingDebug") != null;
    private IntHashtable requestsTable;
    private IntHashtable responseTable;
    private Hashtable<Integer, ResponseHandler> responseHandlers;
    private InputManager inputManager;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    private int lastRequestID = 1000;
    protected int peerResponseTimeout = 500;
    protected PHPDebugTarget debugTarget;
    private Thread theThread;
    private Map<Integer, IDebugMessageHandler> messageHandlers;

    public DebugConnectionThread(Socket socket) {
        this.socket = socket;
        this.requestsTable = new IntHashtable();
        this.responseTable = new IntHashtable();
        this.responseHandlers = new Hashtable();
        this.messageHandlers = new HashMap<Integer, IDebugMessageHandler>();
        this.theThread = new Thread(this);
        this.theThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.socket.setTcpNoDelay(true);
            DataInputStream dataInputStream = new DataInputStream(this.socket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            DataInputStream dataInputStream2 = dataInputStream;
            synchronized (dataInputStream2) {
                this.restartInputMessageHandler(dataOutputStream);
                this.restartInputManager(dataInputStream);
                this.in = dataInputStream;
                this.out = dataOutputStream;
                this.isInitialized = true;
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
    }

    public void setCommunicationClient(CommunicationClient communicationClient) {
        this.communicationClient = communicationClient;
    }

    public CommunicationClient getCommunicationClient() {
        return this.communicationClient;
    }

    public void setCommunicationAdministrator(CommunicationAdministrator communicationAdministrator) {
        this.administrator = communicationAdministrator;
    }

    public CommunicationAdministrator getCommunicationAdministrator() {
        return this.administrator;
    }

    public int getPeerResponseTimeout() {
        return this.peerResponseTimeout;
    }

    public void setPeerResponseTimeout(int n) {
        this.peerResponseTimeout = n;
    }

    private IDebugMessageHandler createMessageHandler(IDebugMessage iDebugMessage) {
        if (!this.messageHandlers.containsKey(iDebugMessage.getType())) {
            IDebugMessageHandler iDebugMessageHandler = DebugMessagesRegistry.getHandler(iDebugMessage);
            this.messageHandlers.put(iDebugMessage.getType(), iDebugMessageHandler);
        }
        return this.messageHandlers.get(iDebugMessage.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.byteArrayOutputStream;
            synchronized (byteArrayOutputStream) {
                this.byteArrayOutputStream.reset();
                ((IDebugMessage)object).serialize(this.dataOutputStream);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(this.byteArrayOutputStream.size());
                    this.byteArrayOutputStream.writeTo(this.out);
                    this.out.flush();
                }
            }
        }
        catch (SocketException socketException) {
            if (this.isDebugMode) {
                Logger.log(2, socketException.getMessage(), socketException);
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(Object object) throws Exception {
        if (this.isDebugMode) {
            System.out.println("Sending syncrhonic request: " + object);
        }
        try {
            Object object2;
            int n;
            IDebugRequestMessage iDebugRequestMessage = (IDebugRequestMessage)object;
            Object object3 = this.byteArrayOutputStream;
            synchronized (object3) {
                this.byteArrayOutputStream.reset();
                iDebugRequestMessage.setID(this.lastRequestID++);
                iDebugRequestMessage.serialize(this.dataOutputStream);
                n = this.byteArrayOutputStream.size();
                object2 = this.out;
                synchronized (object2) {
                    this.requestsTable.put(iDebugRequestMessage.getID(), (Object)iDebugRequestMessage);
                    this.out.writeInt(n);
                    this.byteArrayOutputStream.writeTo(this.out);
                    this.out.flush();
                }
            }
            object3 = null;
            n = 20;
            while (object3 == null && this.isConnected()) {
                object2 = object;
                synchronized (object2) {
                    object3 = (IDebugResponseMessage)this.responseTable.remove(iDebugRequestMessage.getID());
                    if (object3 == null) {
                        if (this.isDebugMode) {
                            System.out.println("Response is null. Waiting " + (21 - n) * this.peerResponseTimeout + " milliseconds");
                        }
                        if (n == 15) {
                            PHPLaunchUtilities.showWaitForDebuggerMessage(this);
                        }
                        object.wait(this.peerResponseTimeout);
                    }
                }
                if (object3 == null) {
                    object3 = (IDebugResponseMessage)this.responseTable.remove(iDebugRequestMessage.getID());
                }
                if (object3 != null || !this.isConnected()) continue;
                if (this.isDebugMode) {
                    System.out.println("Communication problems (response is null)");
                }
                if (n > 0) {
                    --n;
                    this.handlePeerResponseTimeout();
                } else {
                    this.closeConnection();
                    PHPLaunchUtilities.hideWaitForDebuggerMessage();
                    PHPLaunchUtilities.showLaunchErrorMessage();
                }
                if (!this.isConnected()) break;
            }
            PHPLaunchUtilities.hideWaitForDebuggerMessage();
            if (this.isDebugMode) {
                System.out.println("Received response: " + object3);
            }
            return object3;
        }
        catch (IOException iOException) {
            PHPDebugPlugin.log(iOException);
        }
        catch (InterruptedException interruptedException) {
            PHPDebugPlugin.log(interruptedException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(Object object, ResponseHandler responseHandler) {
        if (this.isDebugMode) {
            System.out.println("Sending asynchronic request: " + object);
        }
        int n = this.lastRequestID++;
        IDebugRequestMessage iDebugRequestMessage = (IDebugRequestMessage)object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            iDebugRequestMessage.setID(n);
            iDebugRequestMessage.serialize(dataOutputStream);
            int n2 = byteArrayOutputStream.size();
            DataOutputStream dataOutputStream2 = this.out;
            synchronized (dataOutputStream2) {
                this.requestsTable.put(n, object);
                this.responseHandlers.put(new Integer(n), responseHandler);
                this.out.writeInt(n2);
                byteArrayOutputStream.writeTo(this.out);
                this.out.flush();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception for request no." + iDebugRequestMessage.getType() + exception.toString());
            responseHandler.handleResponse(object, null);
            this.responseHandlers.remove(new Integer(n));
        }
    }

    public boolean isConnected() {
        if (this.in != null) {
            try {
                this.in.available();
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public synchronized void closeConnection() {
        Logger.debugMSG("[" + this + "] DebugConnectionThread: Starting closeConnection");
        this.cleanSocket();
        Logger.debugMSG("[" + this + "] DebugConnectionThread: Thread interrupt");
        if (this.theThread.isAlive()) {
            this.theThread.interrupt();
        }
        Logger.debugMSG("[" + this + "] DebugConnectionThread: closing the socket");
        if (this.socket != null) {
            try {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {
                PHPDebugPlugin.log(exception);
            }
            this.socket = null;
        }
    }

    protected void restartInputMessageHandler(DataOutputStream dataOutputStream) {
        if (this.inputMessageHandler == null) {
            this.inputMessageHandler = new InputMessageHandler(dataOutputStream);
        } else {
            this.inputMessageHandler.waitForStart(dataOutputStream, true);
        }
    }

    protected void restartInputManager(DataInputStream dataInputStream) {
        try {
            if (this.inputManager == null) {
                this.inputManager = new InputManager(dataInputStream);
            } else {
                this.inputManager.waitForStart(dataInputStream);
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
    }

    protected short getMessageType(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSocket() {
        DataOutputStream dataOutputStream;
        if (!this.isInitialized) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {}
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {}
        }
        if (this.out != null) {
            try {
                dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {}
        }
        this.socket = null;
        this.in = null;
        if (this.out != null) {
            dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out = null;
            }
        }
    }

    private void handlePeerResponseTimeout() {
        this.getCommunicationClient().handlePeerResponseTimeout();
    }

    protected int getSessionID(String string) {
        int n = string.lastIndexOf("debug_session_id=");
        if (n < 0) {
            return -1;
        }
        n += "debug_session_id=".length();
        if ((n = (string = string.substring(n)).indexOf(38)) > -1) {
            return Integer.parseInt(string.substring(0, n));
        }
        return Integer.parseInt(string.trim());
    }

    public boolean hookDebugSession(DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        Object object;
        ILaunch iLaunch;
        int n;
        ILaunch iLaunch2;
        ILaunch iLaunch3;
        String string = debugSessionStartedNotification.getQuery();
        int n2 = this.getSessionID(string);
        if (n2 == 0) {
            n2 = this.getSessionID(debugSessionStartedNotification.getOptions());
        }
        if ((iLaunch3 = PHPSessionLaunchMapper.get(n2)) == null) {
            ILaunch iLaunch4 = iLaunch2 = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            n = ((ILaunch[])iLaunch4).length;
            int n3 = 0;
            while (n3 < n) {
                iLaunch = iLaunch4[n3];
                object = iLaunch.getAttribute("debugPages");
                if (iLaunch.isTerminated() && ("debugAllPages".equals(object) || "debugFrom".equals(object))) {
                    iLaunch3 = iLaunch;
                    break;
                }
                ++n3;
            }
        }
        if (iLaunch3 != null) {
            iLaunch2 = iLaunch3.getDebugTargets();
            iLaunch = iLaunch3.getProcesses();
            object = iLaunch2;
            int n4 = ((ILaunch[])object).length;
            n = 0;
            while (n < n4) {
                ILaunch iLaunch5 = object[n];
                if (!iLaunch5.isTerminated()) {
                    return true;
                }
                iLaunch3.removeDebugTarget((IDebugTarget)iLaunch5);
                ++n;
            }
            object = iLaunch;
            n4 = ((ILaunch)object).length;
            n = 0;
            while (n < n4) {
                ILaunch iLaunch6 = object[n];
                if (iLaunch6.isTerminated()) {
                    iLaunch3.removeProcess((IProcess)iLaunch6);
                }
                ++n;
            }
            if (Boolean.toString(true).equals(iLaunch3.getAttribute("webServerDebugger"))) {
                this.hookServerDebug(iLaunch3, debugSessionStartedNotification);
            } else {
                this.hookPHPExeDebug(iLaunch3, debugSessionStartedNotification);
            }
            return true;
        }
        return this.handleHookError("No session id");
    }

    protected boolean handleHookError(Object object) {
        if (object != null) {
            Logger.log(4, object.toString());
        } else {
            Logger.log(4, "Debug hook error");
        }
        return false;
    }

    protected void hookServerDebug(final ILaunch iLaunch, DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
        String string = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
        IProject iProject = null;
        if (string != null) {
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        }
        this.inputManager.setTransferEncoding(iLaunchConfiguration.getAttribute("debugTransferEncoding", ""));
        this.inputManager.setOutputEncoding(iLaunchConfiguration.getAttribute("debugOutputEncoding", ""));
        String string2 = iLaunchConfiguration.getAttribute("base_url", "");
        boolean bl = iProject == null ? true : PHPProjectPreferences.getStopAtFirstLine(iProject);
        int n = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
        boolean bl2 = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (iLaunch.getLaunchMode().equals("debug")) {
            bl2 = false;
        }
        PHPProcess pHPProcess = new PHPProcess(iLaunch, string2);
        this.debugTarget = (PHPDebugTarget)this.createDebugTraget(this, iLaunch, string2, n, pHPProcess, bl2, bl, iProject);
        iLaunch.addDebugTarget((IDebugTarget)this.debugTarget);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LaunchManager launchManager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                launchManager.fireUpdate(new ILaunch[]{iLaunch}, 0);
                launchManager.fireUpdate(new ILaunch[]{iLaunch}, 2);
            }
        });
    }

    protected IDebugTarget createDebugTraget(DebugConnectionThread debugConnectionThread, ILaunch iLaunch, String string, int n, PHPProcess pHPProcess, boolean bl, boolean bl2, IProject iProject) throws CoreException {
        return new PHPDebugTarget(debugConnectionThread, iLaunch, string, n, pHPProcess, bl, bl2, iProject);
    }

    protected IDebugTarget createDebugTarget(DebugConnectionThread debugConnectionThread, ILaunch iLaunch, String string, String string2, String string3, int n, PHPProcess pHPProcess, boolean bl, boolean bl2, IProject iProject) throws CoreException {
        return new PHPDebugTarget(debugConnectionThread, iLaunch, string, string2, string3, n, pHPProcess, bl, bl2, iProject);
    }

    protected void hookPHPExeDebug(final ILaunch iLaunch, DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        IProject iProject;
        String string;
        Object object;
        Path path;
        IWorkspaceRoot iWorkspaceRoot;
        IResource iResource;
        ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
        this.inputManager.setTransferEncoding(iLaunchConfiguration.getAttribute("debugTransferEncoding", ""));
        this.inputManager.setOutputEncoding(iLaunchConfiguration.getAttribute("debugOutputEncoding", ""));
        String string2 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string3 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        String string4 = iLaunchConfiguration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        if (iLaunch.getLaunchMode().equals("debug")) {
            bl = false;
        }
        if ((iResource = (iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)(path = new Path(string3)))) != null) {
            object = (IFile)iResource;
            string = object.getName();
            iProject = object.getProject();
        } else if (string4 != null) {
            iProject = iWorkspaceRoot.getProject(string4);
            string = string3;
        } else {
            iProject = ExternalFilesRegistry.getInstance().getExternalFilesProject();
            string = string3;
        }
        object = PHPDebugTarget.getWorkspaceRootPath(iProject.getWorkspace());
        boolean bl2 = PHPProjectPreferences.getStopAtFirstLine(iProject);
        int n = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
        Path path2 = new Path(string2);
        PHPProcess pHPProcess = new PHPProcess(iLaunch, path2.toOSString());
        this.debugTarget = (PHPDebugTarget)this.createDebugTarget(this, iLaunch, string2, string, (String)object, n, pHPProcess, bl, bl2, iProject);
        iLaunch.addDebugTarget((IDebugTarget)this.debugTarget);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LaunchManager launchManager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                launchManager.fireUpdate(new ILaunch[]{iLaunch}, 0);
            }
        });
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return String.valueOf(string) + "@" + Integer.toHexString(this.hashCode());
    }

    static /* synthetic */ IDebugMessageHandler access$5(DebugConnectionThread debugConnectionThread, IDebugMessage iDebugMessage) {
        return debugConnectionThread.createMessageHandler(iDebugMessage);
    }

    private class DummyDebugMessage
    extends DebugMessageImpl {
        private DummyDebugMessage() {
        }

        public void deserialize(DataInputStream dataInputStream) throws IOException {
        }

        public int getType() {
            return 0;
        }

        public void serialize(DataOutputStream dataOutputStream) throws IOException {
        }
    }

    private class InputManager
    implements Runnable {
        private DataInputStream in;
        private boolean inWork = false;
        private boolean isAlive = true;
        private Thread theThread;
        private Object READY_FOR_RESTART_LOCK = new Object();
        private String transferEncoding;
        private String outputEncoding;

        public void setTransferEncoding(String string) {
            this.transferEncoding = string;
        }

        public void setOutputEncoding(String string) {
            this.outputEncoding = string;
        }

        InputManager(DataInputStream dataInputStream) {
            this.in = dataInputStream;
            this.inWork = true;
            this.isAlive = true;
            this.theThread = new Thread(this);
            this.theThread.start();
        }

        public synchronized void start(DataInputStream dataInputStream) {
            this.stop();
            this.in = dataInputStream;
            this.inWork = true;
            this.notifyAll();
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(DataInputStream dataInputStream) {
            if (this.inWork) {
                Object object = this.READY_FOR_RESTART_LOCK;
                synchronized (object) {
                    try {
                        this.READY_FOR_RESTART_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.start(dataInputStream);
        }

        public synchronized void stop() {
            if (!this.inWork) {
                return;
            }
            this.inWork = false;
            this.isAlive = true;
            this.theThread.interrupt();
        }

        public synchronized void terminate() {
            this.inWork = false;
            this.isAlive = false;
            this.theThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl87
            {
                block35: {
                    try {
                        var1_1 = this;
                        synchronized (var1_1) {
                            var2_4 = this.READY_FOR_RESTART_LOCK;
                            synchronized (var2_4) {
                                this.READY_FOR_RESTART_LOCK.notify();
                            }
                            this.wait();
                            v1 = this.in;
                            ** synchronized (v1)
lbl16:
                            // 1 sources

                        }
                    }
                    catch (InterruptedException v3) {
                        if (!DebugConnectionThread.this.isDebugMode) break block35;
                        System.out.println("interrupted: inWork = " + this.inWork + ", isAlive = " + this.isAlive);
                    }
                }
                do {
                    if (!this.inWork && this.isAlive) continue block18;
                    try {
                        if (!this.isAlive) break block18;
                        var1_2 = this.in.readInt();
                        if (var1_2 < 0) {
                            this.shutDown();
                            if (DebugConnectionThread.this.isDebugMode) {
                                System.out.println("Socket error (length is negative): possibly Server is SSL, Client is not.");
                            }
                            Logger.log(4, "Socket error (length is negative): possibly Server is SSL, Client is not.");
                        }
                        var2_4 = this;
                        synchronized (var2_4) {
                            var3_5 = DebugConnectionThread.this.getMessageType(this.in);
                            if (!DebugConnectionThread.this.validProtocol && var3_5 != DebugConnectionThread.startMessageId) {
                                var4_6 = MessageFormat.format(PHPDebugCoreMessages.Debugger_Incompatible_Protocol, new Object[]{String.valueOf(2006040705)});
                                var5_8 = new Status(4, PHPDebugPlugin.getID(), 150, (String)var4_6, null);
                                DebugPlugin.log((IStatus)var5_8);
                                Display.getDefault().asyncExec(new Runnable((String)var4_6){
                                    private final /* synthetic */ String val$errorMessage;
                                    {
                                        this.val$errorMessage = string;
                                    }

                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debugger Error", (String)this.val$errorMessage);
                                    }
                                });
                                this.shutDown();
                                return;
                            }
                            DebugConnectionThread.this.validProtocol = true;
                            var4_6 = DebugMessagesRegistry.getMessage(var3_5);
                            if (var4_6 != null) {
                                if (var4_6 instanceof OutputNotification) {
                                    var4_6.setTransferEncoding(this.outputEncoding);
                                } else {
                                    var4_6.setTransferEncoding(this.transferEncoding);
                                }
                            }
                            if (var4_6 instanceof IDebugNotificationMessage) {
                                var4_6.deserialize(this.in);
                                DebugConnectionThread.access$6(DebugConnectionThread.this).queueIn((IDebugMessage)var4_6);
                            } else if (var4_6 instanceof IDebugResponseMessage) {
                                var4_6.deserialize(this.in);
                                var5_7 = ((IDebugResponseMessage)var4_6).getID();
                                var6_9 = (ResponseHandler)DebugConnectionThread.access$4(DebugConnectionThread.this).get(new Integer(var5_7));
                                if (var6_9 == null) {
                                    DebugConnectionThread.access$3(DebugConnectionThread.this).put(var5_7, var4_6);
                                    var7_10 = (IDebugRequestMessage)DebugConnectionThread.access$2(DebugConnectionThread.this).remove(var5_7);
                                    if (var7_10 != null) {
                                        var8_11 = var7_10;
                                        synchronized (var8_11) {
                                            var7_10.notifyAll();
                                        }
                                    } else {
                                        DebugConnectionThread.access$3(DebugConnectionThread.this).remove(var5_7);
                                    }
                                } else {
                                    DebugConnectionThread.access$6(DebugConnectionThread.this).queueIn((IDebugMessage)var4_6);
                                }
                            } else if (var4_6 instanceof IDebugRequestMessage) {
                                var4_6.deserialize(this.in);
                                DebugConnectionThread.access$6(DebugConnectionThread.this).queueIn((IDebugMessage)var4_6);
                            }
                        }
                    }
                    catch (IOException v6) {
                        this.shutDown();
                    }
                    catch (Exception var1_3) {
                        PHPDebugPlugin.log(var1_3);
                    }
lbl87:
                    // 8 sources

                } while (this.isAlive);
            }
        }

        private void shutDown() {
            this.terminate();
            DebugConnectionThread.this.cleanSocket();
            DebugConnectionThread.this.inputMessageHandler.connectionClosed();
        }
    }

    private class InputMessageHandler
    implements Runnable {
        private BlockingQueue inputMessageQueue = new BlockingQueue(100);
        private boolean shouldExit = false;
        private boolean isAlive = true;
        private boolean inWork = true;
        private Thread theThread;
        private DataOutputStream out;
        private DummyDebugMessage STOP_MSG;
        private ByteArrayOutputStream byteArray;
        private DataOutputStream outArray;
        private Object WAIT;
        private Object READY_FOR_RESTART_LOCK;

        public InputMessageHandler(DataOutputStream dataOutputStream) {
            this.STOP_MSG = new DummyDebugMessage();
            this.byteArray = new ByteArrayOutputStream();
            this.outArray = new DataOutputStream(this.byteArray);
            this.WAIT = new Object();
            this.READY_FOR_RESTART_LOCK = new Object();
            this.out = dataOutputStream;
            this.isAlive = true;
            this.inWork = true;
            this.shouldExit = false;
            this.theThread = new Thread(this);
            this.theThread.setPriority(1);
            this.theThread.start();
        }

        public synchronized void start(DataOutputStream dataOutputStream, boolean bl) {
            if (bl) {
                this.inputMessageQueue.clear();
            }
            this.out = dataOutputStream;
            this.ensureStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(DataOutputStream dataOutputStream, boolean bl) {
            if (this.inWork) {
                Object object = this.READY_FOR_RESTART_LOCK;
                synchronized (object) {
                    try {
                        this.READY_FOR_RESTART_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.start(dataOutputStream, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void ensureStarted() {
            Object object = this.WAIT;
            synchronized (object) {
                this.inWork = true;
                this.isAlive = true;
                this.shouldExit = false;
                this.WAIT.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stopImmediately(boolean bl) {
            if (!this.inWork) {
                return;
            }
            this.inWork = false;
            this.isAlive = true;
            this.inputMessageQueue.releaseReaders();
            if (bl) {
                this.inputMessageQueue.clear();
            }
            Object object = this.WAIT;
            synchronized (object) {
                this.WAIT.notifyAll();
            }
        }

        public void terminate() {
            this.inWork = false;
            this.isAlive = false;
            DebugConnectionThread.this.validProtocol = false;
            this.inputMessageQueue.releaseReaders();
            this.inputMessageQueue.clear();
            this.theThread.interrupt();
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void queueIn(IDebugMessage iDebugMessage) {
            this.inputMessageQueue.queueIn((Object)iDebugMessage);
        }

        public synchronized void connectionClosed() {
            this.ensureStarted();
            this.queueIn(DebugConnectionThread.this.CONNECTION_CLOSED_MSG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void resetCommunication() {
            if (DebugConnectionThread.this.inputManager != null) {
                DebugConnectionThread.this.inputManager.stop();
            }
            this.stopImmediately(true);
            IntHashtable intHashtable = DebugConnectionThread.this.requestsTable;
            synchronized (intHashtable) {
                Iterator iterator = DebugConnectionThread.this.requestsTable.values().iterator();
                while (iterator.hasNext()) {
                    IDebugRequestMessage iDebugRequestMessage;
                    IDebugRequestMessage iDebugRequestMessage2 = iDebugRequestMessage = (IDebugRequestMessage)iterator.next();
                    synchronized (iDebugRequestMessage2) {
                        iDebugRequestMessage.notifyAll();
                    }
                }
            }
            DebugConnectionThread.this.requestsTable.clear();
            DebugConnectionThread.this.responseTable.clear();
            DebugConnectionThread.this.responseHandlers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl84
            {
                try {
                    var1_1 = this.WAIT;
                    synchronized (var1_1) {
                        var2_3 = this.READY_FOR_RESTART_LOCK;
                        synchronized (var2_3) {
                            this.READY_FOR_RESTART_LOCK.notify();
                        }
                        this.WAIT.wait();
                    }
                }
                catch (InterruptedException v2) {}
                do {
                    if (!this.inWork && this.isAlive) continue block21;
                    if (!this.isAlive) break block21;
                    try {
                        var1_1 = (IDebugMessage)this.inputMessageQueue.queueOut();
                        if (DebugConnectionThread.this.isDebugMode) {
                            System.out.println("New message received: " + var1_1);
                        }
                        var2_3 = this;
                        synchronized (var2_3) {
                            block33: {
                                try {
                                    if (var1_1 instanceof DebugSessionStartedNotification) {
                                        DebugConnectionThread.this.hookDebugSession((DebugSessionStartedNotification)var1_1);
                                    }
                                    if (DebugConnectionThread.this.debugTarget != null) {
                                        var3_4 = DebugConnectionThread.access$5(DebugConnectionThread.this, (IDebugMessage)var1_1);
                                        if (var3_4 != null) {
                                            if (DebugConnectionThread.this.isDebugMode) {
                                                System.out.println("Creating message handler: " + var3_4.getClass().getName().replaceFirst(".*\\.", ""));
                                            }
                                            var3_4.handle((IDebugMessage)var1_1, DebugConnectionThread.this.debugTarget);
                                            if (!(var3_4 instanceof IDebugRequestHandler)) break block33;
                                            var4_6 = ((IDebugRequestHandler)var3_4).getResponseMessage();
                                            this.byteArray.reset();
                                            var4_6.serialize(this.outArray);
                                            var5_7 = this.out;
                                            synchronized (var5_7) {
                                                this.out.writeInt(this.byteArray.size());
                                                this.byteArray.writeTo(this.out);
                                                this.out.flush();
                                                break block33;
                                            }
                                        }
                                        if (var1_1 instanceof IDebugResponseMessage) {
                                            var4_6 = (IDebugResponseMessage)var1_1;
                                            var5_8 = var4_6.getID();
                                            var6_9 = (IDebugRequestMessage)DebugConnectionThread.access$2(DebugConnectionThread.this).remove(var5_8);
                                            var7_10 = (ResponseHandler)DebugConnectionThread.access$4(DebugConnectionThread.this).remove(new Integer(var5_8));
                                            var7_10.handleResponse(var6_9, var4_6);
                                            break block33;
                                        }
                                        if (var1_1 == this.STOP_MSG) {
                                            var4_6 = this.STOP_MSG;
                                            synchronized (var4_6) {
                                                this.inWork = false;
                                                this.STOP_MSG.notifyAll();
                                                if (this.shouldExit) {
                                                    this.isAlive = false;
                                                    this.inputMessageQueue.releaseReaders();
                                                }
                                                break block33;
                                            }
                                        }
                                        if (var1_1 == DebugConnectionThread.access$0(DebugConnectionThread.this)) {
                                            this.handleConnectionClosed();
                                        }
                                        break block33;
                                    }
                                    this.handleConnectionClosed();
                                }
                                catch (Exception var3_5) {
                                    PHPDebugPlugin.log(var3_5);
                                }
                            }
                        }
                    }
                    catch (Exception var1_2) {
                        PHPDebugPlugin.log(var1_2);
                    }
lbl84:
                    // 3 sources

                } while (this.isAlive);
            }
        }

        private void handleConnectionClosed() {
            this.resetCommunication();
            if (DebugConnectionThread.this.getCommunicationAdministrator() != null) {
                DebugConnectionThread.this.getCommunicationAdministrator().connectionClosed();
            }
            this.terminate();
            DebugConnectionThread.this.closeConnection();
        }
    }
}

