/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerCompositeFragment
extends CompositeFragment {
    protected Text name;
    protected Text url;
    protected Combo combo;
    private ValuesCache originalValuesCache = new ValuesCache();
    private ValuesCache modifiedValuesCache;

    public ServerCompositeFragment(Composite composite, IControlHandler iControlHandler, boolean bl) {
        super(composite, iControlHandler, bl);
        this.setDescription(PHPServerUIMessages.getString("ServerCompositeFragment.specifyInformation"));
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.setDisplayName(PHPServerUIMessages.getString("ServerCompositeFragment.server"));
        this.createControl();
    }

    public void setData(Object object) throws IllegalArgumentException {
        if (object != null && !(object instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(object);
        this.init();
        this.validate();
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    protected void createControl() {
        GridLayout gridLayout = new GridLayout(1, true);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        Composite composite = new Composite((Composite)this, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(PHPServerUIMessages.getString("ServerCompositeFragment.nameLabel"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.name = new Text(composite, 2048);
        gridData = new GridData(768);
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.serverName = ServerCompositeFragment.this.name.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
        this.createURLGroup((Composite)this);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void init() {
        String string;
        Object object;
        Server server = this.getServer();
        if (this.name == null || server == null) {
            return;
        }
        this.originalValuesCache.url = server.getBaseURL();
        this.originalValuesCache.serverName = server.getName();
        this.originalValuesCache.host = server.getHost();
        this.modifiedValuesCache = new ValuesCache(this.originalValuesCache);
        if (this.originalValuesCache.serverName != null) {
            boolean bl = false;
            object = this.originalValuesCache.serverName;
            String string2 = object;
            if (!this.isForEditing()) {
                int n = 0;
                while (n < 10) {
                    boolean bl2 = this.checkServerName((String)object);
                    if (bl2) {
                        this.name.setText((String)object);
                        this.modifiedValuesCache.serverName = object;
                        bl = true;
                        break;
                    }
                    object = String.valueOf(string2) + " (" + Integer.toString(n + 2) + ")";
                    ++n;
                }
                if (!bl) {
                    this.name.setText("");
                    this.modifiedValuesCache.serverName = "";
                }
            } else {
                this.name.setText((String)object);
            }
        } else {
            this.name.setText("");
        }
        if (!(string = this.originalValuesCache.url).equals("")) {
            this.url.setText(string);
            try {
                int n;
                object = new URL(string);
                this.originalValuesCache.port = n = ((URL)object).getPort();
                this.modifiedValuesCache.port = n;
            }
            catch (Exception exception) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        } else {
            string = "http://" + server.getHost();
            this.url.setText(string);
            this.modifiedValuesCache.url = string;
            try {
                int n;
                object = new URL(string);
                this.modifiedValuesCache.port = n = ((URL)object).getPort();
            }
            catch (Exception exception) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        }
        if (this.originalValuesCache.serverName != null && this.originalValuesCache.serverName.length() > 0) {
            this.setTitle(String.valueOf(PHPServerUIMessages.getString("ServerCompositeFragment.editServer")) + " [" + this.originalValuesCache.serverName + ']');
        } else {
            this.setTitle(PHPServerUIMessages.getString("ServerCompositeFragment.configureServer"));
        }
        this.controlHandler.setTitle(this.getTitle());
    }

    protected void validate() {
        if (this.getServer() == null) {
            this.setMessage("", 3);
            return;
        }
        this.setMessage(this.getDescription(), 0);
        String string = this.modifiedValuesCache.serverName;
        if (string == null || string.trim().equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.missingServerName"), 3);
        } else {
            boolean bl = this.checkServerName(string);
            if (!bl) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.duplicateServerName"), 3);
            }
        }
        String string2 = this.url.getText();
        if (string2 == null || string2.equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        try {
            URL uRL = new URL(string2);
            String string3 = uRL.getHost();
            int n = uRL.getPort();
            this.modifiedValuesCache.host = string3;
            this.modifiedValuesCache.port = n;
        }
        catch (Exception exception) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        this.controlHandler.update();
    }

    protected void setMessage(String string, int n) {
        this.controlHandler.setMessage(string, n);
        this.setComplete(n != 3);
        this.controlHandler.update();
    }

    protected void createURLGroup(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText(PHPServerUIMessages.getString("ServerCompositeFragment.enterDocumentRootURL"));
        this.url = new Text((Composite)group, 2048);
        GridData gridData = new GridData(768);
        this.url.setLayoutData((Object)gridData);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    String string;
                    ((ServerCompositeFragment)ServerCompositeFragment.this).modifiedValuesCache.url = string = ServerCompositeFragment.this.url.getText();
                }
                ServerCompositeFragment.this.validate();
            }
        });
    }

    private boolean checkServerName(String string) {
        if ((string = string.trim()).equals(this.originalValuesCache.serverName)) {
            return true;
        }
        Server[] serverArray = ServersManager.getServers();
        if (serverArray != null) {
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server server = serverArray[n2];
                if (string.equals(server.getName())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean performOk() {
        try {
            Server server = this.getServer();
            if (server != null) {
                server.setPort(String.valueOf(this.modifiedValuesCache.port));
                server.setBaseURL(this.modifiedValuesCache.url);
            }
            server.setHost(this.modifiedValuesCache.host);
            server.setName(this.modifiedValuesCache.serverName);
            if (this.originalValuesCache.serverName != null && !this.originalValuesCache.serverName.equals("") && !this.originalValuesCache.serverName.equals(this.modifiedValuesCache.serverName)) {
                ServersManager.removeServer((String)this.originalValuesCache.serverName);
                ServersManager.addServer((Server)server);
            }
        }
        catch (Throwable throwable) {
            Logger.logException("Error while saving the server settings", throwable);
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        try {
            Server server = this.getServer();
            if (server != null) {
                server.setPort(String.valueOf(this.originalValuesCache.port));
                server.setBaseURL(this.originalValuesCache.url);
            }
            server.setHost(this.originalValuesCache.host);
            server.setName(this.originalValuesCache.serverName);
        }
        catch (Throwable throwable) {
            Logger.logException("Error while reverting the server settings", throwable);
            return false;
        }
        return super.performCancel();
    }

    private class ValuesCache {
        String serverName;
        String url;
        String host;
        int port;

        public ValuesCache() {
        }

        public ValuesCache(ValuesCache valuesCache) {
            this.serverName = valuesCache.serverName;
            this.url = valuesCache.url;
            this.port = valuesCache.port;
            this.host = valuesCache.host;
        }
    }
}

