/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui;

import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistryListener;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.views.variables.PHPDebugElementAdapterFactory;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class PHPDebugUIPlugin
extends AbstractUIPlugin {
    private static PHPDebugUIPlugin plugin;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    public static final String ID = "org.eclipse.php.debug.ui";
    public static final int INTERNAL_ERROR = 10001;
    private ShowViewListener showViewListener;
    private TerminateDebugLaunchListener finishDebugLaunchListener;
    private FirstSelectionDebugLaunchListener firstSelectionDebugLaunchListener;

    public PHPDebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.showViewListener = new ShowViewListener();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.showViewListener);
        this.finishDebugLaunchListener = new TerminateDebugLaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.finishDebugLaunchListener);
        this.firstSelectionDebugLaunchListener = new FirstSelectionDebugLaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.firstSelectionDebugLaunchListener);
        AdapterManager adapterManager = (AdapterManager)Platform.getAdapterManager();
        List list = (List)adapterManager.getFactories().get(IVariable.class.getName());
        PHPDebugElementAdapterFactory pHPDebugElementAdapterFactory = new PHPDebugElementAdapterFactory();
        adapterManager.registerAdapters((IAdapterFactory)pHPDebugElementAdapterFactory, IVariable.class);
        if (list != null && list.size() > 1) {
            list.remove((Object)pHPDebugElementAdapterFactory);
            list.add(0, pHPDebugElementAdapterFactory);
        }
        ExternalFilesRegistry.getInstance().addListener((ExternalFilesRegistryListener)new ExternalFilesLaunchesListener());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        if (this.showViewListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.showViewListener);
        }
        if (this.finishDebugLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.finishDebugLaunchListener);
        }
        if (this.firstSelectionDebugLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.firstSelectionDebugLaunchListener);
        }
        plugin = null;
    }

    public static PHPDebugUIPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)string);
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PHPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = PHPDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = PHPDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void showView(String string) {
        IViewPart iViewPart;
        IWorkbenchPage iWorkbenchPage;
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchWindow iWorkbenchWindow = PHPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iPerspectiveDescriptor = (iWorkbenchPage = iWorkbenchWindow.getActivePage()).getPerspective()).getId().indexOf("php") != -1 && iWorkbenchPage != null && (iViewPart = iWorkbenchPage.findView(string)) == null) {
            try {
                iWorkbenchPage.showView(string);
            }
            catch (PartInitException partInitException) {
                ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)PHPDebugUIMessages.ShowView_errorTitle, (String)partInitException.getMessage(), (IStatus)partInitException.getStatus());
            }
        }
    }

    public static void log(IStatus iStatus) {
        PHPDebugUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        PHPDebugUIPlugin.log((IStatus)new Status(4, ID, 10001, "PHP ui plugin internal error", throwable));
    }

    public static IProject getProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        IProject iProject = null;
        IProject[] iProjectArray2 = iProjectArray;
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject2 = iProjectArray2[n2];
            if (iProject2.getName().equals(string)) {
                iProject = iProject2;
                break;
            }
            ++n2;
        }
        return iProject;
    }

    private static class ExternalFilesLaunchesListener
    implements ExternalFilesRegistryListener {
        private ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");

        public void externalFileAdded(String string) {
        }

        public void externalFileRemoved(final String string) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ExternalFilesLaunchesListener.this.handleExternalFileRemoval(string);
                }
            });
        }

        private void handleExternalFileRemoval(String string) {
            int n;
            IWorkspace iWorkspace;
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            try {
                iWorkspace = iLaunchManager.getLaunches();
                n = 0;
                while (n < ((ILaunch[])iWorkspace).length) {
                    if (string.equals(iWorkspace[n].getLaunchConfiguration().getAttribute("ATTR_FILE", null))) {
                        if (!iWorkspace[n].isTerminated()) {
                            iWorkspace[n].terminate();
                        }
                        iLaunchManager.removeLaunch((ILaunch)iWorkspace[n]);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
            try {
                iWorkspace = iLaunchManager.getLaunchConfigurations(this.configType);
                n = iWorkspace == null ? 0 : ((IWorkspace)iWorkspace).length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = iWorkspace[n2].getAttribute("ATTR_FILE", null);
                    if (string.equals(string2)) {
                        this.deleteLaunchConfiguration((ILaunchConfiguration)iWorkspace[n2]);
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
            iWorkspace = ResourcesPlugin.getWorkspace();
            try {
                IMarker[] iMarkerArray;
                IMarker[] iMarkerArray2 = iMarkerArray = iWorkspace.getRoot().findMarkers(null, true, 2);
                int n3 = iMarkerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string3;
                    IMarker iMarker = iMarkerArray2[n4];
                    String string4 = iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type", "");
                    if ((string4.equals("org.eclipse.php.debug.core.External") || string4.equals("org.eclipse.php.debug.core.Remote")) && string.equals(string3 = iMarker.getAttribute("org.eclipse.php.debug.core.Storage_File", ""))) {
                        iMarker.delete();
                    }
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
        }

        private void deleteLaunchConfiguration(final ILaunchConfiguration iLaunchConfiguration) throws CoreException {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfiguration;
                    try {
                        if (iLaunchConfiguration2 instanceof ILaunchConfigurationWorkingCopy) {
                            iLaunchConfiguration2 = ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration2).getOriginal();
                        }
                        if (iLaunchConfiguration2 != null) {
                            iLaunchConfiguration2.delete();
                        }
                    }
                    catch (CoreException coreException) {
                        Logger.logException(coreException);
                    }
                }
            });
        }
    }

    private static class FirstSelectionDebugLaunchListener
    implements ILaunchesListener2 {
        private FirstSelectionDebugLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] iLaunchArray) {
        }

        public void launchesAdded(ILaunch[] iLaunchArray) {
            if (iLaunchArray != null && iLaunchArray.length > 0) {
                final ILaunch[] iLaunchArray2 = iLaunchArray;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (iWorkbenchWindow == null) {
                            return;
                        }
                        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                        if (iWorkbenchPage == null) {
                            return;
                        }
                        LaunchView launchView = (LaunchView)iWorkbenchPage.findView("org.eclipse.debug.ui.DebugView");
                        if (launchView == null) {
                            return;
                        }
                        try {
                            IDebugTarget iDebugTarget = iLaunchArray2[0].getDebugTarget();
                            if (iDebugTarget == null) {
                                return;
                            }
                            if (iDebugTarget.getThreads() == null || iDebugTarget.getThreads().length == 0) {
                                return;
                            }
                            IThread iThread = iDebugTarget.getThreads()[0];
                            IStackFrame iStackFrame = iThread.getTopStackFrame();
                            if (iStackFrame == null) {
                                return;
                            }
                            Object[] objectArray = new Object[]{DebugPlugin.getDefault().getLaunchManager(), iLaunchArray2[0], iDebugTarget, iThread, iStackFrame};
                            TreePath treePath = new TreePath(objectArray);
                            ((InternalTreeModelViewer)launchView.getViewer()).setSelection((ISelection)new TreeSelection(treePath), true, true);
                        }
                        catch (DebugException debugException) {}
                    }
                });
            }
        }

        public void launchesChanged(ILaunch[] iLaunchArray) {
        }

        public void launchesRemoved(ILaunch[] iLaunchArray) {
        }
    }

    private static class ShowViewListener
    implements IDebugEventSetListener {
        private ShowViewListener() {
        }

        public void handleDebugEvents(DebugEvent[] debugEventArray) {
            block6: {
                if (debugEventArray == null) break block6;
                int n = debugEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        Object object;
                        Object object2;
                        DebugEvent debugEvent;
                        block7: {
                            debugEvent = debugEventArray[n2];
                            if (debugEvent.getKind() != 4) break block7;
                            object2 = debugEventArray[n2].getSource();
                            if (!(object2 instanceof PHPDebugTarget)) break block8;
                            if (PHPDebugPlugin.getOpenDebugViewsOption()) {
                                object = new UIJob("debug output"){

                                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                        PHPDebugUIPlugin.showView("org.eclipse.debug.ui.PHPBrowserOutput");
                                        PHPDebugUIPlugin.showView("org.eclipse.debug.ui.PHPDebugOutput");
                                        PHPDebugUIPlugin.showView("org.eclipse.ui.console.ConsoleView");
                                        return Status.OK_STATUS;
                                    }
                                };
                                object.schedule();
                            }
                        }
                        if (debugEvent.getKind() == 32 && (object2 = debugEventArray[n2].getSource()) instanceof PHPDebugTarget && (object = debugEventArray[n2].getData()) instanceof IStatus) {
                            UIJob uIJob = new UIJob("debug output"){

                                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                    IStatus iStatus = (IStatus)object;
                                    Shell shell = PHPDebugUIPlugin.getActiveWorkbenchShell();
                                    ErrorDialog.openError((Shell)shell, null, null, (IStatus)iStatus);
                                    return Status.OK_STATUS;
                                }
                            };
                            uIJob.schedule();
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private static class TerminateDebugLaunchListener
    implements ILaunchesListener2 {
        private TerminateDebugLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] iLaunchArray) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
                        PHPLaunchUtilities.switchToPHPPerspective();
                    }
                }
            });
        }

        public void launchesAdded(ILaunch[] iLaunchArray) {
        }

        public void launchesChanged(ILaunch[] iLaunchArray) {
        }

        public void launchesRemoved(ILaunch[] iLaunchArray) {
        }
    }
}

