/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueInputDialog;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStringValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

public class XDebugVariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable iVariable, Shell shell) {
        try {
            String string = iVariable.getName();
            String string2 = "Change Value";
            String string3 = MessageFormat.format("Enter a new value for {0}:", string);
            String string4 = this.getValueString(iVariable);
            PrimitiveValidator primitiveValidator = new PrimitiveValidator(iVariable);
            ChangeVariableValueInputDialog changeVariableValueInputDialog = new ChangeVariableValueInputDialog(shell, string2, string3, string4, (IInputValidator)primitiveValidator);
            if (changeVariableValueInputDialog.open() == 0) {
                String string5 = changeVariableValueInputDialog.getValue();
                iVariable.setValue(string5);
            }
        }
        catch (DebugException debugException) {
            IStatus iStatus = debugException.getStatus();
            ErrorDialog.openError((Shell)shell, (String)"Error Changing Value", (String)"An exception occurred attempting to change the variable value.", (IStatus)iStatus);
        }
        return true;
    }

    private String getValueString(IVariable iVariable) throws DebugException {
        DBGpStringValue dBGpStringValue;
        IValue iValue = iVariable.getValue();
        String string = iValue.getValueString();
        if (iValue instanceof DBGpStringValue && !(dBGpStringValue = (DBGpStringValue)iValue).isComplete()) {
            DBGpTarget dBGpTarget = (DBGpTarget)iValue.getDebugTarget();
            DBGpVariable dBGpVariable = (DBGpVariable)iVariable;
            String string2 = dBGpVariable.getStackLevel();
            Node node = dBGpTarget.getCompleteString(dBGpVariable.getFullName(), string2, dBGpStringValue.getRequiredBytes());
            if (node != null) {
                DBGpVariable dBGpVariable2 = new DBGpVariable(dBGpTarget, node, string2);
                IValue iValue2 = null;
                try {
                    iValue2 = dBGpVariable2.getValue();
                    if (iValue2 != null) {
                        string = iValue2.getValueString();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public boolean saveVariable(IVariable iVariable, String string, Shell shell) {
        return false;
    }

    protected class PrimitiveValidator
    implements IInputValidator {
        IVariable var;

        public PrimitiveValidator(IVariable iVariable) {
            this.var = iVariable;
        }

        public String isValid(String string) {
            String string2 = null;
            try {
                if (!this.var.verifyValue(string)) {
                    string2 = "Invalid entry for variable";
                }
            }
            catch (DebugException debugException) {
                Logger.logException("DebugException", debugException);
                string2 = "unexpected error occurred, see log for details";
            }
            return string2;
        }
    }
}

