/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtil;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsComboBlock;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PHPExecutableLaunchTab
extends AbstractLaunchConfigurationTab {
    public static final String FIRST_EDIT = "editedByPHPExecutableLaunchTab";
    private Text debugFileTextField;
    private Button argumentVariablesButton;
    protected Button breakOnFirstLine;
    private boolean enableDebugInfoOption;
    protected boolean enableFileSelection = true;
    protected boolean enableBreakpointSelection = true;
    private final ISelectionChangedListener fSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            PHPExecutableLaunchTab.this.handleSelectedPHPexeChanged();
        }
    };
    private Button fileLocationButton;
    protected WidgetListener fListener = new WidgetListener();
    private Text locationField;
    protected PHPsComboBlock phpsComboBlock = new PHPsComboBlock();
    private Button runWithDebugInfo;
    protected SelectionAdapter selectionAdapter;

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            stringBuffer.append(string2);
            ++n2;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    protected void createArgumentComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPDebugUIMessages.PHP_File;
        group.setText(string);
        GridLayout gridLayout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setFont(composite.getFont());
        this.debugFileTextField = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.debugFileTextField.setLayoutData((Object)gridData);
        this.debugFileTextField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.debugFileTextField, group.getText());
        this.argumentVariablesButton = this.createPushButton((Composite)group, PHPDebugUIMessages.Browse, null);
        gridData = (GridData)this.argumentVariablesButton.getLayoutData();
        gridData.horizontalSpan = 1;
        this.argumentVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.argumentVariablesButton, this.argumentVariablesButton.getText());
    }

    private void createBreakControl(Composite composite) {
        String string = this.getLaunchConfigurationDialog().getMode();
        if ("debug".equals(string) && this.enableBreakpointSelection) {
            Group group = new Group(composite, 0);
            group.setText(PHPDebugUIMessages.Breakpoint_Group_Label);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            GridData gridData = new GridData(768);
            group.setLayout((Layout)gridLayout);
            group.setLayoutData((Object)gridData);
            this.breakOnFirstLine = this.createCheckButton((Composite)group, PHPDebugUIMessages.Breakpoint_Group_BreakAtFirstLine);
            this.breakOnFirstLine.addSelectionListener((SelectionListener)this.fListener);
            if (!this.enableBreakpointSelection) {
                this.setEnableBreakpointSelection(this.enableBreakpointSelection);
            }
        }
    }

    public void createControl(Composite composite) {
        if (this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.setEnableDebugInfoOption(true);
        }
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        this.setControl((Control)scrolledCompositeImpl);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        scrolledCompositeImpl.setContent((Control)composite2);
        scrolledCompositeImpl.setLayout((Layout)gridLayout);
        scrolledCompositeImpl.setFont(composite.getFont());
        this.createLocationComponent(composite2);
        if (this.enableFileSelection) {
            this.createArgumentComponent(composite2);
        }
        this.createDebugInfoComponent(composite2);
        this.runWithDebugInfo.setVisible(this.enableDebugInfoOption);
        this.createBreakControl(composite2);
        this.createVerticalSpacer(composite2, 1);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createDebugInfoComponent(Composite composite) {
        this.runWithDebugInfo = new Button(composite, 32);
        this.runWithDebugInfo.setText(PHPDebugUIMessages.PHPexe_Run_With_Debug_Info);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.runWithDebugInfo.setLayoutData((Object)gridData);
        this.runWithDebugInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createLocationComponent(Composite composite) {
        this.phpsComboBlock.createControl(composite);
        Control control = this.phpsComboBlock.getControl();
        this.phpsComboBlock.addSelectionChangedListener(this.fSelectionListener);
        GridData gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    protected PHPexeDescriptor getDefaultPHPexeDescriptor() {
        return null;
    }

    public String getName() {
        return "PHP Script";
    }

    protected PHPexeDescriptor getSpecificPHPexeDescriptor() {
        return null;
    }

    protected String getWorkingDirectoryLabel() {
        return PHPDebugUIMessages.WorkingDirectory;
    }

    protected void handleBreakButtonSelected() {
        this.updateLaunchConfigurationDialog();
    }

    protected void handleFileLocationButtonSelected() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setFileName(this.locationField.getText());
        String string = fileDialog.open();
        if (string != null) {
            this.locationField.setText(string);
        }
    }

    protected void handleSelectedPHPexeChanged() {
        this.updateLaunchConfigurationDialog();
    }

    private void handleChangeFileToDebug(Text text) {
        IResource iResource = LaunchUtilities.getFileFromDialog(null, this.getShell(), LaunchUtil.getFileExtensions(), LaunchUtil.getRequiredNatures(), true);
        if (iResource instanceof IFile) {
            if (iResource instanceof ExternalFileWrapper) {
                text.setText(iResource.getFullPath().toOSString());
            } else {
                text.setText(iResource.getFullPath().toString());
            }
            String string = "";
            IPath iPath = iResource.getLocation();
            string = iPath != null ? iPath.toOSString() : iResource.getFullPath().toString();
            text.setData((Object)string);
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.updateLocation(iLaunchConfiguration);
        if (this.enableDebugInfoOption) {
            this.updateDebugInfoOption(iLaunchConfiguration);
        }
        if (this.enableFileSelection) {
            this.updateArgument(iLaunchConfiguration);
        }
        try {
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(iLaunchConfiguration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        this.isValid(iLaunchConfiguration);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        block10: {
            IResource iResource;
            block13: {
                Object object;
                block11: {
                    block12: {
                        block9: {
                            this.setErrorMessage(null);
                            try {
                                String string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
                                boolean bl = true;
                                try {
                                    object = new File(string);
                                    if (!((File)object).exists()) {
                                        bl = false;
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    bl = false;
                                }
                                if (bl) break block9;
                                this.setErrorMessage(PHPDebugUIMessages.PHP_Location_Message);
                                return false;
                            }
                            catch (CoreException coreException) {}
                        }
                        if (!this.enableFileSelection) break block10;
                        object = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
                        if (FileUtils.resourceExists((String)object)) break block11;
                        if (!ExternalFilesRegistry.getInstance().isEntryExist((String)object)) break block12;
                        this.debugFileTextField.setData(object);
                        return true;
                    }
                    this.setErrorMessage(PHPDebugUIMessages.PHP_File_Not_Exist);
                    return false;
                }
                iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((String)object);
                if (iResource.getType() == 1 && PHPModelUtil.hasPhpExtention((IFile)((IFile)iResource))) break block13;
                this.setErrorMessage(String.valueOf(object) + PHPDebugUIMessages.PHPExecutableLaunchTab_isNotPHPFile);
                return false;
            }
            String string = "";
            string = iResource.getLocation() == null ? iResource.getFullPath().toString() : iResource.getLocation().toOSString();
            this.debugFileTextField.setData((Object)string);
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = this.phpsComboBlock.getSelectedDebuggerId();
        String string2 = this.phpsComboBlock.getSelectedExecutablePath();
        if (string2.length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string2);
        }
        String string3 = this.phpsComboBlock.getSelectedIniPath();
        if (string3.length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_INI_LOCATION", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_INI_LOCATION", string3);
        }
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, string);
        String string4 = null;
        if (!this.enableFileSelection || (string4 = this.debugFileTextField.getText().trim()).length() == 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", null);
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE_FULL_PATH", null);
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string4);
            iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE_FULL_PATH", this.debugFileTextField.getData().toString());
        }
        boolean bl = this.enableDebugInfoOption ? this.runWithDebugInfo != null && this.runWithDebugInfo.getSelection() : true;
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        if (this.breakOnFirstLine != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
        this.applyLaunchDelegateConfiguration(iLaunchConfigurationWorkingCopy);
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = null;
        try {
            string = iLaunchConfigurationWorkingCopy.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration abstractDebuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)string);
            iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, abstractDebuggerConfiguration.getScriptLaunchDelegateClass());
        }
        catch (Exception exception) {
            Logger.logException(exception);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        try {
            String string = iLaunchConfigurationWorkingCopy.getAttribute("ATTR_LOCATION", "");
            if (string.equals("")) {
                PHPexes pHPexes = PHPexes.getInstance();
                PHPexeItem pHPexeItem = pHPexes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
                if (pHPexeItem == null) {
                    return;
                }
                string = pHPexeItem.getExecutable().toString();
                iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string);
                String string2 = pHPexeItem.getINILocation() != null ? pHPexeItem.getINILocation().toString() : null;
                iLaunchConfigurationWorkingCopy.setAttribute("ATTR_INI_LOCATION", string2);
                iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine());
                this.applyLaunchDelegateConfiguration(iLaunchConfigurationWorkingCopy);
            }
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error setting default configuration", coreException);
        }
    }

    public void setEnableDebugInfoOption(boolean bl) {
        if (bl == this.enableDebugInfoOption) {
            return;
        }
        if (!this.getLaunchConfigurationDialog().getMode().equals("run")) {
            this.enableDebugInfoOption = false;
            return;
        }
        this.enableDebugInfoOption = bl;
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setVisible(bl);
        }
    }

    public void setEnableFileSelection(boolean bl) {
        if (bl == this.enableFileSelection) {
            return;
        }
        this.enableFileSelection = bl;
        if (this.argumentVariablesButton != null) {
            this.argumentVariablesButton.setVisible(bl);
        }
        if (this.debugFileTextField != null) {
            this.debugFileTextField.setVisible(bl);
        }
    }

    public void setEnableBreakpointSelection(boolean bl) {
        if (bl == this.enableBreakpointSelection) {
            return;
        }
        this.enableBreakpointSelection = bl;
        if (this.breakOnFirstLine != null) {
            this.breakOnFirstLine.setSelection(bl);
            this.breakOnFirstLine.setEnabled(bl);
        }
    }

    protected void updateArgument(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        String string2 = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
            string2 = iLaunchConfiguration.getAttribute("ATTR_FILE_FULL_PATH", "");
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        if (this.debugFileTextField != null) {
            this.debugFileTextField.setText(string);
            this.debugFileTextField.setData((Object)string2);
        }
    }

    protected void updateDebugInfoOption(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = PHPDebugPlugin.getDebugInfoOption();
        try {
            bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", bl);
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        if (this.runWithDebugInfo != null) {
            this.runWithDebugInfo.setSelection(bl);
        }
    }

    protected void updateLocation(ILaunchConfiguration iLaunchConfiguration) {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            string = iLaunchConfiguration.getAttribute("ATTR_LOCATION", "");
            string2 = iLaunchConfiguration.getAttribute("ATTR_INI_LOCATION", "");
            string3 = iLaunchConfiguration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
        }
        catch (CoreException coreException) {
            Logger.log(4, "Error reading configuration", coreException);
        }
        PHPexes pHPexes = PHPexes.getInstance();
        PHPexeItem pHPexeItem = string != null && string.length() > 0 ? pHPexes.getItemForFile(string, string2) : pHPexes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
        if (!PHPDebuggersRegistry.getDebuggersIds().contains(string3)) {
            string3 = PHPDebugPlugin.getCurrentDebuggerId();
            pHPexeItem = pHPexes.getDefaultItem(string3);
        }
        this.phpsComboBlock.setDebugger(string3);
        this.phpsComboBlock.setPHPexe(pHPexeItem);
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            PHPExecutableLaunchTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            PHPExecutableLaunchTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == PHPExecutableLaunchTab.this.fileLocationButton) {
                PHPExecutableLaunchTab.this.handleFileLocationButtonSelected();
            } else if (object == PHPExecutableLaunchTab.this.argumentVariablesButton) {
                PHPExecutableLaunchTab.this.handleChangeFileToDebug(PHPExecutableLaunchTab.this.debugFileTextField);
            } else if (object == PHPExecutableLaunchTab.this.breakOnFirstLine) {
                PHPExecutableLaunchTab.this.handleBreakButtonSelected();
            }
        }
    }
}

