/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.io.IOException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.php.internal.ui.dnd.DNDUtils;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderRegistry;
import org.eclipse.php.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.PHPManualSiteDescriptor;
import org.eclipse.php.internal.ui.util.ProblemMarkerManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.osgi.framework.BundleContext;

public class PHPUiPlugin
extends AbstractUIPlugin {
    private static PHPUiPlugin plugin;
    private IContentFormatter fActiveFormatter = null;
    public static final String ID = "org.eclipse.php.ui";
    public static final int INTERNAL_ERROR = 10001;
    public static final boolean isDebugMode;
    public static final String PERSPECTIVE_ID = "org.eclipse.php.perspective";
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private ProblemMarkerManager fProblemMarkerManager;
    protected TemplateStore templateStore = null;
    protected ContextTypeRegistry contentTypeRegistry = null;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private PHPFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private PHPEditorTextHoverDescriptor[] fPHPEditorTextHoverDescriptors;
    private PHPManualSiteDescriptor[] fPHPManualSiteDescriptors;

    static {
        String string = Platform.getDebugOption((String)"org.eclipse.php.ui/debug");
        isDebugMode = string != null && string.equalsIgnoreCase("true");
    }

    public PHPUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DNDUtils.initEditorSiteExternalDrop();
            }
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static PHPUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)string);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = PHPUiPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void logErrorMessage(String string) {
        PHPUiPlugin.log((IStatus)new Status(4, ID, 10001, string, null));
    }

    public static void log(IStatus iStatus) {
        PHPUiPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        PHPUiPlugin.log((IStatus)new Status(4, ID, 10001, "PHP ui plugin internal error", throwable));
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return PHPUiPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return PHPUiPlugin.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void createStandardGroups(IMenuManager iMenuManager) {
        if (!iMenuManager.isEmpty()) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator("group.new"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.goto"));
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new GroupMarker("group.show"));
        iMenuManager.add((IContributionItem)new Separator("group.reorganize"));
        iMenuManager.add((IContributionItem)new Separator("group.build"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("group.properties"));
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new PHPTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), "org.eclipse.php.ui.editor.templates");
            try {
                this.templateStore.load();
            }
            catch (IOException iOException) {
                Logger.logException((Throwable)iOException);
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.contentTypeRegistry == null) {
            ContributionContextTypeRegistry contributionContextTypeRegistry = new ContributionContextTypeRegistry();
            contributionContextTypeRegistry.addContextType("php");
            contributionContextTypeRegistry.addContextType("phpdoc");
            contributionContextTypeRegistry.addContextType("newPhp");
            this.contentTypeRegistry = contributionContextTypeRegistry;
        }
        return this.contentTypeRegistry;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        if (this.fMembersOrderPreferenceCache == null) {
            this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        }
        return this.fMembersOrderPreferenceCache;
    }

    public static String getPluginId() {
        return ID;
    }

    public synchronized PHPFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new PHPFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public PHPEditorTextHoverDescriptor[] getPHPEditorTextHoverDescriptors() {
        if (this.fPHPEditorTextHoverDescriptors == null) {
            this.fPHPEditorTextHoverDescriptors = PHPEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter configurationElementSorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((PHPEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            configurationElementSorter.sort((Object[])this.fPHPEditorTextHoverDescriptors);
            int n = 0;
            while (n < this.fPHPEditorTextHoverDescriptors.length - 1) {
                if ("org.eclipse.php.ui.editor.hover.BestMatchHover".equals(this.fPHPEditorTextHoverDescriptors[n].getId())) {
                    PHPEditorTextHoverDescriptor pHPEditorTextHoverDescriptor = this.fPHPEditorTextHoverDescriptors[n];
                    int n2 = n;
                    while (n2 > 0) {
                        this.fPHPEditorTextHoverDescriptors[n2] = this.fPHPEditorTextHoverDescriptors[n2 - 1];
                        --n2;
                    }
                    this.fPHPEditorTextHoverDescriptors[0] = pHPEditorTextHoverDescriptor;
                    break;
                }
                ++n;
            }
        }
        return this.fPHPEditorTextHoverDescriptors;
    }

    public void resetPHPEditorTextHoverDescriptors() {
        this.fPHPEditorTextHoverDescriptors = null;
    }

    public PHPManualSiteDescriptor[] getPHPManualSiteDescriptors() {
        if (this.fPHPManualSiteDescriptors == null) {
            this.fPHPManualSiteDescriptors = PHPManualSiteDescriptor.getContributedSites();
        }
        return this.fPHPManualSiteDescriptors;
    }

    public IContentFormatter getActiveFormatter() {
        if (this.fActiveFormatter == null) {
            String string = "org.eclipse.php.ui.phpFormatterProcessor";
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (iConfigurationElement.getName().equals("processor")) {
                    ElementCreationProxy elementCreationProxy = new ElementCreationProxy(iConfigurationElement, string);
                    this.fActiveFormatter = (IContentFormatter)elementCreationProxy.getObject();
                }
                ++n;
            }
            if (this.fActiveFormatter == null) {
                this.fActiveFormatter = new MultiPassContentFormatter("org.eclipse.wst.sse.core.default_structured_text_partitioning", "org.eclipse.wst.html.HTML_DEFAULT");
                ((MultiPassContentFormatter)this.fActiveFormatter).setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new PhpFormatProcessorImpl()));
            }
        }
        return this.fActiveFormatter;
    }
}

