/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;

public class RenameResourceAction
extends SelectionDispatchAction {
    TreeViewer treeViewer;

    public RenameResourceAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        ViewSite viewSite;
        IWorkbenchPart iWorkbenchPart;
        if (iWorkbenchSite instanceof ViewSite && (iWorkbenchPart = (viewSite = (ViewSite)iWorkbenchSite).getPart()) instanceof ExplorerPart) {
            ExplorerPart explorerPart = (ExplorerPart)iWorkbenchPart;
            this.treeViewer = explorerPart.getViewer();
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection instanceof ITextSelection) {
            this.setEnabled(true);
            return;
        }
        if (iStructuredSelection.size() != 1) {
            this.setEnabled(false);
            return;
        }
        Object object = iStructuredSelection.toArray()[0];
        if (object instanceof PHPFileData || object instanceof IResource) {
            IResource iResource = PHPModelUtil.getResource((Object)object);
            if (iResource != null && iResource.exists()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            return;
        }
        this.setEnabled(false);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IResource iResource = RenameResourceAction.getResource(iStructuredSelection);
        if (!ActionUtils.isProcessable(this.getShell(), iResource)) {
            return;
        }
        if (!ActionUtils.isRenameAvailable(iResource)) {
            return;
        }
        this.createWorkbenchAction(iStructuredSelection).run();
    }

    private ResourceNavigatorRenameAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        PHPResourceNavigatorRenameAction pHPResourceNavigatorRenameAction = new PHPResourceNavigatorRenameAction(this.getShell(), this.treeViewer);
        pHPResourceNavigatorRenameAction.selectionChanged(iStructuredSelection);
        return pHPResourceNavigatorRenameAction;
    }

    private static IResource getResource(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof PHPCodeData && !(object instanceof PHPFileData)) {
            return null;
        }
        if (!((object = PHPModelUtil.getResource((Object)object)) instanceof IResource)) {
            return null;
        }
        return (IResource)object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PHPResourceNavigatorRenameAction
    extends ResourceNavigatorRenameAction {
        public PHPResourceNavigatorRenameAction(Shell shell, TreeViewer treeViewer) {
            super(shell, treeViewer);
        }

        protected void runWithNewPath(IPath iPath, IResource iResource) {
            IUndoableOperation iUndoableOperation = this.createOperation(iPath, iResource);
            try {
                TriggeredOperations triggeredOperations = new TriggeredOperations(iUndoableOperation, PlatformUI.getWorkbench().getOperationSupport().getOperationHistory());
                PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)triggeredOperations, (IProgressMonitor)new NullProgressMonitor(), WorkspaceUndoUtil.getUIInfoAdapter((Shell)RenameResourceAction.this.getShell()));
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof CoreException) {
                    Logger.logException(executionException.getCause());
                }
                Logger.logException(executionException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRunWithNewPath(IPath iPath, IResource iResource, Map<Integer, IBreakpoint> map, Map<Integer, Map<String, Object>> map2) {
            Object object;
            PHPResourceNavigatorRenameAction pHPResourceNavigatorRenameAction;
            IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            try {
                pHPResourceNavigatorRenameAction = this;
                synchronized (pHPResourceNavigatorRenameAction) {
                    IMarker[] iMarkerArray = object = iResource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    int n = ((IMarker[])object).length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker iMarker = iMarkerArray[n2];
                        IBreakpoint iBreakpoint = iBreakpointManager.getBreakpoint(iMarker);
                        Integer n3 = (Integer)iMarker.getAttribute("lineNumber");
                        if (iBreakpoint != null) {
                            map.put(n3, iBreakpoint);
                            map2.put(n3, iBreakpoint.getMarker().getAttributes());
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
            super.runWithNewPath(iPath, iResource);
            pHPResourceNavigatorRenameAction = ResourcesPlugin.getWorkspace();
            object = new WorkspaceJob("Creating markers", (IWorkspace)pHPResourceNavigatorRenameAction, iResource, iPath, map, map2, iBreakpointManager){
                private final /* synthetic */ IWorkspace val$workspace;
                private final /* synthetic */ IResource val$resource;
                private final /* synthetic */ IPath val$path;
                private final /* synthetic */ Map val$breakpoints;
                private final /* synthetic */ Map val$breakpointAttributes;
                private final /* synthetic */ IBreakpointManager val$breakpointManager;
                {
                    this.val$workspace = iWorkspace;
                    this.val$resource = iResource;
                    this.val$path = iPath;
                    this.val$breakpoints = map;
                    this.val$breakpointAttributes = map2;
                    this.val$breakpointManager = iBreakpointManager;
                    super(string);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        IFile iFile = this.val$workspace.getRoot().getFile(this.val$resource.getFullPath());
                        if (iFile.isAccessible()) {
                            return Status.CANCEL_STATUS;
                        }
                        IResource iResource = this.val$workspace.getRoot().findMember(this.val$path);
                        if (iResource == null) {
                            return Status.CANCEL_STATUS;
                        }
                        if (iResource.getType() != 1) {
                            return Status.CANCEL_STATUS;
                        }
                        for (Integer n : this.val$breakpoints.keySet()) {
                            Map map = (Map)this.val$breakpointAttributes.get(n);
                            IMarker iMarker = iResource.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                            String string = (String)map.get("message");
                            if (string != null) {
                                map.put("message", string.replaceFirst(this.val$resource.getName(), this.val$path.lastSegment()));
                            }
                            iMarker.setAttributes(map);
                            IBreakpoint iBreakpoint = (IBreakpoint)this.val$breakpoints.get(n);
                            iBreakpoint.setMarker(iMarker);
                            this.val$breakpointManager.addBreakpoint(iBreakpoint);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            object.setRule((ISchedulingRule)pHPResourceNavigatorRenameAction.getRoot());
            object.setSystem(true);
            object.schedule(1000L);
        }

        protected IUndoableOperation createOperation(final IPath iPath, final IResource iResource) {
            AbstractOperation abstractOperation = new AbstractOperation("Advanced rename"){
                private IPath oldPath;
                private final Map<Integer, IBreakpoint> breakpoints;
                private final Map<Integer, Map<String, Object>> breakpointAttributes;
                {
                    super(string);
                    this.oldPath = iResource2.getFullPath();
                    this.breakpoints = new HashMap<Integer, IBreakpoint>(6);
                    this.breakpointAttributes = new HashMap<Integer, Map<String, Object>>(6);
                }

                public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    PHPResourceNavigatorRenameAction.this.doRunWithNewPath(iPath, iResource, this.breakpoints, this.breakpointAttributes);
                    return Status.OK_STATUS;
                }

                public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    IResource iResource2 = ResourcesPlugin.getWorkspace().getRoot().findMember(iResource.getFullPath());
                    PHPResourceNavigatorRenameAction.this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)iResource2));
                    PHPResourceNavigatorRenameAction.this.doRunWithNewPath(iPath, iResource2, this.breakpoints, this.breakpointAttributes);
                    return Status.OK_STATUS;
                }

                public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    IResource iResource2 = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
                    PHPResourceNavigatorRenameAction.this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)iResource2));
                    PHPResourceNavigatorRenameAction.this.doRunWithNewPath(this.oldPath, iResource2, this.breakpoints, this.breakpointAttributes);
                    return Status.OK_STATUS;
                }
            };
            return abstractOperation;
        }
    }
}

