/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class CoreUtility {
    public static void createFolder(IFolder iFolder, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFolder.exists()) {
            IContainer iContainer = iFolder.getParent();
            if (iContainer instanceof IFolder) {
                CoreUtility.createFolder((IFolder)iContainer, bl, bl2, null);
            }
            iFolder.create(bl, bl2, iProgressMonitor);
        }
    }

    public static Object createExtension(final IConfigurationElement iConfigurationElement, final String string) throws CoreException {
        String string2 = iConfigurationElement.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)string2);
        if (bundle != null && bundle.getState() == 32) {
            return iConfigurationElement.createExecutableExtension(string);
        }
        final Object[] objectArray = new Object[1];
        final CoreException[] coreExceptionArray = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    objectArray[0] = iConfigurationElement.createExecutableExtension(string);
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (coreExceptionArray[0] != null) {
            throw coreExceptionArray[0];
        }
        return objectArray[0];
    }

    public static void startBuildInBackground(IProject iProject) {
        CoreUtility.getBuildJob(iProject).schedule();
    }

    public static Job getBuildJob(IProject iProject) {
        BuildJob buildJob = new BuildJob(PHPUIMessages.getString("CoreUtility_job_title"), iProject);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static boolean enableAutoBuild(boolean bl) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
        boolean bl2 = iWorkspaceDescription.isAutoBuilding();
        if (bl2 != bl) {
            iWorkspaceDescription.setAutoBuilding(bl);
            iWorkspace.setDescription(iWorkspaceDescription);
        }
        return bl2;
    }

    public static boolean isPartialPrefixOf(IPath iPath, IPath iPath2) {
        if ((iPath = CoreUtility.pathToLower(iPath)).isPrefixOf(iPath2 = CoreUtility.pathToLower(iPath2))) {
            return true;
        }
        if (iPath.segmentCount() > iPath2.segmentCount()) {
            return false;
        }
        return iPath.segmentCount() != 0 && !iPath.hasTrailingSeparator() && iPath.removeLastSegments(1).isPrefixOf(iPath2) && iPath2.segment(iPath.segmentCount() - 1).startsWith(iPath.lastSegment());
    }

    private static IPath pathToLower(IPath iPath) {
        String string = iPath.toString();
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = Character.toLowerCase(string.charAt(n2));
            ++n2;
        }
        return new Path(new String(cArray));
    }

    private static final class BuildJob
    extends Job {
        private final IProject fProject;

        private BuildJob(String string, IProject iProject) {
            super(string);
            this.fProject = iProject;
        }

        public boolean isCoveredBy(BuildJob buildJob) {
            if (buildJob.fProject == null) {
                return true;
            }
            return this.fProject != null && this.fProject.equals((Object)this.fProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Job job;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                Job[] jobArray;
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] jobArray2 = jobArray = Platform.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int n = jobArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BuildJob buildJob;
                    job = jobArray2[n2];
                    if (job != this && job instanceof BuildJob && (buildJob = (BuildJob)job).isCoveredBy(this)) {
                        job.cancel();
                    }
                    ++n2;
                }
            }
            try {
                try {
                    if (this.fProject != null) {
                        iProgressMonitor.beginTask(MessageFormat.format(PHPUIMessages.getString("CoreUtility_buildproject_taskname"), this.fProject.getName()), 2);
                        this.fProject.build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        PHPUiPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    } else {
                        iProgressMonitor.beginTask(PHPUIMessages.getString("CoreUtility_buildall_taskname"), 2);
                        PHPUiPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    }
                }
                catch (CoreException coreException) {
                    job = coreException.getStatus();
                    iProgressMonitor.done();
                    return job;
                }
                catch (OperationCanceledException operationCanceledException) {
                    job = Status.CANCEL_STATUS;
                    iProgressMonitor.done();
                    return job;
                }
            }
            finally {
                iProgressMonitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == object;
        }
    }
}

