/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPElementLabels;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = 1090519051L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager iStatusLineManager) {
        this.fStatusLineManager = iStatusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        String string = this.formatMessage(selectionChangedEvent.getSelection());
        this.fStatusLineManager.setMessage(string);
    }

    protected String formatMessage(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            int n = iStructuredSelection.size();
            if (n > 1) {
                return MessageFormat.format(PHPUIMessages.getString("StatusBarUpdater_num_elements_selected"), String.valueOf(n));
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof PHPCodeData || object instanceof PHPWorkspaceModelManager || object instanceof PHPProjectModel) {
                return this.formatPHPElementMessage(object);
            }
            if (object instanceof IResource) {
                return this.formatResourceMessage((IResource)object);
            }
        }
        return "";
    }

    private String formatPHPElementMessage(Object object) {
        Object object2;
        UserData userData;
        String string = "";
        if (object instanceof PHPCodeData && (userData = (object2 = (PHPCodeData)object).getUserData()) != null) {
            string = " (" + userData.getFileName() + ")";
        }
        object2 = PHPElementLabels.getElementLabel(object, 1090519051L);
        return String.valueOf(object2) + string;
    }

    private String formatResourceMessage(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        if (iContainer != null && iContainer.getType() != 8) {
            return String.valueOf(iResource.getName()) + " - " + iContainer.getFullPath().makeRelative().toString();
        }
        return iResource.getName();
    }
}

