/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.wizards.WizardPageFactory;

public class PHPWizardPagesRegistry {
    private static final String EXTENSION_POINT = "org.eclipse.php.ui.phpWizardPages";
    private static final String PAGE_ELEMENT = "page";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private Map pages = new HashMap();
    private static PHPWizardPagesRegistry instance = new PHPWizardPagesRegistry();

    private PHPWizardPagesRegistry() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (PAGE_ELEMENT.equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(TARGET_ID_ATTRIBUTE);
                LinkedList<IConfigurationElement> linkedList = (LinkedList<IConfigurationElement>)this.pages.get(string);
                if (linkedList == null) {
                    linkedList = new LinkedList<IConfigurationElement>();
                }
                linkedList.add(iConfigurationElement);
                this.pages.put(string, linkedList);
            }
            ++n;
        }
    }

    public static IWizardPage[] getPages(String string) {
        final List list = (List)PHPWizardPagesRegistry.instance.pages.get(string);
        if (list != null) {
            final LinkedList linkedList = new LinkedList();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(String.valueOf(PHPUIMessages.getString("PHPWizardPagesRegistry.0")) + EXTENSION_POINT){

                public void run() throws Exception {
                    for (IConfigurationElement iConfigurationElement : list) {
                        linkedList.add(iConfigurationElement.createExecutableExtension(PHPWizardPagesRegistry.CLASS_ATTRIBUTE));
                    }
                }
            });
            return linkedList.toArray(new IWizardPage[linkedList.size()]);
        }
        return null;
    }

    public static WizardPageFactory[] getPageFactories(String string) {
        final List list = (List)PHPWizardPagesRegistry.instance.pages.get(string);
        if (list != null) {
            final LinkedList linkedList = new LinkedList();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(String.valueOf(PHPUIMessages.getString("PHPWizardPagesRegistry.0")) + EXTENSION_POINT){

                public void run() throws Exception {
                    for (IConfigurationElement iConfigurationElement : list) {
                        linkedList.add(iConfigurationElement.createExecutableExtension(PHPWizardPagesRegistry.CLASS_ATTRIBUTE));
                    }
                }
            });
            return linkedList.toArray(new WizardPageFactory[linkedList.size()]);
        }
        return null;
    }
}

