/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassConstantDeclaration
extends Statement {
    private final Identifier[] variableNames;
    private final Expression[] constantValues;

    public ClassConstantDeclaration(int n, int n2, List list) {
        super(n, n2);
        assert (list != null && list.size() > 0);
        this.variableNames = new Identifier[list.size()];
        this.constantValues = new Expression[list.size()];
        int n3 = 0;
        for (ASTNode[] aSTNodeArray : list) {
            this.variableNames[n3] = (Identifier)aSTNodeArray[0];
            this.constantValues[n3] = (Expression)aSTNodeArray[1];
            aSTNodeArray[0].setParent(this);
            aSTNodeArray[1].setParent(this);
            ++n3;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int n = 0;
        while (n < this.variableNames.length) {
            this.variableNames[n].accept(visitor);
            this.constantValues[n].accept(visitor);
            ++n;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int n = 0;
        while (n < this.variableNames.length) {
            this.variableNames[n].traverseTopDown(visitor);
            this.constantValues[n].traverseTopDown(visitor);
            ++n;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        int n = 0;
        while (n < this.variableNames.length) {
            this.variableNames[n].traverseBottomUp(visitor);
            this.constantValues[n].traverseBottomUp(visitor);
            ++n;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<ClassConstantDeclaration");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        int n = 0;
        while (n < this.variableNames.length) {
            stringBuffer.append(string).append("\t").append("<VariableName>\n");
            this.variableNames[n].toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
            stringBuffer.append(string).append("\t").append("</VariableName>\n");
            stringBuffer.append(string).append("\t").append("<InitialValue>\n");
            Expression expression = this.constantValues[n];
            if (expression != null) {
                expression.toString(stringBuffer, "\t\t" + string);
                stringBuffer.append("\n");
            }
            stringBuffer.append(string).append("\t").append("</InitialValue>\n");
            ++n;
        }
        stringBuffer.append(string).append("</ClassConstantDeclaration>");
    }

    public int getType() {
        return 11;
    }

    public Expression[] getConstantValues() {
        return this.constantValues;
    }

    public Identifier[] getVariableNames() {
        return this.variableNames;
    }
}

