/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.parser.PhpAstLexer4;
import org.eclipse.php.internal.core.ast.parser.PhpAstLexer5;
import org.eclipse.php.internal.core.ast.parser.PhpAstParser4;
import org.eclipse.php.internal.core.ast.parser.PhpAstParser5;
import org.eclipse.php.internal.core.phpModel.javacup.runtime.Scanner;
import org.eclipse.php.internal.core.phpModel.javacup.runtime.Symbol;
import org.eclipse.php.internal.core.phpModel.javacup.runtime.lr_parser;

public class ASTParser {
    public static final String VERSION_PHP4 = "php4";
    public static final String VERSION_PHP5 = "php5";
    private static final PhpAstParser5 PHP_AST_PARSER5 = new PhpAstParser5();
    private static final PhpAstLexer5 PHP_AST_LEXER5 = new PhpAstLexer5(EMPTY_STRING_READER);
    private static final PhpAstParser4 PHP_AST_PARSER4 = new PhpAstParser4();
    private static final PhpAstLexer4 PHP_AST_LEXER4 = new PhpAstLexer4(EMPTY_STRING_READER);
    private static final StringReader EMPTY_STRING_READER = new StringReader("");

    public static final Program parse(String string, boolean bl) throws Exception {
        StringReader stringReader = new StringReader(string);
        return ASTParser.parse(stringReader, bl, VERSION_PHP5);
    }

    public static final Program parse(File file, boolean bl) throws Exception {
        FileReader fileReader = new FileReader(file);
        return ASTParser.parse(fileReader, bl, VERSION_PHP5);
    }

    public static final Program parse(IDocument iDocument, boolean bl, String string) throws Exception {
        return ASTParser.parse(iDocument, bl, string, 0, iDocument.getLength());
    }

    public static final Program parse(final IDocument iDocument, boolean bl, String string, int n, int n2) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(new InputStream(n, n2){
            private int index;
            private final int size;
            {
                this.index = n;
                this.size = n + n2;
            }

            public int read() throws IOException {
                try {
                    if (this.index < this.size) {
                        return iDocument.getChar(this.index++);
                    }
                    return -1;
                }
                catch (BadLocationException badLocationException) {
                    throw new IOException(badLocationException.getMessage());
                }
            }
        });
        return ASTParser.parse(inputStreamReader, bl, string);
    }

    public static final Program parse(IDocument iDocument, boolean bl) throws Exception {
        return ASTParser.parse(iDocument, bl, VERSION_PHP5);
    }

    public static final Program parse(String string) throws Exception {
        return ASTParser.parse(string, true);
    }

    public static final Program parse(File file) throws Exception {
        return ASTParser.parse(file, true);
    }

    public static final Program parse(Reader reader) throws Exception {
        return ASTParser.parse(reader, true, VERSION_PHP5);
    }

    public static Program parse(Reader reader, boolean bl, String string) throws Exception {
        Scanner scanner = ASTParser.getLexer(reader, string, bl);
        lr_parser lr_parser2 = ASTParser.getParser(string);
        lr_parser2.setScanner(scanner);
        Symbol symbol2 = lr_parser2.parse();
        return symbol2 == null ? null : (Program)symbol2.value;
    }

    private static Scanner getLexer(Reader reader, String string, boolean bl) throws IOException {
        if (VERSION_PHP4.equals(string)) {
            PhpAstLexer4 phpAstLexer4 = ASTParser.getLexer4(reader);
            phpAstLexer4.setUseAspTagsAsPhp(bl);
            return phpAstLexer4;
        }
        if (VERSION_PHP5.equals(string)) {
            PhpAstLexer5 phpAstLexer5 = ASTParser.getLexer5(reader);
            phpAstLexer5.setUseAspTagsAsPhp(bl);
            return phpAstLexer5;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + string);
    }

    private static lr_parser getParser(String string) {
        if (VERSION_PHP4.equals(string)) {
            return PHP_AST_PARSER4;
        }
        if (VERSION_PHP5.equals(string)) {
            return PHP_AST_PARSER5;
        }
        throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("ASTParser_1")) + string);
    }

    private static PhpAstLexer5 getLexer5(Reader reader) throws IOException {
        PhpAstLexer5 phpAstLexer5 = PHP_AST_LEXER5;
        phpAstLexer5.yyreset(reader);
        phpAstLexer5.resetCommentList();
        return phpAstLexer5;
    }

    private static PhpAstLexer4 getLexer4(Reader reader) throws IOException {
        PhpAstLexer4 phpAstLexer4 = PHP_AST_LEXER4;
        phpAstLexer4.yyreset(reader);
        phpAstLexer4.resetCommentList();
        return phpAstLexer4;
    }
}

