/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPLaunchUtilities {
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    public static final String ID_PHPBrowserOutput = "org.eclipse.debug.ui.PHPBrowserOutput";
    private static DebuggerDelayProgressMonitorDialog progressDialog;

    public static void showDebugView() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        if (!preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS)) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (iWorkbenchPage != null) {
                    try {
                        IViewPart iViewPart = iWorkbenchPage.findView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        IViewPart iViewPart2 = iWorkbenchPage.findView(PHPLaunchUtilities.ID_PHPBrowserOutput);
                        boolean bl = false;
                        if (iViewPart == null || !iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart)) {
                            bl = true;
                        }
                        if (iViewPart2 != null && iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart2)) {
                            bl = false;
                        }
                        if (bl) {
                            iWorkbenchPage.showView(PHPLaunchUtilities.ID_PHPDebugOutput);
                        }
                    }
                    catch (Exception exception) {
                        Logger.logException("Error switching to the Debug Output view", exception);
                    }
                }
            }
        });
    }

    public static boolean hasPHPDebugLaunch() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = 0;
        while (n < iLaunchArray.length) {
            if (!iLaunchArray[n].isTerminated() && "debug".equals(iLaunchArray[n].getLaunchMode()) && iLaunchArray[n].getDebugTarget() instanceof PHPDebugTarget) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean notifyPreviousLaunches(ILaunch iLaunch) throws CoreException {
        if (!"debug".equals(iLaunch.getLaunchMode())) {
            return true;
        }
        if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
            return true;
        }
        final IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("allowMultipleLaunches");
        if ("always".equals(string)) {
            return true;
        }
        if ("never".equals(string)) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_phpLaunchTitle, (String)PHPDebugCoreMessages.PHPLaunchUtilities_activeLaunchDetected);
                }
            });
            return false;
        }
        final DialogResultHolder dialogResultHolder = new DialogResultHolder();
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)PHPDebugCoreMessages.PHPLaunchUtilities_multipleLaunchesPrompt, (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)iPreferenceStore, (String)"allowMultipleLaunches");
                dialogResultHolder.setReturnCode(messageDialogWithToggle.getReturnCode());
            }
        });
        switch (dialogResultHolder.getReturnCode()) {
            case 0: 
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public static void switchToPHPPerspective() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                String string = "org.eclipse.php.perspective";
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (PHPLaunchUtilities.shouldSwitchToPHPPerspective(string)) {
                    try {
                        iWorkbench.showPerspective(string, iWorkbenchWindow);
                    }
                    catch (WorkbenchException workbenchException) {
                        PHPUiPlugin.log((Throwable)workbenchException);
                    }
                }
            }
        });
    }

    private static boolean shouldSwitchToPHPPerspective(String string) {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString("switchBackToPHPPerspective");
        if ("always".equals(string2)) {
            return true;
        }
        if ("never".equals(string2)) {
            return false;
        }
        IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveRegistry.findPerspectiveWithId(string);
        if (iPerspectiveDescriptor == null) {
            return false;
        }
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            IPerspectiveDescriptor iPerspectiveDescriptor2;
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            if (iWorkbenchPage != null && (iPerspectiveDescriptor2 = iWorkbenchPage.getPerspective()) != null && iPerspectiveDescriptor2.getId().equals(string)) {
                return false;
            }
            iPerspectiveDescriptor2 = MessageDialogWithToggle.openYesNoQuestion((Shell)iWorkbenchWindow.getShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchTitle, (String)NLS.bind((String)PHPDebugCoreMessages.PHPLaunchUtilities_PHPPerspectiveSwitchMessage, (Object[])new String[]{iPerspectiveDescriptor.getLabel()}), (String)PHPDebugCoreMessages.PHPLaunchUtilities_rememberDecision, (boolean)false, (IPreferenceStore)iPreferenceStore, (String)"switchBackToPHPPerspective");
            int n = iPerspectiveDescriptor2.getReturnCode();
            switch (n) {
                case 0: 
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean checkDebugAllPages(ILaunchConfiguration iLaunchConfiguration, final ILaunch iLaunch) throws CoreException {
        if (PHPDebugPlugin.supportsMultipleDebugAllPages()) {
            return true;
        }
        iLaunch.setAttribute("debugPages", iLaunchConfiguration.getAttribute("debugPages", "debugAllPages"));
        PHPLaunchUtilities.checkAutoRemoveLaunches();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        boolean bl = false;
        int n = 0;
        while (!bl && n < iLaunchArray.length) {
            ILaunch iLaunch2 = iLaunchArray[n];
            if (iLaunch2 != iLaunch && "debug".equals(iLaunch2.getLaunchMode()) && (PHPLaunchUtilities.isDebugAllPages(iLaunch2) || PHPLaunchUtilities.isStartDebugFrom(iLaunch2))) {
                bl = true;
            }
            ++n;
        }
        n = "debug".equals(iLaunch.getLaunchMode()) ? 1 : 0;
        final boolean bl2 = n != 0 && PHPLaunchUtilities.isDebugAllPages(iLaunch);
        boolean bl3 = n != 0 && PHPLaunchUtilities.isStartDebugFrom(iLaunch);
        final boolean bl4 = bl;
        if ((bl4 || bl2 || bl3) && iLaunchArray.length > 1) {
            final DialogResultHolder dialogResultHolder = new DialogResultHolder();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (bl4) {
                        dialogResultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"A previous launch with 'Debug All Pages' or 'Start Debug From' attribute was identifed.\nLaunching a new session will terminate and remove the old launch, directing all future debug requests associated with it to the new launch.\nDo you wish to continue and launch a new session?"));
                    } else if (bl2) {
                        dialogResultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"The requested launch has a 'Debug All Pages' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?"));
                    } else {
                        dialogResultHolder.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.PHPLaunchUtilities_confirmation, (String)"The requested launch has a 'Start Debug From' attribute.\nLaunching this type of session will terminate and remove any other previous launches.\nDo you wish to continue and launch the new session?"));
                    }
                    if (dialogResultHolder.getResult()) {
                        PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
                        PHPLaunchUtilities.removeAndTerminateOldLaunches(iLaunch);
                    } else {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                    }
                }
            });
            return dialogResultHolder.getResult();
        }
        if (bl2 || bl3) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(true);
        } else {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(!PHPDebugPlugin.getDefault().getInitialAutoRemoveLaunches());
            DebugUIPlugin.getDefault().getLaunchConfigurationManager().launchAdded(iLaunch);
        }
        return true;
    }

    private static void checkAutoRemoveLaunches() {
        if (DebugPlugin.getDefault().getLaunchManager().getLaunches().length == 1) {
            PHPDebugPlugin.setDisableAutoRemoveLaunches(false);
        }
    }

    public static boolean isDebugAllPages(ILaunch iLaunch) throws CoreException {
        String string = iLaunch.getAttribute("debugPages");
        return string != null && string.equals("debugAllPages");
    }

    public static boolean isStartDebugFrom(ILaunch iLaunch) throws CoreException {
        String string = iLaunch.getAttribute("debugPages");
        return string != null && string.equals("debugFrom");
    }

    private static void removeAndTerminateOldLaunches(ILaunch iLaunch) {
        ILaunch[] iLaunchArray;
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray2 = iLaunchArray = iLaunchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch iLaunch2 = iLaunchArray2[n2];
            ILaunch iLaunch3 = iLaunch2;
            if (iLaunch3 != iLaunch) {
                if (!iLaunch3.isTerminated()) {
                    try {
                        iLaunch3.terminate();
                    }
                    catch (DebugException debugException) {
                        Logger.logException(debugException);
                    }
                }
                iLaunchManager.removeLaunch(iLaunch3);
            }
            ++n2;
        }
    }

    public static void showWaitForDebuggerMessage(final DebugConnectionThread debugConnectionThread) {
        if (progressDialog != null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                progressDialog = new DebuggerDelayProgressMonitorDialog();
                if (progressDialog.open() == 1) {
                    debugConnectionThread.closeConnection();
                }
                progressDialog = null;
            }
        });
    }

    public static void hideWaitForDebuggerMessage() {
        if (progressDialog != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (progressDialog != null) {
                        progressDialog.close();
                    }
                }
            });
            progressDialog = null;
        }
    }

    public static void showLaunchErrorMessage() {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, PHPDebugCoreMessages.Debugger_Error_Message);
    }

    public static void showLaunchErrorMessage(String string) {
        PHPLaunchUtilities.showDebuggerErrorMessage(PHPDebugCoreMessages.Debugger_Launch_Error, string);
    }

    public static void showDebuggerErrorMessage(final String string, final String string2) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)string, (String)string2);
            }
        });
    }

    public static void openLaunchConfigurationDialog(final ILaunchConfiguration iLaunchConfiguration, final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String string2;
                ILaunchConfiguration iLaunchConfiguration3 = iLaunchConfiguration;
                try {
                    ILaunchConfiguration iLaunchConfiguration2;
                    string2 = iLaunchConfiguration.getAttribute(DebugUIPlugin.ATTR_LAUNCHING_CONFIG_HANDLE, "");
                    if (string2.length() > 0 && (iLaunchConfiguration2 = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(string2)) != null) {
                        iLaunchConfiguration3 = iLaunchConfiguration2;
                    }
                }
                catch (CoreException coreException) {}
                if ((string2 = DebugUITools.getLaunchGroup((ILaunchConfiguration)iLaunchConfiguration3, (String)string)) != null) {
                    DebugUITools.openLaunchConfigurationDialog((Shell)Display.getDefault().getActiveShell(), (ILaunchConfiguration)iLaunchConfiguration3, (String)string2.getIdentifier(), null);
                }
            }
        });
    }

    public static String[] getEnvironment(ILaunchConfiguration iLaunchConfiguration, String[] stringArray) throws CoreException {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Map<String, String> map = PHPLaunchUtilities.asAttributesMap(stringArray);
        String[] stringArray2 = null;
        String[] stringArray3 = DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
        if (stringArray3 != null) {
            Map<String, String> map2 = PHPLaunchUtilities.asAttributesMap(stringArray3);
            map.putAll(map2);
            stringArray2 = PHPLaunchUtilities.asAttributesArray(map);
        } else {
            Map map3 = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
            map3.putAll(map);
            stringArray2 = PHPLaunchUtilities.asAttributesArray(map3);
        }
        return stringArray2;
    }

    private static Map<String, String> asAttributesMap(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray == null) {
            return hashMap;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            try {
                int n3 = string.indexOf(61);
                hashMap.put(string.substring(0, n3), string.substring(n3 + 1));
            }
            catch (Exception exception) {
                Logger.logException("Error while parsing launch attribute '" + string + '\'', exception);
            }
            ++n2;
        }
        return hashMap;
    }

    private static String[] asAttributesArray(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return stringArray;
    }

    public static Map<String, String> getPHPCGILaunchEnvironment(String string, String string2, String string3, String string4, String[] stringArray) {
        String string5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("REQUEST_METHOD", "GET");
        hashMap.put("SCRIPT_FILENAME", string);
        hashMap.put("SCRIPT_NAME", string);
        hashMap.put("PATH_TRANSLATED", string);
        hashMap.put("PATH_INFO", string);
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append("&debug_host=127.0.0.1");
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string5 = stringArray2[n2];
                stringBuilder.append('&').append(string5);
                ++n2;
            }
        }
        hashMap.put("QUERY_STRING", stringBuilder.toString());
        hashMap.put("REDIRECT_STATUS", "1");
        hashMap.put("PHPRC", string3);
        string5 = System.getProperty("os.name");
        if (!string5.startsWith("Win")) {
            if (string5.startsWith("Mac")) {
                hashMap.put("DYLD_LIBRARY_PATH", string4);
            } else {
                hashMap.put("LD_LIBRARY_PATH", string4);
            }
        }
        return hashMap;
    }

    public static String[] getCommandLine(ILaunchConfiguration iLaunchConfiguration, String string, String string2, String string3, String[] stringArray) throws CoreException {
        String string4 = PHPLaunchUtilities.isUsingASPTags(PHPLaunchUtilities.getProject(iLaunchConfiguration)) ? "on" : "off";
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(Arrays.asList(string, "-c", string2, "-d", "asp_tags=" + string4, string3));
        if (stringArray != null) {
            linkedList.addAll(Arrays.asList(stringArray));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private static IProject getProject(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(string);
            IResource iResource = iWorkspaceRoot.findMember((IPath)path);
            if (iResource != null) {
                return iResource.getProject();
            }
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
        }
        return null;
    }

    public static String[] getProgramArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = iLaunchConfiguration.getAttribute("exeDebugArguments", null);
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(string).split(" ");
    }

    public static boolean isUsingASPTags(IProject iProject) {
        PreferencesSupport preferencesSupport = new PreferencesSupport(PHPCorePlugin.getPluginId(), PHPCorePlugin.getDefault().getPreferenceStore());
        String string = preferencesSupport.getPreferencesValue("use_asp_tags_as_php", null, iProject);
        if (string == null) {
            string = preferencesSupport.getWorkspacePreferencesValue("use_asp_tags_as_php");
        }
        return Boolean.valueOf(string);
    }

    private static class DebuggerDelayProgressMonitorDialog
    extends ProgressMonitorDialog {
        public DebuggerDelayProgressMonitorDialog() {
            super(null);
            this.setBlockOnOpen(true);
            this.setCancelable(true);
        }

        protected void createCancelButton(Composite composite) {
            this.cancel = this.createButton(composite, 1, PHPDebugCoreMessages.PHPLaunchUtilities_terminate, true);
            if (this.arrowCursor == null) {
                this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
            }
            this.cancel.setCursor(this.arrowCursor);
            this.setOperationCancelButtonEnabled(this.enableCancelButton);
        }

        protected Control createDialogArea(Composite composite) {
            Control control = super.createDialogArea(composite);
            this.getProgressMonitor().beginTask(PHPDebugCoreMessages.PHPLaunchUtilities_waitingForDebugger, -1);
            return control;
        }
    }

    private static class DialogResultHolder {
        private int returnCode;
        private boolean result;

        private DialogResultHolder() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean bl) {
            this.result = bl;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public void setReturnCode(int n) {
            this.returnCode = n;
        }
    }
}

