/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceInit;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpPreferences;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.IDBGpDebugTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.TimedEvent;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;

public class DBGpMultiSessionTarget
extends DBGpElement
implements IDBGpDebugTarget,
IDBGpSessionListener,
IDebugEventSetListener {
    private String sessionID;
    private String ideKey;
    private boolean webLaunch = false;
    private IProcess process;
    private IWebBrowser browser;
    private String stopDebugURL;
    private volatile int targetState;
    private static final int STATE_INIT_SESSION_WAIT = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_TERMINATING = 2;
    private static final int STATE_TERMINATED = 3;
    private String scriptName;
    private ILaunch launch;
    private DBGpBreakpointFacade bpFacade;
    private DBGpPreferences sessionPreferences;
    private TimedEvent te = new TimedEvent();
    private boolean stopAtStart;
    private ArrayList<DBGpTarget> debugTargets = new ArrayList();
    private PathMapper pathMapper;

    private DBGpMultiSessionTarget() {
        super(null);
        this.ideKey = DBGpSessionHandler.getInstance().getIDEKey();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fireCreationEvent();
        this.targetState = 0;
    }

    public DBGpMultiSessionTarget(ILaunch iLaunch, String string, String string2, String string3, boolean bl) throws CoreException {
        this();
        this.stopAtStart = bl;
        this.launch = iLaunch;
        this.scriptName = string;
        this.ideKey = string2;
        this.webLaunch = false;
        this.sessionID = string3;
        this.process = null;
        this.stopDebugURL = null;
        this.browser = null;
    }

    public DBGpMultiSessionTarget(ILaunch iLaunch, String string, String string2, String string3, boolean bl, IWebBrowser iWebBrowser) {
        this();
        this.stopAtStart = bl;
        this.launch = iLaunch;
        this.scriptName = string;
        this.ideKey = string3;
        this.webLaunch = true;
        this.sessionID = null;
        this.stopDebugURL = string2;
        this.browser = iWebBrowser;
        this.process = null;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getName() throws DebugException {
        return "MultiSession Manager";
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void setProcess(IProcess iProcess) {
        this.process = iProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return new IThread[0];
    }

    public boolean hasThreads() throws DebugException {
        return false;
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        IDebugTarget iDebugTarget = this.debugTargets.get(0);
        return iDebugTarget.supportsBreakpoint(iBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        boolean bl = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.debugTargets.size() && !bl) {
                IDebugTarget iDebugTarget = this.debugTargets.get(n);
                bl |= iDebugTarget.isSuspended();
                ++n;
            }
        }
        return bl;
    }

    public boolean isTerminated() {
        return this.targetState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        if (this.targetState == 2) {
            ArrayList<DBGpTarget> arrayList = this.debugTargets;
            synchronized (arrayList) {
                if (this.debugTargets.size() > 0) {
                    int n = 0;
                    while (n < this.debugTargets.size()) {
                        IDebugTarget iDebugTarget = this.debugTargets.get(n);
                        try {
                            iDebugTarget.terminate();
                        }
                        catch (Exception exception) {}
                        ++n;
                    }
                }
                this.terminateMultiSessionDebugTarget();
            }
            return;
        }
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            this.targetState = 2;
            if (this.debugTargets.size() > 0) {
                int n = 0;
                while (n < this.debugTargets.size()) {
                    IDebugTarget iDebugTarget = this.debugTargets.get(n);
                    if (iDebugTarget.canTerminate()) {
                        iDebugTarget.terminate();
                    }
                    ++n;
                }
            } else {
                this.terminateMultiSessionDebugTarget();
            }
        }
    }

    public boolean canDisconnect() {
        boolean bl = false;
        return bl;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean canTerminate() {
        boolean bl = this.targetState == 1 || this.targetState == 0;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canResume() {
        boolean bl = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.debugTargets.size() && !bl) {
                IDebugTarget iDebugTarget = this.debugTargets.get(n);
                bl |= iDebugTarget.canResume();
                ++n;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canSuspend() {
        boolean bl = false;
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.debugTargets.size() && !bl) {
                IDebugTarget iDebugTarget = this.debugTargets.get(n);
                bl |= iDebugTarget.canSuspend();
                ++n;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.debugTargets.size()) {
                IDebugTarget iDebugTarget = this.debugTargets.get(n);
                if (iDebugTarget.canResume()) {
                    iDebugTarget.resume();
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.debugTargets.size()) {
                IDebugTarget iDebugTarget = this.debugTargets.get(n);
                if (iDebugTarget.canSuspend()) {
                    iDebugTarget.suspend();
                }
                ++n;
            }
        }
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    private boolean isTerminating() {
        boolean bl = this.targetState == 3 || this.targetState == 2;
        return bl;
    }

    public void waitForInitialSession(DBGpBreakpointFacade dBGpBreakpointFacade, DBGpPreferences dBGpPreferences, IProgressMonitor iProgressMonitor) {
        this.bpFacade = dBGpBreakpointFacade;
        this.sessionPreferences = dBGpPreferences;
        try {
            while (!(this.debugTargets.size() != 0 || this.launch.isTerminated() || this.isTerminating() || iProgressMonitor.isCanceled())) {
                this.te.waitForEvent(XDebugPreferenceInit.getTimeoutDefault());
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.debugTargets.size() == 0) {
            DBGpSessionHandler.getInstance().removeSessionListener(this);
            this.terminateMultiSessionDebugTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SessionCreated(DBGpSession dBGpSession) {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            DBGpTarget dBGpTarget = new DBGpTarget(this.launch, this.scriptName, this.ideKey, this.sessionID, this.stopAtStart);
            dBGpTarget.setPathMapper(this.pathMapper);
            dBGpTarget.SessionCreated(dBGpSession);
            dBGpTarget.waitForInitialSession(this.bpFacade, this.sessionPreferences, null);
            if (!dBGpTarget.isTerminated()) {
                if (this.targetState == 0) {
                    this.targetState = 1;
                    this.te.signalEvent();
                }
                this.debugTargets.add(dBGpTarget);
                this.launch.addDebugTarget((IDebugTarget)dBGpTarget);
            }
        }
        return true;
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        ArrayList<DBGpTarget> arrayList = this.debugTargets;
        synchronized (arrayList) {
            int n = 0;
            while (n < debugEventArray.length) {
                int n2;
                DebugEvent debugEvent = debugEventArray[n];
                Object object = debugEvent.getSource();
                if (object instanceof DBGpTarget && this.debugTargets.contains(object) && (n2 = debugEvent.getKind()) == 8) {
                    this.launch.removeDebugTarget((IDebugTarget)object);
                    this.debugTargets.remove(object);
                }
                ++n;
            }
            if (this.targetState == 2 && this.debugTargets.size() == 0) {
                this.terminateMultiSessionDebugTarget();
            }
        }
    }

    private void terminateMultiSessionDebugTarget() {
        if (this.webLaunch) {
            this.sendStopDebugURL();
        }
        this.targetState = 3;
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.fireTerminateEvent();
    }

    private void sendStopDebugURL() {
        if (this.stopDebugURL == null) {
            return;
        }
        try {
            if (this.browser != null) {
                DBGpLogger.debug("browser is not null, sending " + this.stopDebugURL);
                this.browser.openURL(new URL(this.stopDebugURL));
            } else {
                DBGpUtils.openInternalBrowserView(this.stopDebugURL);
            }
        }
        catch (PartInitException partInitException) {
            DBGpLogger.logException("Failed to send stop URL: " + this.stopDebugURL, this, partInitException);
        }
        catch (MalformedURLException malformedURLException) {
            DBGpLogger.logException(null, this, malformedURLException);
        }
    }

    public void setPathMapper(PathMapper pathMapper) {
        this.pathMapper = pathMapper;
    }

    public boolean isWebLaunch() {
        return this.webLaunch;
    }
}

