/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.IGenerator;
import org.eclipse.jpt.core.internal.mappings.IId;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorComposite<E extends IGenerator>
extends BaseJpaComposite {
    private IId id;
    private E generator;
    private Adapter generatorListener = this.buildGeneratorListner();
    protected Text nameTextWidget;

    public GeneratorComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildGeneratorListner() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                GeneratorComposite.this.generatorChanged(notification);
            }
        };
    }

    protected Text buildNameText(Composite parent) {
        final Text text = this.getWidgetFactory().createText(parent, null);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object generator;
                if (GeneratorComposite.this.isPopulating()) {
                    return;
                }
                String name = text.getText();
                if (name.equals("")) {
                    if (GeneratorComposite.this.getGenerator().getName() == null) {
                        return;
                    }
                    name = null;
                }
                if ((generator = GeneratorComposite.this.getGenerator()) == null) {
                    generator = GeneratorComposite.this.createGenerator();
                }
                generator.setName(name);
            }
        });
        return text;
    }

    protected abstract E createGenerator();

    @Override
    protected void doPopulate(EObject obj) {
        this.id = (IId)obj;
        if (this.id == null) {
            this.generator = null;
            return;
        }
        this.generator = this.generator(this.id);
        if (this.generator == null) {
            this.clear();
            return;
        }
        this.populateNameViewer();
    }

    @Override
    protected void doPopulate() {
        this.populateNameViewer();
    }

    @Override
    protected void engageListeners() {
        if (this.generator != null) {
            this.generator.eAdapters().add((Object)this.generatorListener);
        }
    }

    @Override
    protected void disengageListeners() {
        if (this.generator != null) {
            this.generator.eAdapters().remove((Object)this.generatorListener);
        }
    }

    protected abstract E generator(IId var1);

    protected IId idMapping() {
        return this.id;
    }

    protected void generatorChanged(Notification notification) {
        if (notification.getFeatureID(IGenerator.class) == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (GeneratorComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    if (GeneratorComposite.this.nameTextWidget.getText() == null || !GeneratorComposite.this.nameTextWidget.getText().equals(GeneratorComposite.this.getGenerator().getName())) {
                        if (GeneratorComposite.this.getGenerator().getName() == null) {
                            GeneratorComposite.this.clearNameViewer();
                        } else {
                            GeneratorComposite.this.nameTextWidget.setText(GeneratorComposite.this.getGenerator().getName());
                        }
                    }
                }
            });
        }
    }

    private void populateNameViewer() {
        String name = this.getGenerator().getName();
        if (name != null) {
            if (!this.nameTextWidget.getText().equals(name)) {
                this.nameTextWidget.setText(name);
            }
        } else {
            this.clearNameViewer();
        }
    }

    protected E getGenerator() {
        return this.generator;
    }

    protected void clear() {
        this.clearNameViewer();
    }

    protected void clearNameViewer() {
        this.nameTextWidget.setText("");
    }
}

