/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.ui.actions.IRenamePHPElementActionFactory;

public class PHPActionDelegatorRegistry {
    private static final String EXTENSION_POINT = "org.eclipse.php.ui.phpActionDelegator";
    private static final String ACTION_ELEMENT = "action";
    private static final String ACTION_ID_ATTRIBUTE = "actionId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private Map actionDelegators = new HashMap();
    private static PHPActionDelegatorRegistry instance = new PHPActionDelegatorRegistry();

    private PHPActionDelegatorRegistry() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (ACTION_ELEMENT.equals(iConfigurationElement.getName())) {
                String string = iConfigurationElement.getAttribute(ACTION_ID_ATTRIBUTE);
                LinkedList<IConfigurationElement> linkedList = (LinkedList<IConfigurationElement>)this.actionDelegators.get(string);
                if (linkedList == null) {
                    linkedList = new LinkedList<IConfigurationElement>();
                }
                linkedList.add(iConfigurationElement);
                this.actionDelegators.put(string, linkedList);
            }
            ++n;
        }
    }

    public static IPHPActionDelegator getActionDelegator(String string) {
        List list = (List)PHPActionDelegatorRegistry.instance.actionDelegators.get(string);
        IPHPActionDelegator iPHPActionDelegator = null;
        if (list != null) {
            int n = 0;
            for (IConfigurationElement iConfigurationElement : list) {
                int n2 = Integer.valueOf(iConfigurationElement.getAttribute(PRIORITY_ATTRIBUTE));
                if (n2 <= n) continue;
                try {
                    iPHPActionDelegator = (IPHPActionDelegator)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                    n = n2;
                }
                catch (CoreException coreException) {
                    Logger.logException((String)(String.valueOf(PHPUIMessages.getString("PHPActionDelegatorRegistry.0")) + iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)coreException);
                }
            }
        }
        return iPHPActionDelegator;
    }

    public static IRenamePHPElementActionFactory getActionDelegatorFactory(String string) {
        List list = (List)PHPActionDelegatorRegistry.instance.actionDelegators.get(string);
        IRenamePHPElementActionFactory iRenamePHPElementActionFactory = null;
        if (list != null) {
            int n = 0;
            for (IConfigurationElement iConfigurationElement : list) {
                int n2 = Integer.valueOf(iConfigurationElement.getAttribute(PRIORITY_ATTRIBUTE));
                if (n2 <= n) continue;
                try {
                    iRenamePHPElementActionFactory = (IRenamePHPElementActionFactory)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                    n = n2;
                }
                catch (CoreException coreException) {
                    Logger.logException((String)(String.valueOf(PHPUIMessages.getString("PHPActionDelegatorRegistry.1")) + iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)coreException);
                }
            }
        }
        return iRenamePHPElementActionFactory;
    }
}

