/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextLineBreakingReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPStructuredTextAnnotationHover
extends StructuredTextAnnotationHover {
    private HTMLPrinter printer = new HTMLPrinter();

    private int compareRulerLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int n2;
            block5: {
                try {
                    n2 = iDocument.getLineOfOffset(position.getOffset());
                    if (n != n2) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (n2 <= n && n <= iDocument.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    private String formatHoverText(String string, ISourceViewer iSourceViewer) {
        String string2 = null;
        String string3 = new String();
        try {
            string3 = iSourceViewer.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        Display display = iSourceViewer.getTextWidget().getDisplay();
        string = StringUtils.convertToHTMLContent((String)string);
        StringReader stringReader = new StringReader(string);
        GC gC = new GC((Drawable)display);
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                StructuredTextLineBreakingReader structuredTextLineBreakingReader = new StructuredTextLineBreakingReader((Reader)stringReader, gC, this.getHoverWidth(display));
                String string4 = structuredTextLineBreakingReader.readLine();
                while (string4 != null) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append(string4);
                    string4 = structuredTextLineBreakingReader.readLine();
                }
                string2 = stringBuffer.toString();
            }
            catch (IOException iOException) {
                Logger.logException((Throwable)iOException);
                gC.dispose();
            }
        }
        finally {
            gC.dispose();
        }
        return string2;
    }

    private String formatMultipleHoverText(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        this.printer.addPageProlog(stringBuffer);
        this.printer.addParagraph(stringBuffer, SSEUIMessages.Multiple_errors);
        this.printer.startBulletList(stringBuffer);
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.printer.addBullet(stringBuffer, this.printer.convertToHTMLContent(iterator.next()));
        }
        this.printer.endBulletList(stringBuffer);
        this.printer.addPageEpilog(stringBuffer);
        return stringBuffer.toString();
    }

    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        List<String> list = this.getMarkerMessages(iSourceViewer, n);
        List<ITemporaryAnnotation> list2 = this.getTemporaryAnnotationsForLine(iSourceViewer, n);
        int n2 = 0;
        while (n2 < list2.size()) {
            String string = ((Annotation)list2.get(n2)).getText();
            if (string != null) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < list.size()) {
                    bl = bl || list.get(n3).equals(string);
                    ++n3;
                }
                if (!bl) {
                    list.add(string);
                }
            } else {
                list.add(list2.get(n2).toString());
            }
            ++n2;
        }
        if (list.size() > 1) {
            return this.formatMultipleHoverText(list);
        }
        if (list.size() > 0) {
            return this.formatHoverText(list.get(0).toString(), iSourceViewer);
        }
        return null;
    }

    private int getHoverWidth(Display display) {
        Rectangle rectangle = display.getBounds();
        int n = rectangle.width - (display.getCursorLocation().x - rectangle.x);
        if ((n -= 12) < 200) {
            n = 200;
        }
        return n;
    }

    private List<String> getMarkerMessages(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iAnnotationModel == null) {
            return arrayList;
        }
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            IMarker iMarker;
            String string;
            MarkerAnnotation markerAnnotation;
            Object e = iterator.next();
            if (!(e instanceof MarkerAnnotation) || this.compareRulerLine(iAnnotationModel.getPosition((Annotation)(markerAnnotation = (MarkerAnnotation)e)), iDocument, n) != 1 || (string = (iMarker = markerAnnotation.getMarker()).getAttribute("message", null)) == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<ITemporaryAnnotation> getTemporaryAnnotationsForLine(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel == null) {
            return null;
        }
        ArrayList<ITemporaryAnnotation> arrayList = new ArrayList<ITemporaryAnnotation>();
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            ITemporaryAnnotation iTemporaryAnnotation;
            Position position;
            Object e = iterator.next();
            if (!(e instanceof ITemporaryAnnotation) || (position = iAnnotationModel.getPosition((Annotation)(iTemporaryAnnotation = (ITemporaryAnnotation)e))) == null || this.compareRulerLine(position, iDocument, n) != 1) continue;
            arrayList.add(iTemporaryAnnotation);
        }
        return arrayList;
    }

    class HTMLPrinter {
        HTMLPrinter() {
        }

        void addBullet(StringBuffer stringBuffer, String string) {
            if (string != null) {
                stringBuffer.append("<li>");
                stringBuffer.append(string);
                stringBuffer.append("</li>");
            }
        }

        void addPageEpilog(StringBuffer stringBuffer) {
            stringBuffer.append("</font></body></html>");
        }

        void addPageProlog(StringBuffer stringBuffer) {
            this.insertPageProlog(stringBuffer, stringBuffer.length());
        }

        void addParagraph(StringBuffer stringBuffer, Reader reader) {
            if (reader != null) {
                this.addParagraph(stringBuffer, this.read(reader));
            }
        }

        void addParagraph(StringBuffer stringBuffer, String string) {
            if (string != null) {
                stringBuffer.append("<p>");
                stringBuffer.append(string);
            }
        }

        void addSmallHeader(StringBuffer stringBuffer, String string) {
            if (string != null) {
                stringBuffer.append("<h5>");
                stringBuffer.append(string);
                stringBuffer.append("</h5>");
            }
        }

        String convertToHTMLContent(String string) {
            string = this.replace(string, '<', "&lt;");
            return this.replace(string, '>', "&gt;");
        }

        void endBulletList(StringBuffer stringBuffer) {
            stringBuffer.append("</ul>");
        }

        void insertPageProlog(StringBuffer stringBuffer, int n) {
            stringBuffer.insert(n, "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
        }

        String read(Reader reader) {
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[2048];
            try {
                int n = reader.read(cArray);
                while (n > 0) {
                    stringBuffer.append(cArray, 0, n);
                    n = reader.read(cArray);
                }
                return stringBuffer.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private String replace(String string, char c, String string2) {
            int n = 0;
            int n2 = string.indexOf(c, n);
            if (n2 == -1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (n2 > -1) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string2);
                n = n2 + 1;
                n2 = string.indexOf(c, n);
            }
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }

        void startBulletList(StringBuffer stringBuffer) {
            stringBuffer.append("<ul>");
        }
    }
}

