/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.StandardPHPElementContentProvider;
import org.eclipse.php.internal.ui.SuperClassTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.swt.widgets.Control;

public class ExplorerContentProvider
extends StandardPHPElementContentProvider
implements ITreeContentProvider,
ModelListener,
IResourceChangeListener {
    protected static final int GRANT_PARENT = 2;
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int PROJECT = 4;
    private Object fInput;
    ExplorerPart fPart;
    private int fPendingChanges;
    TreeViewer fViewer;
    ITreeContentProvider superClassTreeContentProvider = new SuperClassTreeContentProvider(this);

    public ExplorerContentProvider(ExplorerPart explorerPart, boolean bl) {
        super(bl);
        this.fPart = explorerPart;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    public void dataCleared() {
    }

    public void dispose() {
        super.dispose();
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        IResource iResource = PHPModelUtil.getResource((Object)pHPFileData);
        if (iResource != null) {
            this.postRefresh(iResource);
        } else {
            this.postRefresh(pHPFileData);
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        IResource iResource = PHPModelUtil.getResource((Object)pHPFileData);
        if (iResource == null) {
            return;
        }
        this.postRefresh(iResource, true);
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    protected Object[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public Object[] getChildrenInternal(Object object) {
        if (object instanceof PHPWorkspaceModelManager) {
            return this.getAllProjects();
        }
        ArrayList arrayList = new ArrayList(Arrays.asList(super.getChildrenInternal(object)));
        arrayList.addAll(Arrays.asList(this.superClassTreeContentProvider.getChildren(object)));
        return arrayList.toArray();
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.fViewer = (TreeViewer)viewer;
        if (object == null && object2 != null) {
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        } else if (object != null && object2 == null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        }
        this.fInput = object2;
    }

    protected Object internalGetParent(Object object) {
        IResource iResource;
        Object object2 = super.internalGetParent(object);
        if (object2 instanceof PHPFileData && (iResource = PHPModelUtil.getResource((Object)object)) != null && iResource.getProject() != null && iResource.getProject().isAccessible()) {
            return iResource;
        }
        return object2;
    }

    boolean isParent(Object object, Object object2) {
        Object object3 = this.getParent(object2);
        if (object3 == null) {
            return false;
        }
        if (object3.equals(object)) {
            return true;
        }
        return this.isParent(object, object3);
    }

    private void postAdd(final Object object, final Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                if (ExplorerContentProvider.this.fViewer == null) {
                    return;
                }
                if (ExplorerContentProvider.this.fViewer.testFindItem(object2) == null) {
                    ExplorerContentProvider.this.fViewer.add(object, object2);
                }
            }
        });
    }

    private void postProjectStateChanged(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fPart.projectStateChanged(object);
            }
        });
    }

    void postRefresh(final List list, final boolean bl) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = ExplorerContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed() && control.isVisible()) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExplorerContentProvider.this.fViewer.refresh(iterator.next(), bl);
                    }
                }
            }
        });
    }

    public void postRefresh(Object object) {
        if (object instanceof IWorkspaceRoot) {
            object = PHPWorkspaceModelManager.getInstance();
        }
        if (this.isParent(object, this.fInput)) {
            object = this.fInput;
        }
        this.postRefresh(object, true);
    }

    private void postRefresh(final Object object, final boolean bl) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fViewer.refresh(object, bl);
            }
        });
    }

    private void postRemove(final Object object, final Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fViewer.remove(object, new Object[]{object2});
            }
        });
    }

    private void postRunnable(final Runnable runnable) {
        if (this.fViewer == null) {
            return;
        }
        final Control control = this.fViewer.getControl();
        Runnable runnable2 = new Runnable(){

            public void run() {
                try {
                    if (control != null && !control.isDisposed() && control.isVisible()) {
                        runnable.run();
                    }
                }
                finally {
                    ExplorerContentProvider.this.removePendingChange();
                }
            }
        };
        if (control != null && !control.isDisposed()) {
            this.addPendingChange();
            try {
                control.getDisplay().asyncExec(runnable2);
            }
            catch (RuntimeException runtimeException) {
                this.removePendingChange();
                throw runtimeException;
            }
            catch (Error error) {
                this.removePendingChange();
                throw error;
            }
        }
    }

    private boolean processResourceDelta(IResourceDelta iResourceDelta, Object object) {
        IResource iResource;
        int n = iResourceDelta.getKind();
        int n2 = iResourceDelta.getFlags();
        IResource iResource2 = iResourceDelta.getResource();
        if (iResource2 == null) {
            return false;
        }
        if ((n & 2) != 0) {
            iResource = iResource2;
            this.postRemove(object, iResource);
        }
        if ((n & 1) != 0) {
            iResource = iResource2;
            this.postAdd(object, iResource);
        }
        if ((n2 & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(object));
            return true;
        }
        this.processResourceDeltas(iResourceDelta.getAffectedChildren(), iResource2);
        return false;
    }

    private boolean processResourceDeltas(IResourceDelta[] iResourceDeltaArray, Object object) {
        if (iResourceDeltaArray == null) {
            return false;
        }
        if (object instanceof IWorkspaceRoot) {
            object = PHPWorkspaceModelManager.getInstance();
        }
        if (iResourceDeltaArray.length > 1) {
            this.postRefresh(object);
            return true;
        }
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            if (this.processResourceDelta(iResourceDeltaArray[n], object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            IResource iResource = iResourceDelta.getResource();
            this.processResourceDeltas(iResourceDelta.getAffectedChildren(), iResource);
        }
    }
}

