/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaHelperException;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.logging.Level;
import org.eclipse.datatools.connectivity.oda.util.logging.LogManager;
import org.eclipse.datatools.connectivity.oda.util.logging.Logger;
import org.eclipse.osgi.util.NLS;

class OdaObject {
    private Object m_object;
    private boolean m_switchContextClassloader = false;
    private ClassLoader m_driverClassLoader;
    private ClassLoader m_originalClassLoader;
    static final String sm_loggerName = "org.eclipse.datatools.connectivity.oda.consumer";
    private static boolean sm_ThrowExceptionOnly = true;

    public static void setThrowAndSetOdaException() {
        sm_ThrowExceptionOnly = false;
    }

    protected OdaObject() {
    }

    protected OdaObject(boolean switchContextClassloader, ClassLoader driverClassLoader) {
        this.init(null, switchContextClassloader, driverClassLoader, null);
    }

    protected OdaObject(Object wrappedObj, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        this.init(wrappedObj, switchContextClassloader, driverClassLoader, null);
    }

    protected OdaObject(Object wrappedObj, boolean switchContextClassloader, ClassLoader driverClassLoader, ClassLoader originalContextClassLoader) {
        this.init(wrappedObj, switchContextClassloader, driverClassLoader, originalContextClassLoader);
    }

    private void init(Object wrappedObj, boolean switchContextClassloader, ClassLoader driverClassLoader, ClassLoader originalContextClassLoader) {
        this.m_object = wrappedObj;
        this.m_originalClassLoader = originalContextClassLoader;
        this.m_switchContextClassloader = switchContextClassloader;
        if (driverClassLoader != null) {
            this.setDriverClassLoader(driverClassLoader);
        }
    }

    protected void setDriverClassLoader(ClassLoader classloader) {
        if (this.m_driverClassLoader == classloader) {
            return;
        }
        String context = "setDriverClassLoader( " + classloader + " )\t";
        this.cacheOriginalClassLoader(context);
        this.m_driverClassLoader = classloader;
    }

    protected ClassLoader getDriverClassLoader() {
        return this.m_driverClassLoader;
    }

    private void cacheOriginalClassLoader(String context) {
        if (this.m_originalClassLoader != null) {
            return;
        }
        try {
            this.m_originalClassLoader = Thread.currentThread().getContextClassLoader();
            this.log(context, "Current thread's original context class loader: " + this.m_originalClassLoader);
        }
        catch (RuntimeException e) {
            this.logWarning(context, "Unable to get current thread's context class loader: " + e.toString());
        }
    }

    protected ClassLoader getOriginalContextClassLoader() {
        return this.m_originalClassLoader;
    }

    protected void setUseContextClassLoaderSwitch(boolean needSwitch) {
        this.m_switchContextClassloader = needSwitch;
    }

    protected boolean switchContextClassloader() {
        return this.m_switchContextClassloader;
    }

    protected void setObject(Object obj) {
        this.m_object = obj;
    }

    protected Object getObject() {
        return this.m_object;
    }

    protected void setContextClassloader() {
        if (!this.m_switchContextClassloader || this.m_driverClassLoader == null) {
            return;
        }
        String context = "setContextClassloader()";
        this.cacheOriginalClassLoader("setContextClassloader()");
        try {
            Thread.currentThread().setContextClassLoader(this.m_driverClassLoader);
        }
        catch (SecurityException e) {
            this.m_switchContextClassloader = false;
            this.logWarning("setContextClassloader()", "Unable to set current thread's context class loader; disabled switching. " + e.toString());
        }
    }

    protected void resetContextClassloader() {
        if (!this.m_switchContextClassloader) {
            return;
        }
        String context = "resetContextClassloader()";
        try {
            ClassLoader originalLoader = this.m_originalClassLoader != null ? this.m_originalClassLoader : this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
        catch (SecurityException e) {
            this.m_switchContextClassloader = false;
            this.logWarning("resetContextClassloader()", "Unable to set/reset current thread's context class loader; disabled switching. " + e.toString());
        }
    }

    protected String getClassName() {
        String fullClassName = this.getClass().getName();
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public Object findAndInvokeMethod(String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, OdaException {
        return this.findAndInvokeMethod(methodName, parameterTypes, args, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object findAndInvokeMethod(String methodName, Class[] parameterTypes, Object[] args, boolean bypassJavaAccessChecks, boolean doSetContextClassloader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, OdaException {
        ClassLoader prevClassLoader = null;
        try {
            if (doSetContextClassloader && this.switchContextClassloader()) {
                doSetContextClassloader = false;
            }
            if (doSetContextClassloader) {
                prevClassLoader = this.getDriverClassLoader();
                this.setUseContextClassLoaderSwitch(true);
                this.setDriverClassLoader(this.m_object.getClass().getClassLoader());
                this.setContextClassloader();
            }
            Class<?> objClass = this.m_object.getClass();
            Method method = objClass.getMethod(methodName, parameterTypes);
            if (bypassJavaAccessChecks && !method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException ex) {
                    this.handleError(this.newOdaException(Messages.helper_inadequatePermissionsForCompatibility, ex, method.toString()));
                }
            }
            Object object = method.invoke(this.m_object, args);
            Object var11_11 = null;
            if (doSetContextClassloader) {
                this.resetContextClassloader();
                this.setDriverClassLoader(prevClassLoader);
                this.setUseContextClassLoaderSwitch(false);
            }
            return object;
        }
        catch (Throwable throwable) {
            block8: {
                Object var11_12 = null;
                if (!doSetContextClassloader) break block8;
                this.resetContextClassloader();
                this.setDriverClassLoader(prevClassLoader);
                this.setUseContextClassLoaderSwitch(false);
            }
            throw throwable;
        }
    }

    protected void handleError(RuntimeException exception) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.severe((Throwable)exception);
        }
        throw exception;
    }

    protected void handleError(OdaException exception) throws OdaException {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.severe((Throwable)exception);
        }
        if (sm_ThrowExceptionOnly) {
            throw exception;
        }
    }

    protected int handleErrorAndReturnZero(RuntimeException rtException) {
        this.handleError(rtException);
        return 0;
    }

    protected int handleErrorAndReturnZero(OdaException exception) throws OdaException {
        this.handleError(exception);
        return 0;
    }

    protected int handleErrorAndReturnNegOne(RuntimeException rtException) {
        this.handleError(rtException);
        return -1;
    }

    protected int handleErrorAndReturnNegOne(OdaException exception) throws OdaException {
        this.handleError(exception);
        return -1;
    }

    protected String handleErrorAndReturnEmptyString(RuntimeException rtException) {
        this.handleError(rtException);
        return "";
    }

    protected String handleErrorAndReturnEmptyString(OdaException exception) throws OdaException {
        this.handleError(exception);
        return "";
    }

    protected boolean handleErrorAndReturnFalse(RuntimeException rtException) {
        this.handleError(rtException);
        return false;
    }

    protected boolean handleErrorAndReturnFalse(OdaException exception) throws OdaException {
        this.handleError(exception);
        return false;
    }

    protected int handleErrorAndReturnTypeNull(RuntimeException rtException) {
        this.handleError(rtException);
        return 0;
    }

    protected int handleErrorAndReturnTypeNull(OdaException exception) throws OdaException {
        this.handleError(exception);
        return 0;
    }

    protected void handleUnsupportedOp(UnsupportedOperationException exception, String context) {
        String exceptionMsg;
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.severe((Throwable)exception);
        }
        exception = (exceptionMsg = exception.getLocalizedMessage()) == null || exceptionMsg.length() == 0 ? new UnsupportedOperationException(context) : exception;
        throw exception;
    }

    protected int handleUnsupportedOpAndRetZero(UnsupportedOperationException exception, String context) {
        this.handleUnsupportedOp(exception, context);
        return 0;
    }

    protected boolean handleUnsupportedOpAndRetFalse(UnsupportedOperationException exception, String context) {
        this.handleUnsupportedOp(exception, context);
        return false;
    }

    protected String handleUnsupportedOpAndRetEmptyString(UnsupportedOperationException exception, String context) {
        this.handleUnsupportedOp(exception, context);
        return "";
    }

    protected int handleUnsupportedOpAndRetTypeNull(UnsupportedOperationException exception, String context) {
        this.handleUnsupportedOp(exception, context);
        return 0;
    }

    protected boolean isLoggable(Level level) {
        Logger logger = this.getLogger();
        return logger != null ? logger.isLoggable(level) : false;
    }

    private Logger getLogger() {
        return LogManager.getLogger((String)sm_loggerName);
    }

    protected void logUnsupportedOp(UnsupportedOperationException exception, String context) {
        Logger logger = this.getLogger();
        if (logger != null) {
            String logMsg = exception.getLocalizedMessage();
            logMsg = logMsg == null || logMsg.length() == 0 ? context : context + ": " + logMsg;
            logger.warning(logMsg);
        }
    }

    protected void log(String context, String msg) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.fine(context + msg);
        }
    }

    protected void logWarning(String context, String msg) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.warning(context + msg);
        }
    }

    protected void logMethodExitWithReturn(String context, int i) {
        this.logMethodExitWithReturn(context, new Integer(i));
    }

    protected void logMethodExitWithReturn(String context, double d) {
        this.logMethodExitWithReturn(context, new Double(d));
    }

    protected void logMethodExitWithReturn(String context, boolean b) {
        this.logMethodExitWithReturn(context, b ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void logMethodCalled(String context) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.fine(context + "Called.");
        }
    }

    protected void logMethodExit(String context) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.fine(context + "Exiting.");
        }
    }

    protected void logMethodExitWithReturn(String context, Object obj) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.fine(context + "Returns [ " + obj + " ]");
        }
    }

    protected void logMethodExitWithReturnLen(String context, String obj) {
        Logger logger = this.getLogger();
        if (logger != null) {
            if (obj != null) {
                logger.fine(context + "Returns a string with length [" + obj.length() + "]");
            } else {
                logger.fine(context + "Returns string [ null ]");
            }
        }
    }

    protected void logMethodNotImplemented(String context, String interfaceMethodSignature) {
        if (this.isLoggable(Level.FINE_LEVEL)) {
            this.log(context, this.formatMethodNotImplementedMsg(interfaceMethodSignature));
        }
    }

    protected String formatMethodNotImplementedMsg(String interfaceMethodSignature) {
        return NLS.bind((String)Messages.helper_methodNotImplemented, (Object)interfaceMethodSignature);
    }

    protected OdaException newOdaException(String errorMsg) {
        return new OdaHelperException(errorMsg, null);
    }

    protected OdaException newOdaException(String errorMsg, Throwable cause) {
        OdaException odaEx = this.newOdaException(errorMsg);
        odaEx.initCause(cause);
        return odaEx;
    }

    OdaException newOdaException(String errorMsg, Throwable cause, String appendInfo) {
        OdaHelperException odaEx = new OdaHelperException(errorMsg, appendInfo);
        odaEx.initCause(cause);
        return odaEx;
    }
}

